/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.pcf.event.PCFFilter;

public class AttrTypeObject
extends AttrTypeWMQName {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeObject.java";
    private static final String WHERE_TYPE_STRING = "STRING";
    private static final int TYPE_STRING = 0;
    private static final String WHERE_TYPE_INTEGER = "INT";
    private static final int TYPE_INTEGER = 1;
    private static final String WHERE_TYPE_BYTE_ARRAY = "BYTEARRAY";
    private static final int TYPE_BYTE_ARRAY = 2;
    private DmObjectFilter dmObjectFilter = null;
    private boolean isSelectOnly = false;
    private String infopopId;

    public AttrTypeObject(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int l, String regExp, String pcfFilterName, Integer pcfFilterObjType, Integer pcfFilterObjSubtype, Integer pcfFilterWhereId, Integer pcfFilterWhereOp, Object pcfFilterWhereValue, String pcfFilterWhereType, boolean isSelOnly) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, l, regExp);
        this.setAttributeType(t, 26);
        this.isSelectOnly = isSelOnly;
        this.createDmObjectFilter(t, pcfFilterName, pcfFilterObjType, pcfFilterObjSubtype, pcfFilterWhereId, pcfFilterWhereOp, pcfFilterWhereValue, pcfFilterWhereType);
    }

    public AttrTypeObject(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int l, String regExp, String pcfFilterName, Integer pcfFilterObjType, Integer pcfFilterObjSubtype, Integer pcfFilterWhereId, Integer pcfFilterWhereOp, Object pcfFilterWhereValue, String pcfFilterWhereType, boolean isSelOnly, String infoId) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, l, regExp);
        this.setAttributeType(t, 26);
        this.isSelectOnly = isSelOnly;
        this.infopopId = infoId;
        this.createDmObjectFilter(t, pcfFilterName, pcfFilterObjType, pcfFilterObjSubtype, pcfFilterWhereId, pcfFilterWhereOp, pcfFilterWhereValue, pcfFilterWhereType);
    }

    public AttrTypeObject(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int l, String pcfFilterName, Integer pcfFilterObjType, Integer pcfFilterObjSubtype, Integer pcfFilterWhereId, Integer pcfFilterWhereOp, Object pcfFilterWhereValue, String pcfFilterWhereType, boolean isSelOnly) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, l);
        this.setAttributeType(t, 26);
        this.isSelectOnly = isSelOnly;
        this.createDmObjectFilter(t, pcfFilterName, pcfFilterObjType, pcfFilterObjSubtype, pcfFilterWhereId, pcfFilterWhereOp, pcfFilterWhereValue, pcfFilterWhereType);
    }

    public AttrTypeObject(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int l, String pcfFilterName, Integer pcfFilterObjType, Integer pcfFilterObjSubtype, Integer pcfFilterWhereId, Integer pcfFilterWhereOp, Object pcfFilterWhereValue, String pcfFilterWhereType, boolean isSelOnly) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, l);
        this.setAttributeType(t, 26);
        this.isSelectOnly = isSelOnly;
        this.createDmObjectFilter(t, pcfFilterName, pcfFilterObjType, pcfFilterObjSubtype, pcfFilterWhereId, pcfFilterWhereOp, pcfFilterWhereValue, pcfFilterWhereType);
    }

    private void createDmObjectFilter(Trace t, String pcfFilterName, Integer pcfFilterObjType, Integer pcfFilterObjSubtype, Integer pcfFilterWhereId, Integer pcfFilterWhereOp, Object pcfFilterWhereValue, String pcfFilterWhereType) {
        PCFFilter pcfFilter = null;
        String filterName = pcfFilterName;
        if (pcfFilterName == null) {
            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 0, 50006, "null pcfFilterName specified");
            filterName = "*";
        }
        if (pcfFilterName.length() == 0) {
            filterName = "*";
        }
        int filterObjType = -1;
        if (pcfFilterObjType == null) {
            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 1, 50006, "null pcfFilterObjType specified");
        } else {
            filterObjType = pcfFilterObjType;
        }
        int filterObjSubtype = -1;
        if (pcfFilterObjSubtype != null) {
            filterObjSubtype = pcfFilterObjSubtype;
        }
        int whereId = -1;
        int whereOp = -1;
        Object whereValue = null;
        if (pcfFilterWhereId != null) {
            whereId = pcfFilterWhereId;
            if (pcfFilterWhereOp != null) {
                whereOp = pcfFilterWhereOp;
                switch (whereOp) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 10: 
                    case 13: 
                    case 18: 
                    case 21: 
                    case 26: 
                    case 29: {
                        break;
                    }
                    default: {
                        t.FFST(65, "AttrTypeObject.createDmObjectFilter", 2, 50006, "invalid pcfFilterWhereOp specified");
                        whereOp = 2;
                    }
                }
            }
            int whereValueType = 0;
            if (pcfFilterWhereType != null) {
                if (pcfFilterWhereType.compareTo(WHERE_TYPE_STRING) == 0) {
                    whereValueType = 0;
                } else if (pcfFilterWhereType.compareTo(WHERE_TYPE_INTEGER) == 0) {
                    whereValueType = 1;
                } else if (pcfFilterWhereType.compareTo(WHERE_TYPE_BYTE_ARRAY) == 0) {
                    whereValueType = 2;
                }
            }
            if (pcfFilterWhereValue != null) {
                switch (whereValueType) {
                    case 1: {
                        if (pcfFilterWhereValue instanceof Integer) {
                            whereValue = pcfFilterWhereValue;
                            pcfFilter = new PCFFilter(whereId, whereOp, ((Integer)whereValue).intValue());
                            break;
                        }
                        try {
                            whereValue = Integer.valueOf(whereValue.toString());
                            pcfFilter = new PCFFilter(whereId, whereOp, ((Integer)whereValue).intValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 3, 50006, "NumberFormatException from pcfFilterWhereValue");
                        }
                        break;
                    }
                    case 2: {
                        whereValue = pcfFilterWhereValue;
                        String whereValueString = whereValue.toString();
                        int len = whereValueString.length();
                        if (len % 2 == 1) {
                            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 4, 50006, "odd length where value specified for BYTEARRAY");
                            break;
                        }
                        int pairs = len / 2;
                        byte[] byteArray = new byte[pairs];
                        int i = 0;
                        while (i < pairs) {
                            byteArray[i] = 0;
                            ++i;
                        }
                        try {
                            i = 0;
                            while (i < pairs) {
                                String element = whereValueString.substring(i * 2, i * 2 + 2);
                                Integer integer = Integer.parseInt(element, 16);
                                byteArray[i] = integer.byteValue();
                                ++i;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 5, 50006, "NumberFormatException from pcfFilterWhereValue");
                        }
                        pcfFilter = new PCFFilter(whereId, whereOp, byteArray);
                        break;
                    }
                    default: {
                        whereValue = pcfFilterWhereValue;
                        pcfFilter = new PCFFilter(whereId, whereOp, whereValue.toString());
                    }
                }
                if (pcfFilter == null) {
                    t.FFST(65, "AttrTypeObject.createDmObjectFilter", 6, 50006, "Failed to create PCFFilter");
                }
            }
        }
        this.dmObjectFilter = pcfFilter == null ? (filterObjSubtype != -1 ? new DmObjectFilter(t, filterName, filterObjType, filterObjSubtype) : new DmObjectFilter(t, filterName, filterObjType)) : (filterObjSubtype != -1 ? new DmObjectFilter(t, filterName, filterObjType, filterObjSubtype, pcfFilter) : new DmObjectFilter(t, filterName, filterObjType, pcfFilter));
        if (this.dmObjectFilter == null) {
            t.FFST(65, "AttrTypeObject.createDmObjectFilter", 6, 50006, "Failed to create dmObjectFilter");
        }
    }

    public DmObjectFilter getDmObjectFilter() {
        return this.dmObjectFilter;
    }

    public boolean isSelectOnly() {
        return this.isSelectOnly;
    }

    public String getInfopopId() {
        return this.infopopId;
    }
}

