/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import java.util.ArrayList;

public class AttrTypeIntArrayEnumRange
extends AttrTypeIntArrayEnum {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeIntArrayEnumRange.java";
    private int minimumValue = 0;
    private int maximumValue = 0;

    public AttrTypeIntArrayEnumRange(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int[] keys, String[] values, int min, int max) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, keys, values);
        this.setAttributeType(t, 22);
        this.minimumValue = min;
        this.maximumValue = max;
    }

    public AttrTypeIntArrayEnumRange(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int[] keys, String[] values, int min, int max) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, keys, values, min, max);
    }

    public AttrTypeIntArrayEnumRange(Trace t, String resource_stem, int grpseq, DisplayGroup grp, boolean rw, boolean rwoc, int min, int max) {
        this(t, resource_stem, grpseq, grp, 0, 0, 0, false, rw, rwoc, new int[0], new String[0], min, max);
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        String newValue2;
        if (attr1.getAttrType().getAttributeType() != attr2.getAttrType().getAttributeType()) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeIntArrayEnumRange.equals", 900, "The attribute types for attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not the same");
            }
            return false;
        }
        String newValue1 = attr1.toString(t);
        if (newValue1.equals(newValue2 = attr2.toString(t))) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeIntArrayEnumRange.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
            }
            return true;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeIntArrayEnumRange.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
        }
        return false;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        Integer val = (Integer)o;
        boolean result = false;
        boolean ok = super.validate(t, attr, o);
        if (ok) {
            result = true;
        } else if (val != null) {
            int v = val;
            result = v > this.maximumValue ? false : v >= this.minimumValue;
        }
        if (!result) {
            t.data(65, "AttrTypeIntArrayEnumRange.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " failed validation");
            return false;
        }
        t.data(65, "AttrTypeIntArrayEnumRange.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " passed validation");
        return true;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    protected String formatString(Trace t, ArrayList list, String delimeter) {
        StringBuffer retValue = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            String value = this.getEnumeratedValue(t, (Integer)list.get(i));
            if (!value.equals("[not_found]")) {
                if (retValue.length() > 0) {
                    retValue = retValue.append(delimeter);
                }
                retValue = retValue.append(value);
            } else {
                if (retValue.length() > 0) {
                    retValue = retValue.append(delimeter);
                }
                Integer num = (Integer)list.get(i);
                retValue = retValue.append(num.toString());
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println("          min: " + this.minimumValue);
        System.out.println("          max: " + this.maximumValue);
    }
}

