/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AttrTypeIntArrayEnum
extends AttrTypeIntArray {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeIntArrayEnum.java";
    private Hashtable enumerations = null;
    private boolean sortByInt = false;
    private boolean isUnique = false;
    private boolean unique = false;
    protected static final int ALL_ITEMS = -1;
    private int itemCount = -1;

    public AttrTypeIntArrayEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int[] keys, String[] values) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 18);
        if (keys != null && values != null) {
            if (keys.length == values.length) {
                int i = 0;
                while (i < keys.length) {
                    if (resource_stem == null || resource_stem.equals("")) {
                        this.addEnumeration(t, keys[i], values[i]);
                    } else {
                        this.addEnumeration(t, keys[i], CoreServices.message.getMessage(t, String.valueOf(values[i]) + ".title"));
                    }
                    ++i;
                }
            }
        } else if (keys == null) {
            // empty if block
        }
    }

    public AttrTypeIntArrayEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int[] keys, String[] values) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, keys, values);
    }

    public AttrTypeIntArrayEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, boolean rw, boolean rwoc) {
        this(t, resource_stem, grpseq, grp, 0, 0, 0, false, rw, rwoc, new int[0], new String[0]);
    }

    private boolean addEnumeration(Trace t, Integer key, String value) {
        if (this.enumerations == null) {
            this.enumerations = new Hashtable();
        }
        try {
            this.enumerations.put(key, value);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public Hashtable getEnumerations() {
        return this.enumerations;
    }

    public Integer[] getEnumerationIds(Trace t) {
        Integer[] ids = null;
        int index = 0;
        if (this.enumerations.size() > 0) {
            ids = new Integer[this.enumerations.size()];
            Set k = this.enumerations.keySet();
            Iterator i = k.iterator();
            while (i.hasNext()) {
                Integer key;
                ids[index] = key = (Integer)i.next();
                ++index;
            }
        }
        return ids;
    }

    public String getEnumeratedValue(Trace t, Integer key) {
        String retValue = (String)this.enumerations.get(key);
        if (retValue == null) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeIntArrayEnum.getEnumeratedValue", 900, "Key not found : " + key);
            }
            return "[not_found]";
        }
        return retValue;
    }

    public String getEnumeratedValue(Trace t, ArrayList list) {
        String retValue = this.formatString(t, list, ",");
        return retValue.toString();
    }

    public void setSortByInt(Trace t, boolean b) {
        this.sortByInt = b;
    }

    protected String toString(Trace t, Integer i) {
        return this.toString(t, i, false);
    }

    protected String toString(Trace t, Integer i, boolean ebcdic) {
        return this.getEnumeratedValue(t, i);
    }

    protected String toString(Trace t, Integer i, String charSet, int length) {
        return this.getEnumeratedValue(t, i);
    }

    @Override
    public String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    public String toString(Trace t, Attr attr, boolean ebcdic) {
        return this.getEnumeratedValue(t, (ArrayList)attr.getValue(t));
    }

    @Override
    public String toString(Trace t, Attr attr, String charSet, int length) {
        return this.getEnumeratedValue(t, (ArrayList)attr.getValue(t));
    }

    protected String formatString(Trace t, ArrayList list, String delimeter) {
        StringBuffer retValue = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            String value = this.getEnumeratedValue(t, (Integer)list.get(i));
            if (!value.equals("[not_found]")) {
                if (retValue.length() > 0) {
                    retValue = retValue.append(delimeter);
                }
                retValue = retValue.append(value);
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedString(t, attr, "500", -1);
        }
        return this.toFormattedString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, String charSet, int length) {
        ArrayList list = (ArrayList)attr.getValue(t);
        String retValue = this.formatString(t, list, "\n");
        return retValue;
    }

    @Override
    public String toDefaultString(Trace t) {
        return this.toDefaultString(t, false);
    }

    @Override
    public String toDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toDefaultString(t, "500", -1);
        }
        return this.toDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toDefaultString(Trace t, String charSet, int length) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        ArrayList list = (ArrayList)this.getDefaultValue(t);
        String retValue = this.formatString(t, list, ",");
        return retValue;
    }

    @Override
    public String toFormattedDefaultString(Trace t) {
        return this.toFormattedDefaultString(t, false);
    }

    @Override
    public String toFormattedDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedDefaultString(t, "500", -1);
        }
        return this.toFormattedDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toFormattedDefaultString(Trace t, String charSet, int length) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        ArrayList list = (ArrayList)this.getDefaultValue(t);
        String retValue = this.formatString(t, list, "\n");
        return retValue;
    }

    public boolean isSortByInt(Trace t) {
        return this.sortByInt;
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        String newValue2;
        if (attr1.getAttrType().getAttributeType() != attr2.getAttrType().getAttributeType()) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeIntArrayEnum.equals", 900, "The attribute types for attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not the same");
            }
            return false;
        }
        String newValue1 = attr1.toString(t);
        if (newValue1.equals(newValue2 = attr2.toString(t))) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeIntArrayEnum.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
            }
            return true;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeIntArrayEnum.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
        }
        return false;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        ArrayList list = (ArrayList)o;
        ArrayList<Integer> tempList = new ArrayList<Integer>(10);
        int i = 0;
        while (i < list.size()) {
            String newValue;
            Integer key = (Integer)list.get(i);
            if (this.unique) {
                if (tempList.contains(key)) {
                    if (Trace.isTracing) {
                        t.data(65, "AttrTypeIntArrayEnum.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " failed validation");
                    }
                    return false;
                }
                tempList.add(key);
            }
            if ((newValue = this.getEnumeratedValue(t, key)).equals("[not_found]")) {
                t.data(65, "AttrTypeIntArrayEnum.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " failed validation");
                return false;
            }
            ++i;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeIntArrayEnum.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " passed validation");
        }
        return true;
    }

    public boolean isUnique(Trace t) {
        return this.isUnique;
    }

    public void setItemCount(Trace t, int i) {
        this.itemCount = i;
    }

    public int getItemCount(Trace t) {
        return this.itemCount;
    }

    public void setUnique(Trace t, boolean b) {
        this.isUnique = b;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println("  sort by int: " + this.sortByInt);
        Enumeration e = this.enumerations.keys();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            System.out.println("        value: " + i.toString() + "=" + this.enumerations.get(i));
        }
    }
}

