/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import java.util.ArrayList;

public class AttrTypeFixedLengthStringListItem
extends AttrTypeStringArray {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeFixedLengthStringListItem.java";
    private int total_length = 0;

    public AttrTypeFixedLengthStringListItem(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int l, int tot, int maxNumberOfItems) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, "", l, -1, maxNumberOfItems);
        this.total_length = tot;
        this.setAttributeType(t, 8);
    }

    public AttrTypeFixedLengthStringListItem(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int l, int tot, int maxNumberOfItems) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, l, tot, maxNumberOfItems);
    }

    public int getTotalLength() {
        return this.total_length;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        boolean valid = super.validate(t, attr, o);
        int newLength = 0;
        ArrayList al1 = (ArrayList)o;
        for (String a : al1) {
            newLength += a.length();
        }
        if (newLength > this.total_length) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeFixedLengthStringListItem.validate", 900, "The value of attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " will exceed the total length");
            }
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println(" total_length: " + this.total_length);
    }
}

