/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AttrTypeFixedLengthStringEnum
extends AttrTypeFixedLengthString {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeFixedLengthStringEnum.java";
    private Hashtable<String, String> enumerations = null;
    private Set<String> supersededKeys = null;

    public AttrTypeFixedLengthStringEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int l, String[] keys, String[] values, Set<String> supersededKeys, String regExp) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, l, regExp);
        this.setAttributeType(t, 9);
        if (keys != null && values != null) {
            if (keys.length == values.length) {
                int i = 0;
                while (i < keys.length) {
                    if (resource_stem == null || resource_stem.equals("")) {
                        this.addEnumeration(t, keys[i], values[i]);
                    } else {
                        this.addEnumeration(t, keys[i], CoreServices.message.getMessage(t, String.valueOf(values[i]) + ".title"));
                    }
                    ++i;
                }
                this.supersededKeys = supersededKeys;
            }
        } else if (keys == null) {
            // empty if block
        }
    }

    public AttrTypeFixedLengthStringEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int l, String[] keys, String[] values, Set<String> supersededKeys) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, l, keys, values, supersededKeys, null);
    }

    public String[] getEnumerationIds(Trace t) {
        String[] ids = null;
        int index = 0;
        if (this.enumerations.size() > 0) {
            ids = new String[this.enumerations.size()];
            Set<String> k = this.enumerations.keySet();
            Iterator<String> i = k.iterator();
            while (i.hasNext()) {
                String key;
                ids[index] = key = i.next();
                ++index;
            }
        }
        return ids;
    }

    public boolean hasBeenSuperseded(Trace t, String id) {
        if (this.supersededKeys == null) {
            return false;
        }
        return this.supersededKeys.contains(id);
    }

    public void clearEnumerations(Trace t) {
        if (this.enumerations != null) {
            this.enumerations.clear();
        }
    }

    public boolean addEnumeration(Trace t, String key, String value) {
        if (this.enumerations == null) {
            this.enumerations = new Hashtable();
        }
        try {
            this.enumerations.put(key, value);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public String getEnumeratedValue(Trace t, String key) {
        String retValue = this.enumerations.get(key);
        if (retValue == null) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeFixedLengthStringEnum.getEnumeratedValue", 900, "Key not found : " + key);
            }
            return key;
        }
        return retValue;
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        String newValue2;
        if (attr1.getAttrType().getAttributeType() != attr2.getAttrType().getAttributeType()) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeFixedLengthStringEnum.equals", "The attribute types for attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not the same");
            }
            return false;
        }
        String key1 = (String)((AttrString)attr1).getValue(t);
        String key2 = (String)((AttrString)attr2).getValue(t);
        String newValue1 = this.getEnumeratedValue(t, key1);
        if (newValue1.equals(newValue2 = this.getEnumeratedValue(t, key2))) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeFixedLengthStringEnum.equals", 900, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
            }
            return true;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeFixedLengthStringEnum.equals", 900, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
        }
        return false;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        String key = (String)o;
        this.getEnumeratedValue(t, key);
        if (key.equals("[not_found]")) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeFixedLengthStringEnum.validate", 300, "Attribute id " + attr.getAttributeID() + " failed validation");
            }
            return false;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeFixedLengthStringEnum.validate", 300, "Attribute id " + attr.getAttributeID() + " passed validation");
        }
        return true;
    }

    @Override
    public String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    public String toString(Trace t, Attr attr, boolean ebcdic) {
        return this.getEnumeratedValue(t, (String)((AttrString)attr).getValue(t));
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        String[] keys = this.getEnumerationIds(t);
        int i = 0;
        while (i < keys.length) {
            System.out.println("        value: '" + this.getEnumeratedValue(t, keys[i]) + "'");
            ++i;
        }
    }

    public String getEnumerationId(Trace t, Object value) {
        String retValue = null;
        if (this.enumerations.size() > 0 && this.enumerations.containsValue(value)) {
            Set<String> k = this.enumerations.keySet();
            for (String key : k) {
                if (!value.equals(this.enumerations.get(key))) continue;
                retValue = key;
                break;
            }
        }
        return retValue;
    }
}

