/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBitEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeQueueManagerUrid;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeURL;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeUnsignedInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.ParseUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class AttrTypeFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeFactory.java";
    public static final String TYPE_FIXEDSTR = "FIXEDSTR";
    public static final String TYPE_FIXEDSTRLISTITEM = "FIXEDSTRLISTITEM";
    public static final String TYPE_FIXEDWMQNAMELISTITEM = "FIXEDWMQNAMELISTITEM";
    public static final String TYPE_FIXEDSTRENUM = "FIXEDSTRENUM";
    public static final String TYPE_FIXEDSTRENUMRANGE = "FIXEDSTRENUMRANGE";
    public static final String TYPE_WMQNAME = "WMQNAME";
    public static final String TYPE_INT = "INT";
    public static final String TYPE_UINT = "UINT";
    public static final String TYPE_ENUM = "ENUM";
    public static final String TYPE_RANGE = "RANGE";
    public static final String TYPE_LONGRANGE = "LONGRANGE";
    public static final String TYPE_ENUMRANGE = "ENUMRANGE";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_BYTEARRAY = "BYTEARRAY";
    public static final String TYPE_QMGRURID = "QMGRURID";
    public static final String TYPE_STRINGARRAY = "STRINGARRAY";
    public static final String TYPE_INTARRAY = "INTARRAY";
    public static final String TYPE_INTARRAYENUM = "INTARRAYENUM";
    public static final String TYPE_INTARRAYENUMRANGE = "INTARRAYENUMRANGE";
    public static final String TYPE_BITENUM = "BITENUM";
    public static final String TYPE_DATETIME = "DATETIME";
    public static final String TYPE_LONG = "LONG";
    public static final String TYPE_URL = "URL";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_OBJECT = "OBJECT";
    public static final String TYPE_LONGENUM = "LONGENUM";
    public static final String TYPE_LONGENUMRANGE = "LONGENUMRANGE";
    private String XML_DELIMITER = ",";
    private String STRING_TYPE = "STR";
    private int commandLvl = -1;
    private int platform = -1;

    public AttrTypeFactory(Trace t, int commandLvl, int platform) {
        this.commandLvl = commandLvl;
        this.platform = platform;
    }

    public AttrType create(Trace t, Attribute attr) {
        AttrType at = null;
        String type = attr.getType(t).toUpperCase();
        if (type != null) {
            if (attr.isValid(t, this.commandLvl, this.platform)) {
                if (type.compareTo(TYPE_INT) == 0) {
                    at = new AttrTypeInt(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_STRING) == 0) {
                    at = new AttrTypeString(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getRegExp(t, this.commandLvl, this.platform));
                    ((AttrTypeString)at).setTrimmed(attr.getTrimmed(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_LONG) == 0) {
                    at = new AttrTypeLong(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_UINT) == 0) {
                    at = new AttrTypeUnsignedInt(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_URL) == 0) {
                    at = new AttrTypeURL(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_BOOLEAN) == 0) {
                    at = new AttrTypeBoolean(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_QMGRURID) == 0) {
                    at = new AttrTypeQueueManagerUrid(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_BYTEARRAY) == 0) {
                    at = new AttrTypeByteArray(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_STRINGARRAY) == 0) {
                    at = new AttrTypeStringArray(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getRegExp(t, this.commandLvl, this.platform), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getMinLen(t, this.commandLvl, this.platform), attr.getItemCount(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_INTARRAY) == 0) {
                    at = new AttrTypeIntArray(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t));
                } else if (type.compareTo(TYPE_FIXEDSTR) == 0) {
                    at = new AttrTypeFixedLengthString(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getRegExp(t, this.commandLvl, this.platform));
                    ((AttrTypeFixedLengthString)at).setPassword(t, attr.getPassword(t, this.commandLvl, this.platform));
                    ((AttrTypeFixedLengthString)at).setTrimmed(attr.getTrimmed(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_FIXEDSTRLISTITEM) == 0) {
                    at = new AttrTypeFixedLengthStringListItem(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getTotLen(t, this.commandLvl, this.platform), attr.getItemCount(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_FIXEDWMQNAMELISTITEM) == 0) {
                    at = new AttrTypeFixedLengthWMQNameListItem(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getTotLen(t, this.commandLvl, this.platform), attr.getItemCount(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_FIXEDSTRENUM) == 0) {
                    at = new AttrTypeFixedLengthStringEnum(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getEnumStringNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform), attr.getEnumSupersededValues(t, this.commandLvl, this.platform));
                    ((AttrTypeFixedLengthStringEnum)at).setTrimmed(attr.getTrimmed(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_FIXEDSTRENUMRANGE) == 0) {
                    at = new AttrTypeFixedLengthStringEnumRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getEnumStringNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform), attr.getRegExp(t, this.commandLvl, this.platform));
                    ((AttrTypeFixedLengthStringEnumRange)at).setTrimmed(attr.getTrimmed(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_ENUM) == 0) {
                    at = new AttrTypeEnum(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_BITENUM) == 0) {
                    at = new AttrTypeBitEnum(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_LONGENUM) == 0) {
                    at = new AttrTypeBitEnum(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_RANGE) == 0) {
                    at = new AttrTypeRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMin(t, this.commandLvl, this.platform), attr.getMax(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_LONGRANGE) == 0) {
                    at = new AttrTypeLongRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getLongMin(t, this.commandLvl, this.platform), attr.getLongMax(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_ENUMRANGE) == 0) {
                    at = new AttrTypeEnumRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform), attr.getMin(t, this.commandLvl, this.platform), attr.getMax(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_LONGENUMRANGE) == 0) {
                    at = new AttrTypeLongEnumRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform), attr.getLongMin(t, this.commandLvl, this.platform), attr.getLongMax(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_INTARRAYENUM) == 0) {
                    at = new AttrTypeIntArrayEnum(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform));
                    ((AttrTypeIntArrayEnum)at).setItemCount(t, attr.getItemCount(t, this.commandLvl, this.platform));
                    ((AttrTypeIntArrayEnum)at).setUnique(t, attr.getUnique(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_INTARRAYENUMRANGE) == 0) {
                    at = new AttrTypeIntArrayEnumRange(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getEnumNames(t, this.commandLvl, this.platform), attr.getEnumValues(t, this.commandLvl, this.platform), attr.getMin(t, this.commandLvl, this.platform), attr.getMax(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_OBJECT) == 0) {
                    at = new AttrTypeObject(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getRegExp(t, this.commandLvl, this.platform), attr.getFilterName(t), attr.getFilterType(t), attr.getFilterSubType(t), attr.getWhereId(t), attr.getWhereOp(t), attr.getWhereVal(t), attr.getWhereType(t), attr.getSelectOnly(t, this.commandLvl, this.platform), attr.getInfoPopId(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_WMQNAME) == 0) {
                    at = new AttrTypeWMQName(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getRegExp(t, this.commandLvl, this.platform));
                    ((AttrTypeWMQName)at).setTrimmed(attr.getTrimmed(t, this.commandLvl, this.platform));
                } else if (type.compareTo(TYPE_DATETIME) == 0) {
                    at = new AttrTypeDateTime(t, attr.getValue(t), attr.getSequence(t), attr.getDisplayGroup(t), attr.getDistributedSequence(t), attr.getZosSequence(t), attr.getPCFType(t), attr.getRepeatingValue(t), attr.getReadWrite(t), attr.getReadWriteOnCreate(t), attr.getMaxLen(t, this.commandLvl, this.platform), attr.getDateTimeType(t, this.commandLvl, this.platform));
                } else if (FfstChecker.isFfsting) {
                    t.FFST(65, "AttrTypeFactory.create", 0, 50009, 0, 0, "Cannot create AttrType from type " + type + " in attribute " + attr.getAttributeName(t), attr.getObjectName(t), null);
                } else {
                    System.err.println("Error: Cannot create AttrType from type " + type + " in attribute " + attr.getAttributeName(t) + " in object " + attr.getObjectName(t) + ". No such type!");
                }
            }
            if (at != null) {
                at.setDefaultValue(t, this.convertDefaultValue(t, attr, attr.getDefaultValue(t, this.commandLvl, this.platform)));
            }
        }
        return at;
    }

    public void validate(Trace t, Attribute attr) {
        String type = attr.getType(t).toUpperCase();
        if (type != null && attr.isValid(t, this.commandLvl, this.platform)) {
            attr.getName(t);
            attr.getValue(t);
            attr.getSequence(t);
            attr.getDisplayGroup(t);
            attr.getDistributedSequence(t);
            attr.getZosSequence(t);
            attr.getPCFType(t);
            attr.getRepeatingValue(t);
            attr.getReadWrite(t);
            attr.getReadWriteOnCreate(t);
            this.convertDefaultValue(t, attr, attr.getDefaultValue(t, this.commandLvl, this.platform));
            if (type.compareTo(TYPE_INT) != 0 && type.compareTo(TYPE_STRING) != 0 && type.compareTo(TYPE_LONG) != 0 && type.compareTo(TYPE_UINT) != 0 && type.compareTo(TYPE_URL) != 0 && type.compareTo(TYPE_BOOLEAN) != 0 && type.compareTo(TYPE_QMGRURID) != 0 && type.compareTo(TYPE_BYTEARRAY) != 0 && type.compareTo(TYPE_STRINGARRAY) != 0 && type.compareTo(TYPE_INTARRAY) != 0) {
                if (type.compareTo(TYPE_FIXEDSTR) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getPassword(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_FIXEDSTRLISTITEM) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getTotLen(t, this.commandLvl, this.platform);
                    attr.getItemCount(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_FIXEDWMQNAMELISTITEM) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getTotLen(t, this.commandLvl, this.platform);
                    attr.getItemCount(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_FIXEDSTRENUM) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getEnumStringNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_FIXEDSTRENUMRANGE) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getEnumStringNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_ENUM) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_BITENUM) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_LONGENUM) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_RANGE) == 0) {
                    attr.getMin(t, this.commandLvl, this.platform);
                    attr.getMax(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_ENUMRANGE) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                    attr.getMin(t, this.commandLvl, this.platform);
                    attr.getMax(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_LONGENUMRANGE) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                    attr.getLongMin(t, this.commandLvl, this.platform);
                    attr.getLongMax(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_INTARRAYENUM) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                    attr.getItemCount(t, this.commandLvl, this.platform);
                    attr.getUnique(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_INTARRAYENUMRANGE) == 0) {
                    attr.getEnumNames(t, this.commandLvl, this.platform);
                    attr.getEnumValues(t, this.commandLvl, this.platform);
                    attr.getMin(t, this.commandLvl, this.platform);
                    attr.getMax(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_OBJECT) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getRegExp(t, this.commandLvl, this.platform);
                    attr.getFilterName(t);
                    attr.getFilterType(t);
                    attr.getFilterSubType(t);
                    attr.getWhereId(t);
                    attr.getWhereOp(t);
                    attr.getWhereVal(t);
                    attr.getWhereType(t);
                    attr.getSelectOnly(t, this.commandLvl, this.platform);
                    attr.getInfoPopId(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_WMQNAME) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getRegExp(t, this.commandLvl, this.platform);
                } else if (type.compareTo(TYPE_DATETIME) == 0) {
                    attr.getMaxLen(t, this.commandLvl, this.platform);
                    attr.getDateTimeType(t, this.commandLvl, this.platform);
                } else if (FfstChecker.isFfsting) {
                    t.FFST(65, "AttrTypeFactory.validate", 0, 50009, 0, 0, "Cannot create AttrType from type " + type + " in attribute " + attr.getAttributeName(t), attr.getObjectName(t), null);
                } else {
                    System.err.println("Error: Cannot create AttrType from type " + type + " in attribute " + attr.getAttributeName(t) + " in object " + attr.getObjectName(t) + ". No such type!");
                }
            }
        }
    }

    public Object convertDefaultValue(Trace t, Attribute attr, String value) {
        Object defaultValue;
        block11: {
            defaultValue = null;
            if (value != null) {
                String type = attr.getType(t);
                if (type.indexOf(TYPE_INTARRAY) != -1) {
                    ArrayList<String> values = new ArrayList<String>();
                    String[] xmlValues = value.split(this.XML_DELIMITER);
                    int i = 0;
                    while (i < xmlValues.length) {
                        values.add(xmlValues[i]);
                        ++i;
                    }
                    defaultValue = ParseUtils.getDefault(t).getIntArray(t, values, attr.getOwningObject(t));
                } else if (type.indexOf(TYPE_STRINGARRAY) != -1) {
                    defaultValue = new String[]{value};
                } else if (type.indexOf(TYPE_UINT) != -1) {
                    try {
                        defaultValue = new URL(value);
                    }
                    catch (MalformedURLException e) {
                        if (FfstChecker.isFfsting) {
                            t.FFST(65, "AttrTypeFactory.convertDefaultValue", 0, 50049, 0, 0, "Cannot create a URL from the default value " + value + " in attribute " + attr.getAttributeName(t), attr.getObjectName(t), e.toString());
                            break block11;
                        }
                        System.err.println("Error: Cannot create a URL from the default value " + value + " in attribute " + attr.getAttributeName(t) + " in object " + attr.getObjectName(t) + ": " + e.toString());
                    }
                } else {
                    defaultValue = type.equalsIgnoreCase(TYPE_BYTEARRAY) || type.equalsIgnoreCase(TYPE_QMGRURID) ? ByteBuffer.wrap(value.getBytes()) : (type.equals(TYPE_UINT) || type.equals(TYPE_LONGENUM) || type.equals(TYPE_LONGENUMRANGE) || type.equals(TYPE_LONG) || type.equals(TYPE_LONGRANGE) ? Long.valueOf(ParseUtils.getDefault(t).getLongValue(t, value, attr.getOwningObject(t))) : (type.indexOf(this.STRING_TYPE) != -1 || type.equalsIgnoreCase(TYPE_WMQNAME) ? value : (type.equalsIgnoreCase(TYPE_BOOLEAN) ? (Comparable<Boolean>)Boolean.valueOf(ParseUtils.getDefault(t).getBooleanValue(t, value, attr.getOwningObject(t))) : (Comparable<Boolean>)Integer.valueOf(ParseUtils.getDefault(t).getIntValue(t, value, attr.getOwningObject(t))))));
                }
            }
        }
        return defaultValue;
    }
}

