/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import java.text.DateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Calendar;

public class AttrTypeDateTime
extends AttrTypeFixedLengthString {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeDateTime.java";
    private int dateType = 0;
    private Calendar workCal = Calendar.getInstance();
    private Instant instant = Instant.now();
    private static DateFormat dateFormat = DateFormat.getDateInstance();
    private static DateFormat timeFormat = DateFormat.getTimeInstance();

    public AttrTypeDateTime(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int l, int type) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval, l);
        this.dateType = type;
        this.setAttributeType(t, 23);
    }

    public AttrTypeDateTime(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int l, int type) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, l, type);
    }

    public int getType() {
        return this.dateType;
    }

    @Override
    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toString(t, attr, "500", -1);
        }
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toString(Trace t, Attr attr, String charSet, int length) {
        String value = ((AttrString)attr).getValue(t).toString();
        switch (this.dateType) {
            case 50: {
                value = this.createDateString(t, value);
                break;
            }
            case 60: {
                value = this.createTimeString(t, value);
                break;
            }
            case 70: {
                value = this.createIsoTimeString(t, value);
            }
        }
        return value;
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toString(t, attr, "500", -1);
        }
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, String charSet, int length) {
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    public String toDefaultString(Trace t) {
        return this.toDefaultString(t, false);
    }

    @Override
    public String toDefaultString(Trace t, boolean ebcdic) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        if (ebcdic) {
            return this.toDefaultString(t, "500", -1);
        }
        return this.toDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toDefaultString(Trace t, String charSet, int length) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        String value = (String)this.defaultValue;
        switch (this.dateType) {
            case 50: {
                value = this.createDateString(t, value);
                break;
            }
            case 60: {
                value = this.createTimeString(t, value);
                break;
            }
            case 70: {
                value = this.createIsoTimeString(t, value);
            }
        }
        return value;
    }

    private String createDateString(Trace t, String value) {
        String retValue;
        block6: {
            retValue = "";
            try {
                int yy = Integer.parseInt(value.substring(0, 4));
                int mm = Integer.parseInt(value.substring(5, 7));
                int dd = Integer.parseInt(value.substring(8));
                this.workCal.set(yy, mm - 1, dd);
                retValue = dateFormat.format(this.workCal.getTime());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeDateTime.createDateString", 900, "Date value " + value + " unknown format");
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeDateTime.createDateString", 900, "Date value " + value + " unknown format");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!Trace.isTracing) break block6;
                t.data(65, "AttrTypeDateTime.createDateString", 900, "Date value " + value + " unknown format");
            }
        }
        return retValue;
    }

    private String createTimeString(Trace t, String value) {
        String retValue;
        block6: {
            retValue = "";
            try {
                int hh = Integer.parseInt(value.substring(0, 2));
                int mm = Integer.parseInt(value.substring(3, 5));
                int ss = Integer.parseInt(value.substring(6));
                this.workCal.set(1, 1, 1, hh, mm, ss);
                retValue = timeFormat.format(this.workCal.getTime());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeDateTime.createTimeString", 900, "Date value " + value + " unknown format");
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeDateTime.createTimeString", 900, "Date value " + value + " unknown format");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!Trace.isTracing) break block6;
                t.data(65, "AttrTypeDateTime.createTimeString", 900, "Date value " + value + " unknown format");
            }
        }
        return retValue;
    }

    private String createIsoTimeString(Trace t, String value) {
        String retValue;
        block6: {
            retValue = value;
            if (value == null || value.isEmpty()) {
                retValue = "";
            } else {
                try {
                    this.instant = ZonedDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME).toInstant();
                    retValue = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).format(this.instant);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    if (Trace.isTracing) {
                        t.data(65, "AttrTypeDateTime.createIsoTimeString", 900, "IsoTime value " + value + " date/time parse exception");
                    }
                }
                catch (DateTimeException dateTimeException) {
                    if (!Trace.isTracing) break block6;
                    t.data(65, "AttrTypeDateTime.createIsoTimeString", 900, "IsoTime value " + value + " date/time exception");
                }
            }
        }
        return retValue;
    }

    public Calendar getCalendarDate(Trace t, String value) {
        this.workCal = Calendar.getInstance();
        this.createDateString(t, value);
        return this.workCal;
    }

    public Calendar getCalendarTime(Trace t, String value) {
        this.workCal = Calendar.getInstance();
        this.createTimeString(t, value);
        return this.workCal;
    }

    public Instant getInstantIsoTime(Trace t, String value) {
        this.instant = Instant.now();
        this.createIsoTimeString(t, value);
        return this.instant;
    }

    @Override
    public String toFormattedDefaultString(Trace t) {
        return this.toFormattedDefaultString(t, false);
    }

    @Override
    public String toFormattedDefaultString(Trace t, boolean ebcdic) {
        return this.toDefaultString(t);
    }

    @Override
    public String toFormattedDefaultString(Trace t, String charSet, int length) {
        return this.toDefaultString(t);
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println("   date/time : " + this.dateType);
    }
}

