/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.pcf.CCSID;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class AttrTypeByteArray
extends AttrType {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeByteArray.java";
    private static final int BYTES_PER_LINE = 16;
    private static final int SHIFT_BITS = 24;
    private static final int DO_NOT_TRANSLATE = -1;
    private static final String PAD_ZERO = "0";
    private static final String PAD_BLANK = " ";
    private int[] segment = new int[16];

    public AttrTypeByteArray(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 16);
    }

    public AttrTypeByteArray(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE);
    }

    @Override
    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toString(t, attr, "500", -1);
        }
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toString(Trace t, Attr attr, String charSet, int length) {
        ByteBuffer bb = (ByteBuffer)attr.getValue(t);
        String s = this.formatBytesShortVersion(t, bb, charSet, length);
        return s;
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedString(t, attr, "500", -1);
        }
        return this.toFormattedString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, String charSet, int length) {
        ByteBuffer bb = (ByteBuffer)attr.getValue(t);
        String s = this.formatBytes(t, bb, charSet, length);
        return s;
    }

    @Override
    public String toDefaultString(Trace t) {
        return this.toDefaultString(t, false);
    }

    @Override
    public String toDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toDefaultString(t, "500", -1);
        }
        return this.toDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toDefaultString(Trace t, String charSet, int length) {
        String s = null;
        if (this.defaultValue == null) {
            s = "<not_set>";
        } else {
            ByteBuffer bb = (ByteBuffer)this.getDefaultValue(t);
            s = this.formatBytesShortVersion(t, bb, charSet, length);
        }
        return s;
    }

    @Override
    public String toFormattedDefaultString(Trace t) {
        return this.toFormattedDefaultString(t, false);
    }

    @Override
    public String toFormattedDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedDefaultString(t, "500", -1);
        }
        return this.toFormattedDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toFormattedDefaultString(Trace t, String charSet, int length) {
        String s = null;
        if (this.defaultValue == null) {
            s = "<not_set>";
        } else {
            ByteBuffer bb = (ByteBuffer)this.getDefaultValue(t);
            s = this.formatBytes(t, bb, charSet, length);
        }
        return s;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String formatBytes(Trace t, ByteBuffer bb, String charSet, int length) {
        block13: {
            eol = false;
            offset = 0;
            formattedString = new StringBuffer();
            bb.rewind();
            if (length == -1) {
                length = bb.remaining();
            }
            if (!Trace.isTracing) ** GOTO lbl-1000
            t.data(65, "AttrTypeByteArray.formatBytes", 300, "Length of data to return is " + length);
            try lbl-1000:
            // 3 sources

            {
                while (true) {
                    if (eol) break;
                    i = 0;
                    try {
                        i = 0;
                        while (i < 16) {
                            if (bb.position() >= length) {
                                bb.position(bb.limit());
                                throw new BufferUnderflowException();
                            }
                            this.segment[i] = bb.get();
                            if (this.segment[i] < 0) {
                                this.segment[i] = this.segment[i] << 24;
                                this.segment[i] = this.segment[i] >>> 24;
                            }
                            ++i;
                        }
                        break block13;
                    }
                    catch (BufferUnderflowException v0) {
                        eol = true;
                        if (i == 0) break;
                        j = i;
                        if (true) ** GOTO lbl44
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeByteArray.formatBytes", 900, "Error formatting bytes\n" + e.toString());
                }
                formattedString = new StringBuffer(".");
            }
            bb.rewind();
            return formattedString.toString();
            do {
                this.segment[j] = -1;
                ++j;
lbl44:
                // 2 sources

            } while (j < 16);
        }
        formattedString = formattedString.append(this.formatLine(t, offset, charSet));
        if (bb.remaining() == 0) {
            eol = true;
        }
        ++offset;
        ** while (true)
    }

    private String formatBytesShortVersion(Trace t, ByteBuffer bb, String charSet, int length) {
        String formattedString = "";
        bb.rewind();
        if (length == -1) {
            length = 4096;
        }
        int[] segment = new int[bb.limit()];
        if (Trace.isTracing) {
            t.data(65, "AttrTypeByteArray.formatBytesShortVersion", 300, "Length of data to return is " + length);
        }
        int z = 0;
        while (z < bb.limit()) {
            segment[z] = bb.get();
            if (segment[z] < 0) {
                segment[z] = segment[z] << 24;
                segment[z] = segment[z] >>> 24;
            }
            formattedString = String.valueOf(formattedString) + AttrTypeByteArray.rightJustify(segment[z], 2, PAD_ZERO);
            ++z;
        }
        bb.rewind();
        if (formattedString.length() > length) {
            formattedString.substring(0, length);
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.formatBytesShortVersion", 300, "Truncating string to length " + length);
            }
        }
        return formattedString;
    }

    private String formatLine(Trace t, int offset, String charSet) {
        String newCharSet = null;
        int i = 0;
        String str = "";
        if (Trace.isTracing) {
            t.data(65, "AttrTypeByteArray.formatLine", 300, "Given charSet is " + charSet);
        }
        try {
            charSet = newCharSet = CCSID.getCodepage((int)Integer.parseInt(charSet));
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.formatLine", 300, "Resetting charSet to " + charSet);
            }
        }
        catch (Exception exception) {}
        boolean charSetSupported = Charset.isSupported(charSet);
        str = String.valueOf(str) + AttrTypeByteArray.rightJustify(offset * 16, 5, PAD_ZERO) + "   ";
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + AttrTypeByteArray.rightJustify(this.segment[i], 2, PAD_ZERO) + PAD_BLANK;
            ++i;
        }
        str = String.valueOf(str) + AttrTypeByteArray.rightJustify(this.segment[i++], 2, PAD_ZERO);
        str = String.valueOf(str) + "--";
        while (i < 16) {
            str = String.valueOf(str) + AttrTypeByteArray.rightJustify(this.segment[i], 2, PAD_ZERO) + PAD_BLANK;
            ++i;
        }
        str = String.valueOf(str) + " |";
        i = 0;
        while (i < 16) {
            String s = ".";
            if (this.segment[i] != -1) {
                byte[] b = new byte[]{(byte)this.segment[i]};
                char c = (char)this.segment[i];
                if (charSetSupported) {
                    try {
                        s = new String(b, charSet);
                        if (s.length() != 1) {
                            s = ".";
                        }
                        if (s.contentEquals("\n")) {
                            s = ".";
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                if (!AttrTypeByteArray.isPrintableAscii(c = s.charAt(0))) {
                    s = ".";
                }
            } else {
                s = PAD_BLANK;
            }
            str = String.valueOf(str) + s;
            ++i;
        }
        str = String.valueOf(str) + "|\n";
        return str;
    }

    private static boolean isPrintableAscii(char c) {
        return !Character.isIdentifierIgnorable(c);
    }

    private static String rightJustify(int num, int width, String pad) {
        String s = null;
        if (num == -1) {
            pad = PAD_BLANK;
            s = PAD_BLANK;
        } else {
            s = Integer.toHexString(num);
        }
        int i = width - s.length();
        while (i > 0) {
            s = String.valueOf(pad) + s;
            --i;
        }
        return s.toUpperCase();
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        ByteBuffer bb2;
        ByteBuffer bb1 = (ByteBuffer)attr1.getValue(t);
        if (!bb1.equals(bb2 = (ByteBuffer)attr2.getValue(t))) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.equals", 300, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
            }
            return false;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeByteArray.equals", 300, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
        }
        return true;
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        return true;
    }

    @Override
    public boolean isEbcdicSupported() {
        return true;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
    }

    protected String toStringWithEncoding(Trace t, Attr attr, int ccsid, int encoding, int length) throws DmCoreException {
        String str = "";
        ByteBuffer bb = (ByteBuffer)attr.getValue(t);
        String charset = null;
        try {
            charset = CCSID.getCharSet((int)ccsid, (int)encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.toStringWithEncoding", 900, "UnsupportedEncodingException for ccsid " + ccsid + ", encoding " + encoding + " in PCF classes");
            }
            DmCoreException dmce = AttrTypeByteArray.createException(t, 2119, 2);
            throw dmce;
        }
        try {
            bb.rewind();
            byte[] bbuff = new byte[bb.limit()];
            int i = 0;
            while (i < bb.limit()) {
                bbuff[i] = bb.get();
                ++i;
            }
            str = new String(bbuff, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.toStringWithEncoding", 900, "UnsupportedEncodingException for ccsid " + ccsid + ", encoding " + encoding);
            }
            DmCoreException dmce = AttrTypeByteArray.createException(t, 2119, 2);
            throw dmce;
        }
        if (str.length() > length) {
            str.substring(0, length);
            if (Trace.isTracing) {
                t.data(65, "AttrTypeByteArray.toStringWithEncoding", 300, "Truncating string to length " + length);
            }
        }
        return str;
    }

    private static DmCoreException createException(Trace t, int rc, int cc) {
        String message = null;
        String messageId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
        if (messageId.equalsIgnoreCase("RC_" + rc)) {
            message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4999", (String)String.valueOf(rc));
        }
        String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
        DmCoreException ex = new DmCoreException(t, message, msgId, rc, cc, 20);
        return ex;
    }
}

