/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AttrTypeBitEnum
extends AttrTypeInt {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeBitEnum.java";
    private Hashtable<Integer, String> enumerations = null;

    public AttrTypeBitEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int[] keys, String[] values) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 20);
        if (keys != null && values != null) {
            if (keys.length == values.length) {
                int i = 0;
                while (i < keys.length) {
                    if (resource_stem == null || resource_stem.equals("")) {
                        this.addEnumeration(t, keys[i], values[i]);
                    } else {
                        this.addEnumeration(t, keys[i], CoreServices.message.getMessage(t, String.valueOf(values[i]) + ".title"));
                    }
                    ++i;
                }
            }
        } else if (keys == null) {
            // empty if block
        }
    }

    public AttrTypeBitEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int[] keys, String[] values) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, keys, values);
    }

    private String formatString(Trace t, Attr attr, String sep) {
        Object value = attr.getValue(t);
        int val = (Integer)value;
        String output = "";
        Integer[] ids = this.getEnumerationIds(t);
        int k = 0;
        while (k < ids.length) {
            int enumval = ids[k];
            if (enumval == 0) {
                if (val == 0) {
                    output = output.concat(this.getEnumeratedValue(t, ids[k]));
                    output = output.concat(sep);
                }
            } else if ((enumval & val) == enumval) {
                output = output.concat(this.getEnumeratedValue(t, ids[k]));
                output = output.concat(sep);
            }
            ++k;
        }
        if (!output.equals("")) {
            output = output.substring(0, output.length() - sep.length());
        }
        return output;
    }

    @Override
    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        String output = this.formatString(t, attr, ", ");
        return output;
    }

    @Override
    protected String toString(Trace t, Attr attr, String charSet, int length) {
        String output = this.formatString(t, attr, ", ");
        return output;
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        String output = this.formatString(t, attr, "\n");
        return output;
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, String charSet, int length) {
        String output = this.formatString(t, attr, "\n");
        return output;
    }

    private boolean addEnumeration(Trace t, Integer key, String value) {
        if (this.enumerations == null) {
            this.enumerations = new Hashtable();
        }
        try {
            this.enumerations.put(key, value);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public Hashtable<Integer, String> getEnumerations() {
        return this.enumerations;
    }

    public Integer[] getEnumerationIds(Trace t) {
        Integer[] ids = null;
        int index = 0;
        if (this.enumerations.size() > 0) {
            ids = new Integer[this.enumerations.size()];
            Set<Integer> k = this.enumerations.keySet();
            Iterator<Integer> i = k.iterator();
            while (i.hasNext()) {
                Integer key;
                ids[index] = key = i.next();
                ++index;
            }
        }
        return ids;
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    public String getEnumeratedValue(Trace t, Integer key) {
        String retValue = this.enumerations.get(key);
        if (retValue == null) {
            return "[not_found]";
        }
        return retValue;
    }
}

