/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.IAttrType;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;

public abstract class AttrType
implements IAttrType {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrType.java";
    public static final String NOT_SET = "<not_set>";
    public static final String EMPTY_STRING = "";
    protected Object defaultValue = null;
    private String displayTitle = "<not_set>";
    private String displayPropTitle = "<not_set>";
    public static final String CSSID_EBCDIC = "500";
    public static final String CSSID_ASCII = "UTF8";
    public static final int NO_MAXIMUM = -1;
    public static final int NO_MINIMUM = -1;
    public static final int DEFAULT_LENGTH = 4096;
    private int displayGroupSequence = 0;
    private int distributedColumnSequence = 0;
    private int zosColumnSequence = 0;
    private int pcfType = 0;
    private boolean repeating = false;
    private DisplayGroup displayGroup = null;
    private int updateGroup = 0;
    private boolean readWrite = true;
    private boolean readWriteOnCreate = true;
    public static final int NO_RWCONTROL = -1;
    private int rwControl = -1;
    public static final Object NO_RWSWITCHVALUE = null;
    private Object rwSwitchValue = NO_RWSWITCHVALUE;
    private int attributeType = 0;
    public static final int UNKNOWN = -1;
    public static final int INT = 1;
    public static final int STRING = 2;
    public static final int ENUM = 3;
    public static final int RANGE = 4;
    public static final int IPADDR = 5;
    public static final int FIXED_STRING = 6;
    public static final int MQ_STRING = 7;
    public static final int FIXED_STRING_LIST_ITEM = 8;
    public static final int FIXED_STRING_ENUM = 9;
    public static final int UINT = 10;
    public static final int ENUM_RANGE = 11;
    public static final int LONG = 12;
    public static final int FIXED_STRING_ENUM_RANGE = 13;
    public static final int INT_ARRAY = 14;
    public static final int STRING_ARRAY = 15;
    public static final int BYTE_ARRAY = 16;
    public static final int ULONG = 17;
    public static final int INT_ARRAY_ENUM = 18;
    public static final int QMGRURID = 19;
    public static final int BITENUM = 20;
    public static final int FIXED_WMQ_STRING_LIST_ITEM = 21;
    public static final int INT_ARRAY_ENUM_RANGE = 22;
    public static final int DATE_TIME = 23;
    public static final int URL = 24;
    public static final int BOOLEAN = 25;
    public static final int OBJECT = 26;
    public static final int LONG_ENUM = 27;
    public static final int LONG_ENUM_RANGE = 28;
    public static final int LONG_RANGE = 29;

    protected abstract String toString(Trace var1, Attr var2);

    protected abstract String toFormattedString(Trace var1, Attr var2);

    public abstract String toDefaultString(Trace var1);

    public abstract String toFormattedDefaultString(Trace var1);

    protected abstract String toString(Trace var1, Attr var2, boolean var3);

    protected abstract String toString(Trace var1, Attr var2, String var3, int var4);

    protected abstract String toFormattedString(Trace var1, Attr var2, boolean var3);

    protected abstract String toFormattedString(Trace var1, Attr var2, String var3, int var4);

    public abstract String toDefaultString(Trace var1, boolean var2);

    public abstract String toDefaultString(Trace var1, String var2, int var3);

    public abstract String toFormattedDefaultString(Trace var1, boolean var2);

    public abstract String toFormattedDefaultString(Trace var1, String var2, int var3);

    protected abstract boolean validate(Trace var1, Attr var2, Object var3);

    protected abstract boolean equals(Trace var1, Attr var2, Attr var3);

    public AttrType(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval) {
        this.displayTitle = CoreServices.message.getMessage(t, String.valueOf(resource_stem) + ".title");
        String propTitle = CoreServices.message.getMessage(t, String.valueOf(resource_stem) + Message.PROP_TITLE);
        if (propTitle.indexOf(Message.PROP_TITLE) == -1) {
            this.displayPropTitle = propTitle;
        }
        this.init(t, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
    }

    private void init(Trace t, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval) {
        this.displayGroupSequence = grpseq;
        this.displayGroup = grp;
        this.distributedColumnSequence = distcolseq;
        this.zosColumnSequence = zoscolseq;
        this.pcfType = pcftype;
        this.repeating = rep;
        this.readWrite = rw;
        this.readWriteOnCreate = rwoc;
        this.rwControl = rwctrl;
        this.rwSwitchValue = rwswval;
    }

    @Override
    public String getDisplayTitle() {
        return this.displayTitle;
    }

    @Override
    public String getPropTitle() {
        if (this.displayPropTitle.equals(NOT_SET)) {
            return this.displayTitle;
        }
        return this.displayPropTitle;
    }

    public void setDisplayTitle(String title) {
        this.displayTitle = title;
    }

    @Override
    public int getDisplayGroupSequence() {
        return this.displayGroupSequence;
    }

    @Override
    public int getDisplayColumnSequence() {
        return this.distributedColumnSequence;
    }

    @Override
    public int getZosDisplayColumnSequence() {
        return this.zosColumnSequence;
    }

    @Override
    public DisplayGroup getDisplayGroup() {
        return this.displayGroup;
    }

    @Override
    public int getUpdateGroup() {
        return this.updateGroup;
    }

    @Override
    public int getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean isReadWrite(Object rwctrl_value) {
        boolean effectiveReadWrite = this.readWrite;
        if (-1 != this.rwControl && !this.rwSwitchValue.equals(NO_RWSWITCHVALUE) && this.rwSwitchValue.equals(rwctrl_value)) {
            effectiveReadWrite = !effectiveReadWrite;
        }
        return effectiveReadWrite;
    }

    @Override
    public boolean isReadWrite() {
        return this.readWrite;
    }

    public boolean isReadWriteOnCreate() {
        return this.readWriteOnCreate;
    }

    public void setReadWrite(Trace t, boolean rw) {
        this.readWrite = rw;
    }

    @Override
    public int getRWControl() {
        return this.rwControl;
    }

    public void setRWControl(int rwctrl) {
        this.rwControl = rwctrl;
    }

    @Override
    public Object getRWSwitchValue() {
        return this.rwSwitchValue;
    }

    public void setRWSwitchValue(Object rwswval) {
        this.rwSwitchValue = rwswval;
    }

    public void setAttributeType(Trace t, int type) {
        this.attributeType = type;
    }

    public void setUpdateGroup(Trace t, int id) {
        this.updateGroup = id;
    }

    public int getPCFType() {
        return this.pcfType;
    }

    public void setPCFType(Trace t, int pcftype) {
        this.pcfType = pcftype;
    }

    public boolean isPseudoPCF() {
        return this.pcfType != 0;
    }

    @Override
    public boolean isRepeating() {
        return this.repeating;
    }

    public void setDefaultValue(Trace t, Object o) {
        this.defaultValue = o;
    }

    public Object getDefaultValue(Trace t) {
        return this.defaultValue;
    }

    @Override
    public boolean isEbcdicSupported() {
        return false;
    }

    @Override
    public abstract boolean isMultiLine();

    @Override
    public void debug(Trace t) {
        System.out.println("----------------------------------------------------------------------------");
        System.out.println("     attributeType: " + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
        System.out.println("             title: " + this.getDisplayTitle());
        System.out.println("      grp sequence: " + this.getDisplayGroupSequence());
        System.out.println("              type: " + this.getAttributeType());
        System.out.println("     display group: " + this.getDisplayGroup().toString(t));
        System.out.println("        pseudo PCF: " + (this.isPseudoPCF() ? "true" : "false"));
        System.out.println("         repeating: " + (this.isRepeating() ? "true" : "false"));
        System.out.println("       zos col seq: " + this.zosColumnSequence);
        System.out.println("      dist col seq: " + this.distributedColumnSequence);
        System.out.println("        read/write: " + (this.isReadWrite() ? "true" : "false"));
        System.out.println("read/write(create): " + (this.isReadWriteOnCreate() ? "true" : "false"));
        System.out.println("         rwControl: " + this.getRWControl());
        System.out.println("     rwSwitchValue: " + (this.getRWSwitchValue() == null ? "null" : this.getRWSwitchValue().toString()));
        System.out.println("      update group: " + this.getUpdateGroup());
    }
}

