/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import java.util.ArrayList;

public class AttrStringArray
extends Attr {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrStringArray.java";

    public AttrStringArray(Trace t, int id, int index, String[] value, AttrTypeStringArray at, IDmObject aObject) {
        super(t, id, index, at, aObject);
        ArrayList<String> temp = new ArrayList<String>(value.length);
        int i = 0;
        while (i < value.length) {
            temp.add(value[i]);
            ++i;
        }
        this.currentValue = temp;
        if (Trace.isTracing) {
            t.data(65, "AttrStringArray.AttrStringArray", 300, "Creating attribute " + id + ":" + index + ", value = " + this.toString(t));
        }
    }

    @Override
    public boolean setNewValue(Trace t, Object value) {
        boolean valid = false;
        if (value instanceof ArrayList) {
            valid = this.validate(t, value);
            this.newValue = value;
        } else if (value instanceof String[] && (valid = this.validate(t, value))) {
            String[] ss = (String[])value;
            ArrayList<String> al = new ArrayList<String>();
            int i = 0;
            while (i < ss.length) {
                al.add(ss[i]);
                ++i;
            }
            this.newValue = al;
        }
        return valid;
    }

    @Override
    public boolean replaceValue(Trace t, Object value) {
        boolean valid = this.validate(t, value);
        if (valid) {
            this.currentValue = value;
        }
        return valid;
    }
}

