/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import java.nio.ByteBuffer;

public class AttrByteArray
extends Attr {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrByteArray.java";

    public AttrByteArray(Trace t, int id, int index, byte[] value, AttrTypeByteArray attrType, IDmObject object) {
        super(t, id, index, attrType, object);
        this.currentValue = ByteBuffer.allocateDirect(value.length);
        ((ByteBuffer)this.currentValue).put(value);
        if (Trace.isTracing) {
            t.data(65, "AttrByteArray.AttrByteArray", 300, "Creating attribute " + id + ":" + index + ", value = " + this.toFormattedString(t));
        }
    }

    @Override
    public boolean setNewValue(Trace t, Object value) {
        boolean valid = this.validate(t, value);
        this.newValue = value;
        return valid;
    }

    @Override
    public boolean replaceValue(Trace t, Object value) {
        boolean valid = this.validate(t, value);
        if (valid) {
            this.currentValue = value;
        }
        return valid;
    }

    @Override
    public String toFormattedString(Trace t) {
        return this.toFormattedString(t, false);
    }

    @Override
    public String toFormattedString(Trace t, boolean ebcdic) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = ((AttrTypeByteArray)this.getAttrType()).toFormattedString(t, this, ebcdic);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "AttrByteArray.toFormattedString", 1000, "Attribute id " + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toFormattedString(Trace t, String charSet, int length) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = ((AttrTypeByteArray)this.getAttrType()).toFormattedString(t, this, charSet, length);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "AttrByteArray.toFormattedString", 1000, "Attribute id " + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    public String toStringWithEncoding(Trace t, int ccsid, int encoding, int length) throws DmCoreException {
        String retValue = "[not_found]";
        try {
            retValue = ((AttrTypeByteArray)this.getAttrType()).toStringWithEncoding(t, this, ccsid, encoding, length);
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(65, "AttrByteArray.toStringWithEncoding", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
        return retValue;
    }
}

