/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.IAttr;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;

public abstract class Attr
implements Cloneable,
IAttr,
Comparable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/Attr.java";
    private int attributeID = 0;
    private int repeatingIndex = 0;
    private AttrType attrType = null;
    private IDmObject dmObject = null;
    protected Object currentValue = null;
    protected Object newValue = null;
    private boolean defaultValueUsed = false;
    private boolean groupDefaultValuesUsed = false;
    private boolean readWrite = true;
    private int action = 0;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_CHANGE = 2;
    public static final int ACTION_DELETE = 3;
    public static final int ACTION_RECREATE = 4;
    public static final int DATE = 50;
    public static final int TIME = 60;
    public static final int ISOTIME = 70;
    public static final int HIDDEN = -2;
    public static final int NOT_VISIBLE = -1;

    @Override
    public abstract boolean setNewValue(Trace var1, Object var2);

    @Override
    public abstract boolean replaceValue(Trace var1, Object var2);

    protected Attr(Trace t, int id, int index, AttrType at, IDmObject aObject) {
        this.attributeID = id;
        this.repeatingIndex = index;
        this.attrType = at;
        this.dmObject = aObject;
        this.readWrite = this.attrType.isReadWrite();
    }

    public final Object clone() throws CloneNotSupportedException {
        Attr a = (Attr)super.clone();
        return a;
    }

    @Override
    public int getAttributeID() {
        return this.attributeID;
    }

    @Override
    public int getRepeatingIndex() {
        return this.repeatingIndex;
    }

    @Override
    public AttrType getAttrType() {
        return this.attrType;
    }

    public boolean equals(Trace t, Attr attr) {
        boolean retValue;
        block4: {
            retValue = false;
            if (this.getAttrType().getAttributeType() != attr.getAttrType().getAttributeType()) {
                if (Trace.isTracing) {
                    t.data(65, "Attr.equals", 900, "The attribute types for attribute id " + this.getAttributeID() + "." + this.getRepeatingIndex() + " and " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " are not the same");
                }
                return false;
            }
            try {
                retValue = this.getAttrType().equals(t, this, attr);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block4;
                t.data(65, "Attr.equals", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    protected boolean validate(Trace t, Object o) {
        boolean retValue;
        block2: {
            retValue = false;
            try {
                retValue = this.getAttrType().validate(t, this, o);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.validate", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toString(Trace t) {
        return this.toString(t, false);
    }

    @Override
    public String toString(Trace t, boolean ebcdic) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toString(t, this, ebcdic);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toString(Trace t, String charSet, int length) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toString(t, this, charSet, length);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toDefaultString(Trace t) {
        return this.toDefaultString(t, false);
    }

    @Override
    public String toDefaultString(Trace t, boolean ebcdic) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toDefaultString(t);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toDefaultString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toDefaultString(Trace t, String charSet, int length) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toDefaultString(t, charSet, length);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toDefaultString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toFormattedString(Trace t) {
        return this.toFormattedString(t, false);
    }

    @Override
    public String toFormattedString(Trace t, boolean ebcdic) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toFormattedString(t, this);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toFormattedString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toFormattedString(Trace t, String charSet, int length) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toFormattedString(t, this, charSet, length);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toFormattedString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toFormattedDefaultString(Trace t) {
        return this.toFormattedDefaultString(t, false);
    }

    @Override
    public String toFormattedDefaultString(Trace t, boolean ebcdic) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toFormattedDefaultString(t);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toFormattedDefaultString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public String toFormattedDefaultString(Trace t, String charSet, int length) {
        String retValue;
        block2: {
            retValue = "[not_found]";
            try {
                retValue = this.getAttrType().toFormattedDefaultString(t, charSet, length);
            }
            catch (NullPointerException nullPointerException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "Attr.toFormattedDefaultString", 1000, "Attribute id :" + this.getAttributeID() + " has no AttrType");
            }
        }
        return retValue;
    }

    @Override
    public Object getValue(Trace t) {
        return this.currentValue;
    }

    @Override
    public Object getDefaultValue(Trace t) {
        Object retValue = null;
        retValue = this.getAttrType().defaultValue;
        return retValue;
    }

    public Object getNewValue(Trace t) {
        return this.newValue;
    }

    public IDmObject getDmObject() {
        return this.dmObject;
    }

    public void setDefaultValueUsed(Trace t, boolean b) {
        this.defaultValueUsed = b;
    }

    @Override
    public boolean isDefaultValueUsed(Trace t) {
        return this.defaultValueUsed;
    }

    public void setGroupDefaultValueUsed(Trace t, boolean b) {
        this.groupDefaultValuesUsed = b;
    }

    @Override
    public boolean isGroupDefaultValuesUsed(Trace t) {
        return this.groupDefaultValuesUsed;
    }

    public int getAction(Trace t) {
        return this.action;
    }

    public void setAction(Trace t, int i) {
        this.action = i;
    }

    public void setReadWrite(Trace t, boolean b) {
        this.readWrite = b;
    }

    @Override
    public boolean isReadWrite(Trace t) {
        return this.isReadWrite(t, false);
    }

    public boolean isReadWrite(Trace t, boolean createMode) {
        if (Trace.isTracing) {
            t.data(65, "Attr.isReadWrite", 300, "Attribute id " + this.attributeID + "." + this.repeatingIndex + " read-write is " + this.readWrite);
        }
        boolean readWriteValue = this.readWrite;
        if (createMode) {
            readWriteValue = this.attrType.isReadWriteOnCreate();
        } else {
            Attr controlAttr;
            Object switchValue;
            int controlAttrId = this.attrType.getRWControl();
            if (-1 != controlAttrId && (switchValue = this.attrType.getRWSwitchValue()) != null && (controlAttr = this.dmObject.getAttribute(t, controlAttrId, 0)) != null && controlAttr.getValue(t).equals(switchValue)) {
                readWriteValue = true;
                if (Trace.isTracing) {
                    t.data(65, "Attr.isReadWrite", 1000, "Make attribute id " + this.attributeID + "." + this.repeatingIndex + " read-write");
                }
            }
        }
        return readWriteValue;
    }

    public int compareTo(Object o) {
        if (o instanceof Attr) {
            int i = this.getAttrType().getDisplayGroupSequence();
            int j = ((Attr)o).getAttrType().getDisplayGroupSequence();
            return i - j;
        }
        return 0;
    }

    @Override
    public void debug(Trace t) {
        System.out.println("----------------------------------------------------------------------------");
        System.out.println("attribute: " + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
        System.out.println("       ID: " + this.getAttributeID() + "." + this.getRepeatingIndex());
        System.out.println("    value: " + this.toString(t));
        this.getAttrType().debug(t);
    }

    public String toString() {
        if (this.getAttrType() instanceof AttrTypeFixedLengthString) {
            return this.getAttrType().toString();
        }
        return "Attr=" + this.attributeID + "." + this.repeatingIndex + ", value=" + this.currentValue;
    }
}

