/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeNumber;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractAttrTypeEnum
extends AbstractAttrTypeNumber {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AbstractAttrTypeEnum.java";
    protected Hashtable<Number, String> enumerations = null;
    private boolean sortByInt = false;

    public AbstractAttrTypeEnum(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, Number[] keys, String[] values) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        if (keys != null && values != null) {
            if (keys.length == values.length) {
                int i = 0;
                while (i < keys.length) {
                    if (resource_stem == null || resource_stem.equals("")) {
                        this.addEnumeration(t, keys[i], values[i]);
                    } else {
                        this.addEnumeration(t, keys[i], CoreServices.message.getMessage(t, String.valueOf(values[i]) + ".title"));
                    }
                    ++i;
                }
            }
        } else if (keys == null) {
            // empty if block
        }
    }

    private boolean addEnumeration(Trace t, Number key, String value) {
        if (this.enumerations == null) {
            this.enumerations = new Hashtable();
        }
        try {
            this.enumerations.put(key, value);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public Hashtable<Number, String> getEnumerations() {
        return this.enumerations;
    }

    public Number[] getEnumerationNumberIds(Trace t) {
        Number[] ids = null;
        int index = 0;
        if (this.enumerations.size() > 0) {
            ids = new Number[this.enumerations.size()];
            Set<Number> k = this.enumerations.keySet();
            Iterator<Number> i = k.iterator();
            while (i.hasNext()) {
                Number key;
                ids[index] = key = i.next();
                ++index;
            }
        }
        return ids;
    }

    public String getEnumeratedValue(Trace t, Number key) {
        String retValue = this.enumerations.get(key);
        if (retValue == null) {
            if (Trace.isTracing) {
                t.data(65, "AbstractAttrTypeEnum.getEnumeratedValue", 900, "Key not found : " + key);
            }
            return "[not_found]";
        }
        return retValue;
    }

    public void setSortByInt(Trace t, boolean b) {
        this.sortByInt = b;
    }

    public String toString(Trace t, Number i) {
        return this.toString(t, i, false);
    }

    public String toString(Trace t, Number i, boolean ebcdic) {
        return this.getEnumeratedValue(t, i);
    }

    @Override
    public String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    public String toString(Trace t, Attr attr, boolean ebcdic) {
        return this.getEnumeratedValue(t, (Number)attr.getValue(t));
    }

    public boolean isSortByInt(Trace t) {
        return this.sortByInt;
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        String newValue2;
        if (attr1.getAttrType().getAttributeType() != attr2.getAttrType().getAttributeType()) {
            if (Trace.isTracing) {
                t.data(65, "AbstractAttrTypeEnum.equals", 900, "The attribute types for attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not the same");
            }
            return false;
        }
        Number key1 = (Number)attr1.getValue(t);
        Number key2 = (Number)attr2.getValue(t);
        String newValue1 = this.getEnumeratedValue(t, key1);
        if (newValue1.equals(newValue2 = this.getEnumeratedValue(t, key2))) {
            if (Trace.isTracing) {
                t.data(65, "AbstractAttrTypeEnum.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
            }
            return true;
        }
        if (Trace.isTracing) {
            t.data(65, "AbstractAttrTypeEnum.equals", 300, "Attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
        }
        return false;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        Number key = (Number)o;
        String newValue = this.getEnumeratedValue(t, key);
        if (newValue.equals("[not_found]")) {
            t.data(65, "AbstractAttrTypeEnum.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " failed validation");
            return false;
        }
        t.data(65, "AbstractAttrTypeEnum.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " passed validation");
        return true;
    }

    @Override
    public boolean isMultiLine() {
        return false;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println("  sort by int: " + this.sortByInt);
        Enumeration<Number> e = this.enumerations.keys();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            System.out.println("        value: " + i.toString() + "=" + this.enumerations.get(i));
        }
    }

    public Number getEnumerationKey(Trace t, Object value) {
        Number retValue = null;
        if (this.enumerations.size() > 0 && this.enumerations.containsValue(value)) {
            Set<Number> k = this.enumerations.keySet();
            for (Number key : k) {
                if (!value.equals(this.enumerations.get(key))) continue;
                retValue = key;
                break;
            }
        }
        return retValue;
    }
}

