/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.actions;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandleInstance;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.util.Hashtable;

public class PingQueueManager
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/actions/PingQueueManager.java";
    private DmActionListener dmActionListener = null;
    private DmQueueManager dmQueueManager = null;
    private DmQueueManagerHandleInstance dmQueueManagerHandleInstance = null;
    private DmQueueManagerHandle dmQueueManagerHandle = null;
    private String queueManagerName = null;
    private String queueManagerUUID = null;
    private String pingedQueueManagerName = null;
    private String pingedQueueManagerUUID = null;
    private String connName = null;
    private boolean active = false;
    private PingQueueManager myself = null;

    public PingQueueManager(Trace t, DmActionListener l, DmQueueManager o, DmQueueManagerHandleInstance c) {
        this.dmActionListener = l;
        this.dmQueueManager = o;
        this.queueManagerName = this.dmQueueManager.getTitle();
        this.queueManagerUUID = this.dmQueueManager.getUUID();
        this.dmQueueManagerHandle = this.dmQueueManager.getConnectionHandle();
        this.dmQueueManagerHandleInstance = c;
        this.connName = this.dmQueueManagerHandleInstance.getAttributeValue(t, 11002, 0);
        this.myself = this;
        this.setName("IBM MQ pinging " + this.queueManagerName + " at " + this.connName);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        this.active = true;
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.run", 300, "Making connection to " + this.queueManagerName);
        }
        try {
            this.connectUsingClient(t);
            this.dmActionListener.dmActionDone(new DmActionEvent(this.dmQueueManager, 40, 0));
        }
        catch (DmCoreException dmce) {
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.run", 300, "Connection to " + this.queueManagerName + " failed");
            }
            if (dmce.getReasonCode() == 2543) {
                this.updateStatus(t, 2);
            } else {
                this.updateStatus(t, 3);
            }
            this.dmActionListener.dmActionDone(new DmActionEvent(this.dmQueueManager, 40, dmce.getReasonCode(), dmce));
        }
        this.active = false;
    }

    private void connectUsingClient(Trace t) throws DmCoreException {
        MQQueueManager mqQueueManager = null;
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.connectUsingClient", 300, "Client connection to " + this.queueManagerName + " at " + this.connName);
        }
        try {
            Hashtable<String, Object> parms = this.getConnectOptions(t);
            mqQueueManager = new MQQueueManager("*", parms);
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.connectUsingClient", 300, "Created new MQQueueManager object");
            }
            this.inquire(t, mqQueueManager);
            if (!this.queueManagerName.equals(this.pingedQueueManagerName)) {
                this.updateStatus(t, 4);
            } else if (!this.queueManagerUUID.equals(this.pingedQueueManagerUUID)) {
                this.updateStatus(t, 5);
            } else {
                this.updateStatus(t, 1);
            }
            mqQueueManager.disconnect();
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
        catch (SecurityException e) {
            String messageId = "AMQ4129";
            String message = CommonServices.getSystemMessage((Trace)t, (String)messageId);
            DmCoreException ex = new DmCoreException(t, message, e, messageId, 50013, 2, 0);
            throw ex;
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.connectUsingClient", 900, mqe.toString());
            }
            String msg = ConvertReasonCode.getSystemMessage(t, this.queueManagerName, 40, mqe.reasonCode, mqe.completionCode);
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)mqe.reasonCode);
            DmCoreException ex = new DmCoreException(t, msg, msgId, mqe.reasonCode, mqe.completionCode, 20);
            throw ex;
        }
        catch (Exception e) {
            String messageId = "AMQ4059";
            String message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String)String.valueOf(50013));
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.connectUsingClient", 900, "Exception = " + e.toString());
            }
            DmCoreException ex = new DmCoreException(t, message, e, messageId, 50013, 2, 0);
            throw ex;
        }
    }

    private void updateStatus(Trace t, int status) {
        Object job = this.dmQueueManagerHandleInstance.beginUpdate(t);
        boolean result1 = this.dmQueueManagerHandleInstance.setAttributeValue(t, job, 11030, 0, status);
        int result2 = this.dmQueueManagerHandleInstance.actionChange(t, null, job, false);
        if (result1) {
            // empty if block
        }
    }

    private String getHostName(Trace t) {
        String retValue = "";
        int i = this.connName.indexOf("(");
        if (i < 0) {
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.getHostName", 300, "Host name : " + this.connName.trim());
            }
            return this.connName.trim();
        }
        retValue = this.connName.substring(0, i).trim();
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.getHostName", 300, "Host name : " + retValue);
        }
        return retValue;
    }

    private int getPortAddress(Trace t) {
        int retValue;
        block5: {
            retValue = 1414;
            int i = this.connName.lastIndexOf(")");
            if (i < 0) {
                if (Trace.isTracing) {
                    t.data(65, "PingQueueManager.getPortAddress", 300, "Using default port address");
                }
                return retValue;
            }
            int j = this.connName.indexOf("(");
            String temp = this.connName.substring(j + 1, i);
            try {
                retValue = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                if (!Trace.isTracing) break block5;
                t.data(65, "PingQueueManager.getPortAddress", 900, "Invalid port address in " + this.connName);
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.getPortAddress", 300, "Port address : " + retValue);
        }
        return retValue;
    }

    public void stop(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.stop", 300, "Connection thread active status is " + this.active);
        }
        if (this.active) {
            if (Trace.isTracing) {
                t.data(65, "PingQueueManager.stop", 300, "Interrupt sent");
            }
            this.myself.interrupt();
        }
    }

    private void inquire(Trace t, MQQueueManager mqqm) throws MQException {
        int[] ids = new int[]{2015, 2032};
        byte[] response = new byte[96];
        mqqm.inquire(ids, new int[0], response);
        String resp = new String(response);
        this.pingedQueueManagerName = resp.substring(0, 48).trim();
        this.pingedQueueManagerUUID = resp.substring(48).trim();
        if (Trace.isTracing) {
            t.data(65, "PingQueueManager.inquire", 300, "pinged name=" + this.pingedQueueManagerName + ", uuid=" + this.pingedQueueManagerUUID);
        }
    }

    private Hashtable<String, Object> getConnectOptions(Trace t) throws DmCoreException {
        Hashtable<String, Object> table = null;
        QueueManagerHandle connectionHandle = this.dmQueueManagerHandle.getQueueManagerHandle(t);
        table = this.dmQueueManager.isConnected() ? (this.dmQueueManagerHandleInstance.isActiveInstance(t) ? connectionHandle.getSecurityOptions(t) : new Hashtable()) : connectionHandle.getSecurityOptions(t);
        table.put("hostname", this.getHostName(t));
        table.put("port", this.getPortAddress(t));
        table.put("channel", connectionHandle.getChannel());
        table.put("transport", "MQSeries Client");
        int ccsid = CorePlugin.getCCSID();
        table.put("CCSID", ccsid);
        if (!table.containsKey("userID")) {
            String userID = System.getProperty("user.name", "");
            table.put("userID", userID);
        }
        return table;
    }
}

