/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.SingleItemIterator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ResponseTableEntry {
    protected PCFMessage response;
    protected Object key;
    protected long timestamp;

    protected ResponseTableEntry() {
    }

    public ResponseTableEntry(PCFMessage response, Object key, long timestamp) {
        this.response = response;
        this.key = key;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isUpdate(long timestamp) {
        if (timestamp != this.timestamp) {
            this.timestamp = timestamp;
            return true;
        }
        return false;
    }

    public boolean isDeleted(long timestamp, PCFQuery query, boolean filteredAtServer) throws PCFException {
        return timestamp != this.timestamp && (query == null || query.matches(this.response, filteredAtServer));
    }

    public void set(PCFMessage response) {
        this.response = response;
    }

    public boolean matches(PCFMessage response) {
        return this.matches(response, this.response);
    }

    public void next() {
    }

    public PCFMessage getPrev(PCFMessage response) {
        PCFMessage prev = this.response;
        if (this.matches(response, prev)) {
            return response;
        }
        return prev;
    }

    public Object getKey() {
        return this.key;
    }

    public int getChildIndex() {
        return 0;
    }

    public Iterator iterator() {
        return new SingleItemIterator(this.response);
    }

    protected final boolean matches(PCFMessage a, PCFMessage b) {
        boolean match;
        boolean bl = match = a.getCommand() == b.getCommand() && a.getCompCode() == b.getCompCode() && a.getReason() == b.getReason() && a.getParameterCount() == b.getParameterCount();
        if (match) {
            try {
                Enumeration e1 = a.getParameters();
                Enumeration e2 = b.getParameters();
                while (match && e1.hasMoreElements()) {
                    PCFParameter p1 = (PCFParameter)e1.nextElement();
                    PCFParameter p2 = (PCFParameter)e2.nextElement();
                    int p = p1.getParameter();
                    boolean bl2 = match = this.isNonMatchableParameter(p) && p == p2.getParameter() || p1.equals((Object)p2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return match;
    }

    private boolean isNonMatchableParameter(int parameter) {
        return parameter == 7004 || parameter == 7003;
    }

    public void clearDeleted() {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "\n   - timestamp: " + this.timestamp;
    }
}

