/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.Selector;
import java.util.regex.Pattern;

public class ProfileNameSelector
extends Selector {
    public static final String ALL_PROFILES = "**";
    final String wildcardValue;

    public ProfileNameSelector(int id) {
        this(id, ALL_PROFILES);
    }

    public ProfileNameSelector(int id, String defaultValue) {
        super(id);
        this.wildcardValue = defaultValue;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean matches(PCFMessage response, Object value) throws PCFException {
        boolean asWildcard;
        Object actual = response.getParameterValue(this.id);
        Object options = response.getParameterValue(1228);
        boolean bl = asWildcard = ((Integer)options & 0x40) == 64;
        if (actual != null) {
            actual = ((String)actual).trim();
        }
        if (value == null) {
            return this.wildcardValue == null || this.isSubset((String)actual, this.wildcardValue, asWildcard);
        }
        return actual == null || this.isSubset((String)actual, (String)value, asWildcard);
    }

    @Override
    public Object getWildcardValue() {
        return this.wildcardValue;
    }

    @Override
    public boolean isSubset(Object a, Object b) {
        return this.isSubset((String)a, (String)b, false);
    }

    private boolean isSubset(String a, String b, boolean asWildcard) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return asWildcard && b.equals(ALL_PROFILES) || Pattern.matches(this.toRegex(a), b.replace('.', ' '));
    }

    private String toRegex(String profile) {
        int length = profile.length();
        StringBuffer sb = new StringBuffer(length + 8);
        int i = 0;
        while (i < length) {
            char c = profile.charAt(i);
            switch (c) {
                case '.': {
                    sb.append(' ');
                    break;
                }
                case '?': {
                    sb.append('.');
                    break;
                }
                case '*': {
                    if (i < length - 1 && profile.charAt(i + 1) == '*') {
                        sb.append(".*");
                        break;
                    }
                    sb.append("\\S*");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return new String(sb);
    }

    @Override
    public Object generalize(Object a, Object b) {
        if (a == null || a.equals(ALL_PROFILES)) {
            return ALL_PROFILES;
        }
        if (b == null || b.equals(ALL_PROFILES)) {
            return ALL_PROFILES;
        }
        if (a.equals(b)) {
            return a;
        }
        return ALL_PROFILES;
    }

    @Override
    public void write(PCFMessage request, Object value) {
        if (value != null) {
            request.addParameter((PCFParameter)new MQCFST(this.id, (String)value));
        } else if (this.wildcardValue != null) {
            request.addParameter((PCFParameter)new MQCFST(this.id, this.wildcardValue));
        }
    }
}

