/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.AttrsSelector;
import com.ibm.mq.pcf.event.IntegerSelector;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.Selector;
import com.ibm.mq.pcf.event.StringSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PCFQueryTemplate
implements PCFQuery.Template {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.pcf.event/src/com/ibm/mq/pcf/event/PCFQueryTemplate.java";
    public static final int NULL_ID = -1;
    private final Selector[] selectors;
    private final int command;
    private final int nameSelectorIndex;
    private final int typeSelectorIndex;
    private final int attrsSelectorIndex;
    private int parentObjectType = -1;
    private int responseNameId;
    private int[] expectedReasonCodes;
    private int[] keyAttrs;

    public PCFQueryTemplate(int command, int nameId, int ignoreReasonCode) {
        this(command, nameId, -1, -1, -1, -1, ignoreReasonCode);
    }

    public PCFQueryTemplate(int command, int attrsId, int attrsWildcard, int ignoreReasonCode) {
        this(command, -1, -1, -1, attrsId, attrsWildcard, ignoreReasonCode);
    }

    public PCFQueryTemplate(int command, int nameId, int attrsId, int attrsWildcard, int ignoreReasonCode) {
        this(command, nameId, -1, -1, attrsId, attrsWildcard, ignoreReasonCode);
    }

    public PCFQueryTemplate(int command, int nameId, int typeId, int typeWildcard, int attrsId, int attrsWildcard, int ignoreReasonCode) {
        Trace t = Trace.getDefault();
        this.command = command;
        ArrayList<Selector> list = new ArrayList<Selector>(3);
        if (nameId != -1) {
            this.nameSelectorIndex = list.size();
            list.add(new StringSelector(nameId));
            this.responseNameId = nameId;
        } else {
            this.nameSelectorIndex = -1;
        }
        if (typeId != -1) {
            this.typeSelectorIndex = list.size();
            list.add(new IntegerSelector(typeId, typeWildcard));
        } else {
            this.typeSelectorIndex = -1;
        }
        if (attrsId != -1) {
            this.attrsSelectorIndex = list.size();
            list.add(new AttrsSelector(attrsId, attrsWildcard));
        } else {
            this.attrsSelectorIndex = -1;
        }
        this.selectors = list.toArray(new Selector[list.size()]);
        this.expectedReasonCodes = new int[]{ignoreReasonCode};
        if (Trace.isTracing) {
            t.data(65, "PCFQueryTemplate.PCFQueryTemplate", 300, "PCFQueryTemplate created " + this.toString());
        }
    }

    public PCFQueryTemplate(int command, PCFParameter[] defaultParameters, int ignoreReasonCode) {
        Trace t = Trace.getDefault();
        this.command = command;
        ArrayList<Selector> list = new ArrayList<Selector>(defaultParameters.length);
        int i = 0;
        while (i < defaultParameters.length) {
            PCFParameter p = defaultParameters[i];
            if (p.getParameter() != -1) {
                list.add(Selector.createSelector(t, p));
            }
            ++i;
        }
        this.selectors = list.toArray(new Selector[list.size()]);
        if (this.selectors.length > 0 && (this.selectors[0].getType() == 4 || this.selectors[0].getType() == 9)) {
            this.nameSelectorIndex = 0;
            this.responseNameId = this.selectors[0].getId();
        } else {
            this.nameSelectorIndex = -1;
        }
        this.typeSelectorIndex = this.selectors.length > 1 && this.nameSelectorIndex != -1 && this.selectors[1].getType() == 3 && this.selectors[1].getWildcardValue() != null ? 1 : -1;
        this.attrsSelectorIndex = this.selectors.length > 0 && this.selectors[this.selectors.length - 1].getType() == 5 ? this.selectors.length - 1 : -1;
        this.expectedReasonCodes = new int[]{ignoreReasonCode};
        if (Trace.isTracing) {
            t.data(65, "PCFQueryTemplate.PCFQueryTemplate", 300, "PCFQueryTemplate created " + this.toString());
        }
    }

    public PCFQueryTemplate(int command, PCFParameter[] defaultParameters, int ignoreReasonCode, int responseNameId) {
        this(command, defaultParameters, ignoreReasonCode);
        this.responseNameId = responseNameId;
    }

    public PCFQueryTemplate(int command, PCFParameter[] defaultParameters, int ignoreReasonCode, int responseNameId, int parentObjectType) {
        this(command, defaultParameters, ignoreReasonCode);
        this.responseNameId = responseNameId;
        this.parentObjectType = parentObjectType;
    }

    @Override
    public int getCommand() {
        return this.command;
    }

    @Override
    public int getNameId() {
        return this.getId(this.nameSelectorIndex);
    }

    int getNameSelectorIndex() {
        return this.nameSelectorIndex;
    }

    @Override
    public int getTypeId() {
        return this.getId(this.typeSelectorIndex);
    }

    @Override
    public int getTypeWildcard() {
        return this.typeSelectorIndex >= 0 ? (Integer)this.selectors[this.typeSelectorIndex].getWildcardValue() : -1;
    }

    int getTypeSelectorIndex() {
        return this.typeSelectorIndex;
    }

    @Override
    public int getAttrsId() {
        return this.getId(this.attrsSelectorIndex);
    }

    @Override
    public int getAttrsWildcard() {
        return this.attrsSelectorIndex >= 0 ? ((int[])this.selectors[this.attrsSelectorIndex].getWildcardValue())[0] : -1;
    }

    int getAttrsSelectorIndex() {
        return this.attrsSelectorIndex;
    }

    @Override
    public int getIgnoreReasonCode() {
        return this.expectedReasonCodes == null ? 0 : this.expectedReasonCodes[0];
    }

    @Override
    public int getResponseNameId() {
        return this.responseNameId;
    }

    @Override
    public Object getKey(PCFMessage response) {
        int[] attrs = this.keyAttrs;
        if (attrs != null) {
            StringBuffer sb = new StringBuffer(Integer.toString(this.command));
            int i = 0;
            while (i < attrs.length) {
                PCFParameter p = response.getParameter(attrs[i]);
                sb.append('/');
                if (p != null) {
                    sb.append(p.getStringValue());
                }
                ++i;
            }
            return new String(sb);
        }
        return this.getObjectName(response);
    }

    @Override
    public String getObjectName(PCFMessage response) {
        PCFParameter p = response.getParameter(this.getResponseNameId());
        return p == null ? null : p.getStringValue();
    }

    @Override
    public int getParentObjectType() {
        return this.parentObjectType;
    }

    int getSelectorCount() {
        return this.selectors.length;
    }

    Selector getSelector(int index) {
        return this.selectors[index];
    }

    int getSelectorIndex(int id) {
        int index = -1;
        int i = 0;
        while (i < this.selectors.length && index < 0) {
            if (this.selectors[i].id == id) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void setKeyAttrs(int[] attrs) {
        this.keyAttrs = attrs;
    }

    public List optimize(List queries, boolean includeFilters) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(65, "PCFQueryTemplate.optimize", 300, "Number of queries is " + queries.size());
        }
        ArrayList<PCFQuery> results = new ArrayList<PCFQuery>();
        for (PCFQuery q : queries) {
            PCFQuery r;
            if (q.getTemplate() != this) {
                throw new IllegalArgumentException("Query must match optimizer template");
            }
            int j = 0;
            while (j < results.size()) {
                r = (PCFQuery)results.get(j);
                if (this.isSubsetIdentity(r, q, includeFilters)) {
                    if (!this.isSubsetAttrs(r.getAttrs(), q.getAttrs())) {
                        q = new PCFQuery(q, r);
                    }
                    results.remove(j--);
                }
                ++j;
            }
            j = 0;
            while (q != null && j < results.size()) {
                r = (PCFQuery)results.get(j);
                if (this.isSubsetIdentity(q, r, includeFilters)) {
                    if (!this.isSubsetAttrs(q.getAttrs(), r.getAttrs())) {
                        results.set(j, new PCFQuery(r, q));
                    }
                    q = null;
                }
                ++j;
            }
            if (q == null) continue;
            results.add(q);
        }
        if (Trace.isTracing) {
            t.data(65, "PCFQueryTemplate.optimize", 300, "Number of queries returned " + results.size());
        }
        return results;
    }

    public boolean isSubsetIdentity(PCFQuery a, PCFQuery b, boolean includeFilters) {
        return this.isSubsetQuery(a, b, true, includeFilters);
    }

    public boolean isSubsetQuery(PCFQuery a, PCFQuery b, boolean identityOnly, boolean includeFilters) {
        boolean subset = true;
        int i = 0;
        while (i < this.selectors.length && subset) {
            if (this.selectors[i].getRole() == 1) {
                subset = this.selectors[i].isSubset(a.getValue(i), b.getValue(i));
            }
            ++i;
        }
        return subset && (!includeFilters || this.isSubsetFilter(a.getFilter(), b.getFilter()));
    }

    public boolean isSubsetAttrs(int[] a, int[] b) {
        return b == null || Arrays.equals(b, PCFQuery.ALL_ATTRS) || AttrsSelector.generalize(a, b).length == b.length;
    }

    public boolean isSubsetFilter(PCFFilter a, PCFFilter b) {
        return b == null || b == PCFFilter.getNullFilter() || b.equals(a);
    }

    public PCFFilter generalizeFilter(PCFFilter a, PCFFilter b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.equals(b)) {
            return a;
        }
        return null;
    }

    private int getId(int selectorIndex) {
        return selectorIndex >= 0 ? this.selectors[selectorIndex].getId() : -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getClass().getName()) + " [command: " + this.command + ", name@" + this.nameSelectorIndex + ", type@" + this.typeSelectorIndex + ", attrs@" + this.attrsSelectorIndex + "]");
        int i = 0;
        while (i < this.selectors.length) {
            sb.append("\n   - selectors [" + i + "]: " + this.selectors[i]);
            ++i;
        }
        return new String(sb);
    }

    @Override
    public void setIgnoreReasonCode(int value) {
        this.expectedReasonCodes = new int[]{value};
    }

    @Override
    public boolean getSuppressName() {
        return this.getNameSelectorIndex() < 0;
    }

    @Override
    public boolean isBinaryName() {
        return this.getNameSelectorIndex() >= 0 && this.selectors[this.getNameSelectorIndex()].getType() == 9;
    }

    @Override
    public void setResponseNameId(int value) {
        this.responseNameId = value;
    }

    @Override
    public void setParentObjectType(int value) {
        this.parentObjectType = value;
    }

    public boolean isExpected(int reasonCode) {
        int[] codes = this.expectedReasonCodes;
        if (codes == null) {
            return false;
        }
        boolean match = false;
        int i = 0;
        while (i < codes.length && !match) {
            match = reasonCode == codes[i];
            ++i;
        }
        return match;
    }

    public void addExpectedReasonCode(int reasonCode) {
        if (this.expectedReasonCodes == null) {
            this.expectedReasonCodes = new int[]{reasonCode};
        } else if (!this.isExpected(reasonCode)) {
            int length = this.expectedReasonCodes.length;
            this.expectedReasonCodes = new int[length + 1];
            System.arraycopy(this.expectedReasonCodes, 0, this.expectedReasonCodes, 0, length);
            this.expectedReasonCodes[length] = reasonCode;
        }
    }
}

