/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PCFQueryOptimizer {
    final PCFQuery.Template template;

    public PCFQueryOptimizer(PCFQuery.Template template) {
        this.template = template;
    }

    public List optimize(List queries, boolean includeFilters) {
        ArrayList<PCFQuery> results = new ArrayList<PCFQuery>();
        for (PCFQuery q : queries) {
            PCFQuery r;
            if (q.getTemplate() != this.template) {
                throw new IllegalArgumentException("Query must match optimizer template");
            }
            int j = 0;
            while (j < results.size()) {
                r = (PCFQuery)results.get(j);
                if (this.isSubsetIdentity(r, q, includeFilters)) {
                    if (!this.isSubsetAttrs(r.getAttrs(), q.getAttrs())) {
                        q = new PCFQuery(q, this.generalizeAttrs(r.getAttrs(), q.getAttrs()));
                    }
                    results.remove(j--);
                }
                ++j;
            }
            j = 0;
            while (q != null && j < results.size()) {
                r = (PCFQuery)results.get(j);
                if (this.isSubsetIdentity(q, r, includeFilters)) {
                    if (!this.isSubsetAttrs(q.getAttrs(), r.getAttrs())) {
                        results.set(j, new PCFQuery(r, this.generalizeAttrs(q.getAttrs(), r.getAttrs())));
                    }
                    q = null;
                }
                ++j;
            }
            if (q == null) continue;
            results.add(q);
        }
        return results;
    }

    public boolean isSubsetIdentity(PCFQuery a, PCFQuery b, boolean includeFilters) {
        return this.isSubsetName(a.getName(), b.getName()) && this.isSubsetType(a.getType(), b.getType()) && (!includeFilters || this.isSubsetFilter(a.getFilter(), b.getFilter()));
    }

    public boolean isSubsetQuery(PCFQuery a, PCFQuery b) {
        return this.isSubsetName(a.getName(), b.getName()) && this.isSubsetType(a.getType(), b.getType()) && this.isSubsetAttrs(a.getAttrs(), b.getAttrs()) && this.isSubsetFilter(a.getFilter(), b.getFilter());
    }

    public boolean isSubsetName(String a, String b) {
        return b == null || b.equals("*") || this.generalizeName(a, b).equals(b);
    }

    public boolean isSubsetType(int a, int b) {
        return a == b || b == this.template.getTypeWildcard();
    }

    public boolean isSubsetAttrs(int[] a, int[] b) {
        return b == null || Arrays.equals(b, PCFQuery.ALL_ATTRS) || this.generalizeAttrs(a, b).length == b.length;
    }

    public boolean isSubsetFilter(PCFFilter a, PCFFilter b) {
        return b == null || b == PCFFilter.getNullFilter() || b.equals(a);
    }

    public String generalizeName(String a, String b) {
        if (a == null || a.equals("*")) {
            return "*";
        }
        if (b == null || b.equals("*")) {
            return "*";
        }
        if (a.equals(b)) {
            return a;
        }
        return this.getCommonWildcard(a, b);
    }

    public int generalizeType(int a, int b) {
        if (a == b) {
            return a;
        }
        return this.template.getTypeWildcard();
    }

    public int[] generalizeAttrs(int[] a, int[] b) {
        Integer o;
        if (a == null || b == null) {
            return PCFQuery.ALL_ATTRS;
        }
        if (Arrays.equals(a, b)) {
            return a;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < a.length) {
            o = a[i];
            map.put(o, o);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            o = b[i];
            map.put(o, o);
            ++i;
        }
        List<Object> list = Arrays.asList(map.values().toArray());
        Collections.sort(list);
        Iterator<Object> it = list.iterator();
        int[] merged = new int[list.size()];
        int i2 = 0;
        while (i2 < merged.length) {
            merged[i2] = (Integer)it.next();
            ++i2;
        }
        return merged;
    }

    public PCFFilter generalizeFilter(PCFFilter a, PCFFilter b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.equals(b)) {
            return a;
        }
        return null;
    }

    private String getCommonWildcard(String a, String b) {
        int pos = 0;
        int limit = Math.min(a.length(), b.length());
        while (pos < limit && a.charAt(pos) == b.charAt(pos)) {
            ++pos;
        }
        if (pos == 0) {
            return "*";
        }
        if (a.charAt(pos - 1) == '*') {
            return a.substring(0, pos + 1);
        }
        return String.valueOf(a.substring(0, pos)) + '*';
    }

    private boolean isUniqueObjectName(String name) {
        return name != null && name.length() > 0 && name.indexOf(42) < 0;
    }
}

