/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFBF;
import com.ibm.mq.pcf.MQCFIF;
import com.ibm.mq.pcf.MQCFSF;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.util.ArrayList;

public class PCFFilter {
    public static final Operation GREATER_THAN = new Operation("greater than", 4);
    public static final Operation LESS_THAN = new Operation("less than", 1);
    public static final Operation EQUAL_TO = new Operation("equal", 2);
    public static final Operation NOT_EQUAL = new Operation("not equal", 5);
    public static final Operation NOT_LESS_THAN = new Operation("not less than", 6);
    public static final Operation NOT_GREATER_THAN = new Operation("not greater than", 3);
    public static final Operation CONTAINS = new Operation("contains", 10);
    public static final Operation CONTAINS_GEN = new Operation("like", 26, true);
    public static final Operation EXCLUDES = new Operation("like", 13);
    public static final Operation EXCLUDES_GEN = new Operation("like", 29, true);
    public static final Operation LIKE = new Operation("like", 18, true);
    public static final Operation NOT_LIKE = new Operation("like", 21, true);
    static final PCFFilter nullFilter = new PCFFilter();
    final Operation operation;
    final int parameter;
    private final InternalFilter filter;

    public static PCFFilter getNullFilter() {
        return nullFilter;
    }

    public static PCFFilter getFilter(int parameter, Operation operation, int value) {
        return new PCFFilter(parameter, operation, value);
    }

    public static PCFFilter getFilter(int parameter, Operation operation, String value) {
        return new PCFFilter(parameter, operation, value.trim());
    }

    public static PCFFilter getFilter(int parameter, Operation operation, byte[] value) {
        return new PCFFilter(parameter, operation, value);
    }

    static Operation getOperation(int type) {
        switch (type) {
            case 4: {
                return GREATER_THAN;
            }
            case 1: {
                return LESS_THAN;
            }
            case 2: {
                return EQUAL_TO;
            }
            case 5: {
                return NOT_EQUAL;
            }
            case 6: {
                return NOT_LESS_THAN;
            }
            case 3: {
                return NOT_GREATER_THAN;
            }
            case 10: {
                return CONTAINS;
            }
            case 26: {
                return CONTAINS_GEN;
            }
            case 13: {
                return EXCLUDES;
            }
            case 29: {
                return EXCLUDES_GEN;
            }
            case 18: {
                return LIKE;
            }
            case 21: {
                return NOT_LIKE;
            }
        }
        throw new IllegalArgumentException("Invalid filter type: " + type);
    }

    private PCFFilter() {
        this.parameter = -1;
        this.operation = EQUAL_TO;
        this.filter = new InternalFilter(){

            @Override
            protected final boolean matches(PCFMessage message) {
                return true;
            }

            @Override
            protected final Object getValue() {
                return null;
            }

            @Override
            protected final int getType() {
                return -1;
            }

            @Override
            protected final PCFParameter createPCFParameter() {
                throw new UnsupportedOperationException("createPCFParameter not supported by null filter");
            }

            @Override
            protected final void write(PCFMessage request) {
            }
        };
    }

    public PCFFilter(int parameter, int type, int value) {
        this(parameter, PCFFilter.getOperation(type), value);
    }

    private PCFFilter(int parameter, Operation operation, final int value) {
        if (operation.isGeneric()) {
            throw new IllegalArgumentException("Operation " + operation.name + " cannot be applied to int values");
        }
        this.parameter = parameter;
        this.operation = operation;
        this.filter = new InternalFilter(){

            @Override
            protected final boolean matches(PCFMessage message) {
                PCFParameter p = message.getParameter(PCFFilter.this.parameter);
                Integer i = null;
                int[] list = null;
                if (p != null) {
                    if (p.getType() == 3) {
                        i = (Integer)p.getValue();
                    } else if (p.getType() == 5) {
                        list = (int[])p.getValue();
                    }
                }
                switch (PCFFilter.this.operation.value) {
                    case 4: {
                        return i != null && i > value;
                    }
                    case 1: {
                        return i != null && i < value;
                    }
                    case 2: {
                        return i != null && i == value;
                    }
                    case 5: {
                        return i != null && i != value;
                    }
                    case 6: {
                        return i != null && i >= value;
                    }
                    case 3: {
                        return i != null && i <= value;
                    }
                    case 10: {
                        return i != null && (i & value) == value || list != null && this.matches(list);
                    }
                    case 13: {
                        return list == null || !this.matches(list);
                    }
                }
                return false;
            }

            private boolean matches(int[] array) {
                boolean match = false;
                int i = 0;
                while (i < array.length && !match) {
                    match = array[i] == value;
                    ++i;
                }
                return match;
            }

            @Override
            protected final Object getValue() {
                return value;
            }

            @Override
            protected final int getType() {
                return 13;
            }

            @Override
            protected final PCFParameter createPCFParameter() {
                return new MQCFIF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value);
            }

            @Override
            protected final void write(PCFMessage request) {
                request.addParameter((PCFParameter)new MQCFIF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value));
            }
        };
    }

    public PCFFilter(int parameter, int operation, String value) {
        this(parameter, PCFFilter.getOperation(operation), value.equals(" ") ? value : value.trim());
    }

    private PCFFilter(int parameter, Operation operation, final String value) {
        final String root = operation.isGeneric() ? this.getRoot(value) : null;
        this.parameter = parameter;
        this.operation = operation;
        this.filter = new InternalFilter(){

            @Override
            protected final boolean matches(PCFMessage message) {
                PCFParameter p = message.getParameter(PCFFilter.this.parameter);
                String string = null;
                String[] array = null;
                if (p != null) {
                    if (p.getType() == 4) {
                        string = ((String)p.getValue()).trim();
                    } else if (p.getType() == 6) {
                        array = (String[])p.getValue();
                    }
                }
                switch (PCFFilter.this.operation.value) {
                    case 4: {
                        return string != null && string.compareTo(value) > 0;
                    }
                    case 1: {
                        return string != null && string.compareTo(value) < 0;
                    }
                    case 2: {
                        return string != null && string.equals(value);
                    }
                    case 5: {
                        return string != null && !string.equals(value);
                    }
                    case 6: {
                        return string != null && string.compareTo(value) >= 0;
                    }
                    case 3: {
                        return string != null && string.compareTo(value) <= 0;
                    }
                    case 10: 
                    case 26: {
                        return array != null && this.matches(array);
                    }
                    case 13: 
                    case 29: {
                        return array == null || !this.matches(array);
                    }
                    case 18: {
                        return string != null && string.startsWith(root);
                    }
                    case 21: {
                        return string == null || !string.startsWith(root);
                    }
                }
                return false;
            }

            private final boolean matches(String[] array) {
                boolean match = false;
                if (root == null) {
                    int i = 0;
                    while (i < array.length && !match) {
                        match = array[i] != null && array[i].trim().equals(value);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < array.length && !match) {
                        match = array[i] != null && array[i].trim().startsWith(root);
                        ++i;
                    }
                }
                return match;
            }

            @Override
            protected final Object getValue() {
                return value;
            }

            @Override
            protected final int getType() {
                return 14;
            }

            @Override
            protected final PCFParameter createPCFParameter() {
                return new MQCFSF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value);
            }

            @Override
            protected final void write(PCFMessage request) {
                request.addParameter((PCFParameter)new MQCFSF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value));
            }
        };
    }

    public PCFFilter(int parameter, int operation, byte[] value) {
        this(parameter, PCFFilter.getOperation(operation), value);
    }

    private PCFFilter(int parameter, Operation operation, final byte[] value) {
        this.parameter = parameter;
        this.operation = operation;
        this.filter = new InternalFilter(){
            final byte[] EMPTY;
            {
                this.EMPTY = new byte[0];
            }

            @Override
            protected final boolean matches(PCFMessage message) {
                PCFParameter p = message.getParameter(PCFFilter.this.parameter);
                byte[] bytes = null;
                if (p != null) {
                    bytes = (byte[])p.getValue();
                }
                switch (PCFFilter.this.operation.value) {
                    case 2: {
                        return bytes != null && this.compare(value, bytes) == 0;
                    }
                    case 5: {
                        return bytes != null && this.compare(value, bytes) != 0;
                    }
                    case 4: {
                        return bytes != null && this.compare(value, bytes) > 0;
                    }
                    case 1: {
                        return bytes != null && this.compare(value, bytes) < 0;
                    }
                    case 3: {
                        return bytes != null && this.compare(value, bytes) <= 0;
                    }
                    case 6: {
                        return bytes != null && this.compare(value, bytes) >= 0;
                    }
                }
                return false;
            }

            private int compare(byte[] a, byte[] b) {
                if (a == null) {
                    a = this.EMPTY;
                }
                if (b == null) {
                    b = this.EMPTY;
                }
                int limit = Math.min(a.length, b.length);
                int match = 0;
                int i = 0;
                while (i < limit && match == 0) {
                    match = b[i] - a[i];
                    ++i;
                }
                if (match == 0) {
                    match = b.length - a.length;
                }
                return match;
            }

            private boolean isNullOrEmpty(byte[] bytes) {
                return bytes == null || bytes.length == 0;
            }

            @Override
            protected final Object getValue() {
                return value;
            }

            @Override
            protected final int getType() {
                return 15;
            }

            @Override
            protected final PCFParameter createPCFParameter() {
                return new MQCFBF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value);
            }

            @Override
            protected final void write(PCFMessage request) {
                request.addParameter((PCFParameter)new MQCFBF(PCFFilter.this.parameter, PCFFilter.this.operation.getValue(), value));
            }
        };
    }

    public final int getParameter() {
        return this.parameter;
    }

    public final int getOperation() {
        return this.operation.getValue();
    }

    public final int getType() {
        return this.filter.getType();
    }

    public final Object getValue() {
        return this.filter.getValue();
    }

    public final boolean matches(PCFMessage message) {
        return this.filter.matches(message);
    }

    public PCFMessage[] filter(PCFMessage[] responses) {
        if (this == nullFilter) {
            return responses;
        }
        ArrayList<PCFMessage> list = new ArrayList<PCFMessage>();
        int i = 0;
        while (i < responses.length) {
            PCFMessage response = responses[i];
            if (response != null && this.matches(response)) {
                list.add(response);
            }
            ++i;
        }
        return list.toArray(new PCFMessage[list.size()]);
    }

    public final PCFParameter createPCFParameter() {
        return this.filter.createPCFParameter();
    }

    void write(PCFMessage request) {
        this.filter.write(request);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof PCFFilter) {
            PCFFilter f = (PCFFilter)other;
            return this.operation == f.operation && this.parameter == f.parameter && (this.getValue() == null && f.getValue() == null || this.getValue().equals(f.getValue()));
        }
        return false;
    }

    private final String getRoot(String value) {
        String root;
        block7: {
            int index;
            int length;
            block6: {
                length = value.length();
                index = value.indexOf(39);
                if (index >= 0) break block6;
                root = value.charAt(length - 1) == '*' ? value.substring(0, length - 1) : value;
                break block7;
            }
            StringBuffer sb = new StringBuffer(value.substring(0, index));
            int c = 0;
            int i = index;
            while (i < length) {
                block8: {
                    block9: {
                        char c2 = value.charAt(i);
                        c = c2;
                        sb.append(c2);
                        if (c != 39) break block8;
                        if (++i == length) break block9;
                        char c3 = value.charAt(i);
                        c = c3;
                        if (c3 == '\'') break block8;
                    }
                    throw new IllegalArgumentException("Unmatched ' in string \"" + value + '\"');
                }
                ++i;
            }
            if (c == 42) {
                sb.setLength(sb.length() - 1);
            }
            root = new String(sb);
        }
        if (root.indexOf(42) >= 0) {
            throw new IllegalArgumentException("Invalid wildcard string \"" + value + "\": '*' must appear only as last character");
        }
        return root;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [id " + this.parameter + ' ' + this.operation.getName() + ' ' + this.getValue() + ']';
    }

    private static abstract class InternalFilter {
        private InternalFilter() {
        }

        protected abstract int getType();

        protected abstract Object getValue();

        protected abstract boolean matches(PCFMessage var1);

        protected abstract PCFParameter createPCFParameter();

        protected abstract void write(PCFMessage var1);
    }

    private static class Operation {
        final String name;
        final int value;
        final boolean generic;

        private Operation(String name, int operation) {
            this(name, operation, false);
        }

        private Operation(String name, int operation, boolean generic) {
            this.name = name;
            this.value = operation;
            this.generic = generic;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isGeneric() {
            return this.generic;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ": " + this.value + " (" + this.name + ')';
        }
    }
}

