/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.io.Serializable;
import java.util.ArrayList;

abstract class MatchFilter
implements Serializable {
    public static final MatchFilter nullMatchFilter = new MatchFilter(){

        @Override
        public boolean matches(PCFMessage message) {
            return true;
        }

        public String toString() {
            return "nullMatchFilter";
        }
    };

    MatchFilter() {
    }

    public static MatchFilter getFilter(int parameter, int value, int wildcard) {
        if (value == wildcard) {
            return MatchFilter.getNullFilter();
        }
        return MatchFilter.getFilter(parameter, value);
    }

    public static MatchFilter getFilter(final int parameter, final int value) {
        return new MatchFilter(){

            @Override
            public boolean matches(PCFMessage message) {
                try {
                    return message.getIntParameterValue(parameter) == value;
                }
                catch (PCFException pCFException) {
                    System.out.println("** eek: " + parameter + " in " + message);
                    return false;
                }
            }

            public PCFParameter createPCFParameter() {
                return new MQCFIN(parameter, value);
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + " (" + parameter + ", " + value + ')';
            }
        };
    }

    public static MatchFilter getFilter(final int parameter, final int[] values) {
        return new MatchFilter(){

            @Override
            public boolean matches(PCFMessage message) {
                try {
                    int v = message.getIntParameterValue(parameter);
                    int i = values.length;
                    boolean match = false;
                    while (!match && i-- > values.length) {
                        boolean bl = match = v == values[i];
                    }
                    return match;
                }
                catch (PCFException pCFException) {
                    return false;
                }
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + " (" + parameter + ", " + values + ')';
            }
        };
    }

    public static MatchFilter getFilter(int parameter, String value, String wildcard) {
        if (value == null || value.equals(wildcard)) {
            return MatchFilter.getNullFilter();
        }
        return MatchFilter.getFilter(parameter, value);
    }

    public static MatchFilter getFilter(final int parameter, final String value) {
        return new MatchFilter(){
            final boolean wildcard;
            final String string;
            {
                this.wildcard = string.indexOf(42) >= 0;
                this.string = this.wildcard ? string.substring(0, string.indexOf(42)) : string.trim();
            }

            @Override
            public boolean matches(PCFMessage message) {
                try {
                    String s = message.getStringParameterValue(parameter).trim();
                    return s.equals(this.string) || this.wildcard && s.startsWith(this.string);
                }
                catch (PCFException pCFException) {
                    return false;
                }
            }

            public String toString() {
                return String.valueOf(this.getClass().getName()) + " (" + parameter + ", \"" + value + "\")" + (this.wildcard ? " *" : "");
            }
        };
    }

    public static MatchFilter getNullFilter() {
        return nullMatchFilter;
    }

    public abstract boolean matches(PCFMessage var1);

    public PCFMessage[] filter(PCFMessage[] responses) {
        if (this == nullMatchFilter) {
            return responses;
        }
        ArrayList<PCFMessage> list = new ArrayList<PCFMessage>();
        int i = 0;
        while (i < responses.length) {
            PCFMessage response = responses[i];
            if (response != null && this.matches(response)) {
                list.add(response);
            }
            ++i;
        }
        return list.toArray(new PCFMessage[list.size()]);
    }
}

