/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.CachedState;
import com.ibm.mq.pcf.event.CompoundResponseTableEntry;
import com.ibm.mq.pcf.event.ListenerAdapter;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;
import com.ibm.mq.pcf.event.ResponseTableEntry;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class ListenerManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.pcf.event/src/com/ibm/mq/pcf/event/ListenerManager.java";
    private static final PCFMessage[] EMPTY_RESPONSES = new PCFMessage[0];
    public static Set<Integer> DEBUG;
    final PCFMonitorAgent agent;
    final PCFQueryTemplate template;
    final List<ListenerAdapter> listenerList = new ArrayList<ListenerAdapter>();
    final Map<Object, ResponseTableEntry> responseTable = new TreeMap<Object, ResponseTableEntry>();
    private ListenerAdapter[] adaptersArray;
    private PCFMessage[] requests;
    private int sendCount = 0;
    private boolean filterAtServer;

    static {
        String value = System.getProperty("com.ibm.mq.pcf.event.ListenerManager.DEBUG");
        if (value != null) {
            String[] words;
            DEBUG = new HashSet<Integer>();
            String[] stringArray = words = value.split(",");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                Integer cmd = Integer.parseInt(word);
                DEBUG.add(cmd);
                ++n2;
            }
        }
    }

    ListenerManager(PCFMonitorAgent agent, PCFQueryTemplate template) {
        this.agent = agent;
        this.template = template;
    }

    protected synchronized void addListener(Trace t, ListenerAdapter adapter) {
        if (!this.listenerList.contains(adapter)) {
            this.listenerList.add(adapter);
            this.adaptersArray = null;
            this.requests = null;
            CachedState cached = this.getCachedState(t);
            adapter.fireEvents(cached.getResponses(), new PCFMessage[cached.size()], new ResponseTableEntry[0], cached.getKeys(), cached.getIndexes(), System.currentTimeMillis(), false, this.agent.getSendSummaryEvents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeListener(Object listener, PCFQuery query) {
        Iterator<ListenerAdapter> it = this.listenerList.iterator();
        while (it.hasNext()) {
            ListenerAdapter adapter = it.next();
            if (adapter.getListener() != listener || query != null && !query.equals(adapter.getQuery())) continue;
            it.remove();
            this.adaptersArray = null;
            this.requests = null;
        }
        if (this.listenerList.size() == 0) {
            Map<Object, ResponseTableEntry> map = this.responseTable;
            synchronized (map) {
                this.responseTable.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PCFMessage[] getResponses() {
        Map<Object, ResponseTableEntry> map = this.responseTable;
        synchronized (map) {
            ArrayList list = new ArrayList(this.responseTable.size());
            for (ResponseTableEntry entry : this.responseTable.values()) {
                Iterator it2 = entry.iterator();
                while (it2.hasNext()) {
                    list.add(it2.next());
                }
            }
            return list.toArray(new PCFMessage[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CachedState getCachedState(Trace t) {
        ArrayList responseList = null;
        ArrayList<Object> keyList = null;
        ArrayList<Integer> indexList = null;
        Integer zero = 0;
        Map<Object, ResponseTableEntry> map = this.responseTable;
        synchronized (map) {
            int size = this.responseTable.size();
            responseList = new ArrayList(size);
            keyList = new ArrayList<Object>(size);
            indexList = new ArrayList<Integer>(size);
            for (ResponseTableEntry entry : this.responseTable.values()) {
                Iterator it2 = entry.iterator();
                int childIndex = 0;
                while (it2.hasNext()) {
                    responseList.add(it2.next());
                    keyList.add(entry.getKey());
                    indexList.add(childIndex == 0 ? zero : Integer.valueOf(childIndex));
                    ++childIndex;
                }
            }
        }
        PCFMessage[] responses = responseList.toArray(new PCFMessage[responseList.size()]);
        Object[] keys = keyList.toArray();
        int[] indexes = new int[indexList.size()];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = (Integer)indexList.get(i);
            ++i;
        }
        if (Trace.isTracing) {
            t.data(65, "ListenerManager.getCachedState", 300, "Number of responses is " + responses.length);
        }
        return new CachedState(responses, keys, indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResponseCount() {
        Map<Object, ResponseTableEntry> map = this.responseTable;
        synchronized (map) {
            return this.sendCount > 0 ? this.responseTable.size() : -1;
        }
    }

    final PCFMessage[] snapshot(Trace t, PCFQuery query, boolean update) throws PCFException, MQException, IOException {
        PCFMessage[] returnVal = null;
        boolean subset = false;
        if (query != null && !update) {
            if (query.getTemplate() != this.template) {
                if (Trace.isTracing) {
                    t.data(65, "ListenerManager.snapshot", 900, "IllegalArgumentException - query must match listener manager template");
                }
                throw new IllegalArgumentException("Query must match listener manager template");
            }
            ListenerAdapter[] adapters = this.getListenerAdapters();
            int i = 0;
            while (!subset && i < adapters.length) {
                subset = this.template.isSubsetQuery(query, adapters[i].getQuery(), true, true);
                ++i;
            }
        }
        if (query != null && (update || !subset || this.getResponseCount() < 0)) {
            boolean filterAtServer = this.agent.getCommandLevel() >= 600;
            PCFMessage request = query.createPCFRequest(filterAtServer);
            try {
                if (Trace.isTracing) {
                    t.data(65, "ListenerManager.snapshot", 300, "Sending request to queue manager");
                }
                returnVal = this.agent.send(request);
                return returnVal;
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(65, "ListenerManager.snapshot", 900, "MQException is " + (Object)((Object)e));
                }
                if (this.template.isExpected(e.reasonCode)) {
                    return new PCFMessage[0];
                }
                PCFQuery.traceMQRequest(t, request);
                PCFQuery.traceMQException(t, e);
                throw e;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "ListenerManager.snapshot", 300, "Satisfying request from the cache");
        }
        if (query == null || subset) {
            return this.getResponses();
        }
        return query.filter(this.getResponses());
    }

    int send(Trace t) throws PCFException, MQException, IOException {
        return this.send(t, this.getRequests(this.agent.getCommandLevel() >= 600));
    }

    int send(Trace t, PCFMessage[] requests) throws PCFException, MQException, IOException {
        ArrayList<PCFMessage> responseList = new ArrayList<PCFMessage>();
        int i = 0;
        while (i < requests.length) {
            block5: {
                try {
                    if (DEBUG != null) {
                        this.debug("ListenerManager.send(t,PCFMessage[])", requests[i]);
                    }
                    PCFMessage[] responses = this.agent.send(requests[i]);
                    responseList.addAll(Arrays.asList(responses));
                }
                catch (MQException e) {
                    if (Trace.isTracing) {
                        t.data(65, "ListenerManager.send", 300, "MQException is " + (Object)((Object)e));
                    }
                    if (this.template.isExpected(e.reasonCode)) break block5;
                    PCFQuery.traceMQRequest(t, requests[i]);
                    PCFQuery.traceMQException(t, e);
                    throw e;
                }
            }
            ++i;
        }
        this.refresh(t, responseList.toArray(new PCFMessage[responseList.size()]), null, this.filterAtServer);
        return requests.length;
    }

    int send(Trace t, ListenerAdapter adapter) throws PCFException, MQException, IOException {
        PCFMessage[] responses;
        PCFQuery query;
        boolean filterAtServer;
        block4: {
            filterAtServer = this.agent.getCommandLevel() >= 600;
            query = adapter.getQuery();
            PCFMessage request = query.createPCFRequest(filterAtServer);
            responses = EMPTY_RESPONSES;
            try {
                if (DEBUG != null) {
                    this.debug("ListenerManager.send(t,ListenerAdapter)", request);
                }
                responses = this.agent.send(request);
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(65, "ListenerManager.send", 300, "MQException is " + (Object)((Object)e));
                }
                if (this.template.isExpected(e.reasonCode)) break block4;
                PCFQuery.traceMQRequest(t, request);
                PCFQuery.traceMQException(t, e);
                this.addChannelType(request, e);
                throw e;
            }
        }
        this.refresh(t, responses, query, filterAtServer);
        return 1;
    }

    private void addChannelType(PCFMessage request, MQException e) {
        PCFParameter channelTypeParam;
        if (request.getCommand() == 25 && e instanceof PCFException && (channelTypeParam = request.getParameter(1511)) != null) {
            PCFMessage[] msgs;
            PCFException pcfe = (PCFException)e;
            if (pcfe.exceptionSource instanceof PCFMessage[] && (msgs = (PCFMessage[])pcfe.exceptionSource)[0].getCommand() == 25) {
                msgs[0].addParameter(channelTypeParam);
                pcfe.exceptionSource = msgs;
            }
        }
    }

    private void debug(String text, PCFMessage msg) {
        int cmd = msg.getCommand();
        if (DEBUG.contains(cmd)) {
            this.log(text, msg);
        }
    }

    private void log(String text, PCFMessage msg) {
        int cmd = msg.getCommand();
        StringBuffer sb = new StringBuffer();
        sb.append(text);
        sb.append(": ");
        sb.append(MQConstants.lookup((int)cmd, (String)"MQCMD_.*"));
        System.out.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Trace t, PCFMessage[] responses, PCFQuery query, boolean filterAtServer) {
        int i;
        if (Trace.isTracing) {
            t.data(65, "ListenerManager.refresh", 300, "Number of response is " + responses.length);
        }
        int i2 = 0;
        while (i2 < responses.length) {
            switch (responses[i2].getType()) {
                case 2: 
                case 18: {
                    break;
                }
                default: {
                    responses[i2] = null;
                    if (!Trace.isTracing) break;
                    t.data(65, "ListenerManager.refresh", 300, "Nullifying response " + i2);
                }
            }
            ++i2;
        }
        PCFMessage[] previous = new PCFMessage[responses.length];
        ResponseTableEntry[] deleted = null;
        Object[] keys = new Object[responses.length];
        int[] indexes = new int[responses.length];
        long timestamp = this.sendCount++;
        int updatedCount = 0;
        Map<Object, ResponseTableEntry> map = this.responseTable;
        synchronized (map) {
            ResponseTableEntry entry;
            i = 0;
            while (i < responses.length) {
                PCFMessage response = responses[i];
                if (response != null) {
                    keys[i] = this.template.getKey(response);
                    Object key = keys[i];
                    if (key != null) {
                        entry = this.responseTable.get(key);
                        if (entry != null) {
                            PCFMessage prev;
                            if (entry.isUpdate(timestamp)) {
                                ++updatedCount;
                            }
                            if ((prev = entry.getPrev(response)) == response) {
                                responses[i] = null;
                            } else if (prev == null) {
                                entry.set(response);
                            } else {
                                previous[i] = prev;
                                entry.set(response);
                            }
                            indexes[i] = entry.getChildIndex();
                            entry.next();
                        } else {
                            if (this.template.getParentObjectType() != -1) {
                                if (this.template.isBinaryName()) {
                                    entry = new CompoundResponseTableEntry(response, key, timestamp, this.template.getResponseNameId(), true);
                                    this.responseTable.put(key, entry);
                                } else {
                                    entry = new CompoundResponseTableEntry(response, key, timestamp, this.template.getResponseNameId(), false);
                                    this.responseTable.put(key, entry);
                                }
                            } else {
                                entry = new ResponseTableEntry(response, key, timestamp);
                                this.responseTable.put(key, entry);
                            }
                            ++updatedCount;
                            entry.next();
                        }
                    } else {
                        responses[i] = null;
                    }
                }
                ++i;
            }
            int deletedCount = this.responseTable.size() - updatedCount;
            if (Trace.isTracing) {
                t.data(65, "ListenerManager.refresh", 300, "Deleted count is " + deletedCount);
                t.data(65, "ListenerManager.refresh", 300, "Updated count is " + updatedCount);
            }
            if (deletedCount > 0) {
                deleted = new ResponseTableEntry[deletedCount];
                Iterator<ResponseTableEntry> it = this.responseTable.values().iterator();
                int i3 = 0;
                while (it.hasNext()) {
                    entry = it.next();
                    try {
                        if (!entry.isDeleted(timestamp, query, filterAtServer)) continue;
                        deleted[i3++] = entry;
                        if (entry.getTimestamp() == timestamp) continue;
                        it.remove();
                    }
                    catch (PCFException e) {
                        System.err.println("Exception during delete event processing: " + (Object)((Object)e));
                    }
                }
            } else {
                deleted = new ResponseTableEntry[]{};
            }
        }
        ListenerAdapter[] adapters = this.getListenerAdapters();
        if (Trace.isTracing) {
            t.data(65, "ListenerManager.refresh", 300, "Number of listeners is " + adapters.length);
        }
        timestamp = System.currentTimeMillis();
        i = 0;
        while (i < adapters.length) {
            ListenerAdapter adapter = adapters[i];
            if (this.listenerList.contains(adapter)) {
                adapters[i].fireEvents(responses, previous, deleted, keys, indexes, timestamp, filterAtServer && adapter.getQuery() == query, this.agent.getSendSummaryEvents());
            }
            ++i;
        }
        i = 0;
        while (i < deleted.length) {
            if (deleted[i] != null) {
                deleted[i].clearDeleted();
            }
            ++i;
        }
    }

    synchronized ListenerAdapter[] getListenerAdapters() {
        if (this.adaptersArray == null) {
            this.adaptersArray = this.listenerList.toArray(new ListenerAdapter[this.listenerList.size()]);
        }
        return this.adaptersArray;
    }

    synchronized PCFMessage[] getRequests(boolean serverCanFilter) {
        if (this.requests == null || serverCanFilter != this.filterAtServer) {
            this.requests = this.getRequestArray(serverCanFilter);
            this.filterAtServer = serverCanFilter;
        }
        return this.requests;
    }

    private PCFMessage[] getRequestArray(boolean includeFilter) {
        PCFQuery[] queries = this.getOptimizedQueries(includeFilter);
        PCFMessage[] requests = new PCFMessage[queries.length];
        int i = 0;
        while (i < requests.length) {
            requests[i] = queries[i].createPCFRequest(includeFilter);
            ++i;
        }
        return requests;
    }

    private PCFQuery[] getOptimizedQueries(boolean includeFilter) {
        final ListenerAdapter[] adapters = this.getListenerAdapters();
        List list = this.template.optimize(new AbstractList(){

            @Override
            public int size() {
                return adapters.length;
            }

            @Override
            public Object get(int index) {
                return adapters[index].getQuery();
            }
        }, includeFilter);
        return list.toArray(new PCFQuery[list.size()]);
    }

    boolean contains(Object listener) {
        ListenerAdapter[] adapters = this.getListenerAdapters();
        boolean match = false;
        int i = 0;
        while (i < adapters.length && !match) {
            match = adapters[i].listenerObject == listener;
            ++i;
        }
        return match;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

