/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.Selector;

final class IntegerSelector
extends Selector {
    final Integer wildcardValue;

    public IntegerSelector(int id) {
        this(id, null);
    }

    public IntegerSelector(int id, int defaultValue) {
        this(id, (Integer)defaultValue);
    }

    public IntegerSelector(int id, Integer defaultValue) {
        super(id);
        this.wildcardValue = defaultValue;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public boolean matches(PCFMessage response, Object value) throws PCFException {
        Object actual = response.getParameterValue(this.id);
        if (value == null) {
            return this.wildcardValue == null || this.isSubset(actual, this.wildcardValue);
        }
        return actual == null || this.isSubset(actual, value);
    }

    @Override
    public boolean isSubset(Object a, Object b) {
        if (a == null) {
            a = this.wildcardValue;
        }
        if (b == null) {
            b = this.wildcardValue;
        }
        return b == null || b.equals(a) || b.equals(this.wildcardValue);
    }

    @Override
    public Object generalize(Object a, Object b) {
        if (a != null && a.equals(b)) {
            return a;
        }
        return this.wildcardValue;
    }

    public int generalize(int a, int b) {
        if (a == b) {
            return a;
        }
        return this.wildcardValue == null ? -1 : this.wildcardValue;
    }

    @Override
    public void write(PCFMessage request, Object value) {
        if (value != null) {
            request.addParameter((PCFParameter)new MQCFIN(this.id, ((Integer)value).intValue()));
        } else if (this.wildcardValue != null) {
            request.addParameter((PCFParameter)new MQCFIN(this.id, this.wildcardValue.intValue()));
        }
    }

    @Override
    public Object getWildcardValue() {
        return this.wildcardValue;
    }
}

