/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.Selector;
import java.util.Arrays;

public final class BytesSelector
extends Selector {
    final byte[] wildcardValue;

    public BytesSelector(int id) {
        this(id, null);
    }

    public BytesSelector(int id, byte[] defaultValue) {
        super(id);
        this.wildcardValue = defaultValue;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public boolean matches(PCFMessage response, Object value) throws PCFException {
        return value == null || this.wildcardValue == null || this.compareBytes(this.wildcardValue, value) || value.equals(response.getParameterValue(this.id));
    }

    @Override
    public boolean isSubset(Object a, Object b) {
        return b == null || Arrays.equals((byte[])b, PCFQuery.ALL_BINARY_NAMES) || this.generalize(a, b).equals(b);
    }

    @Override
    public Object generalize(Object a, Object b) {
        return this.generalize((byte[])a, (byte[])b);
    }

    public byte[] generalize(byte[] a, byte[] b) {
        if (a == null || a.length == 0) {
            return PCFQuery.ALL_BINARY_NAMES;
        }
        if (b == null || b.length == 0) {
            return PCFQuery.ALL_BINARY_NAMES;
        }
        if (Arrays.equals(a, b)) {
            return a;
        }
        return PCFQuery.ALL_BINARY_NAMES;
    }

    @Override
    public void write(PCFMessage request, Object value) {
        if (value != null) {
            request.addParameter((PCFParameter)new MQCFBS(this.id, (byte[])value));
        } else if (this.wildcardValue != null) {
            request.addParameter((PCFParameter)new MQCFBS(this.id, this.wildcardValue));
        }
    }

    @Override
    public Object getWildcardValue() {
        return this.wildcardValue;
    }

    private boolean compareBytes(byte[] a, Object o) {
        try {
            byte[] b = (byte[])o;
            return Arrays.equals(a, b);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

