/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf.event;

import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.Selector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class AttrsSelector
extends Selector {
    final int[] wildcardValue;

    public AttrsSelector(int id) {
        this(id, 1009);
    }

    public AttrsSelector(int id, int defaultValue) {
        super(id);
        this.wildcardValue = new int[]{defaultValue};
    }

    @Override
    public int getRole() {
        return 2;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void write(PCFMessage request, Object value) {
        if (value != null) {
            request.addParameter((PCFParameter)new MQCFIL(this.id, (int[])value));
        } else if (this.wildcardValue != null) {
            request.addParameter((PCFParameter)new MQCFIL(this.id, this.wildcardValue));
        }
    }

    @Override
    public boolean matches(PCFMessage response, Object value) throws PCFException {
        return false;
    }

    @Override
    public Object getWildcardValue() {
        return this.wildcardValue;
    }

    @Override
    public boolean isSubset(Object a, Object b) {
        return this.isSubset((int[])a, (int[])b);
    }

    public boolean isSubset(int[] a, int[] b) {
        return b == null || Arrays.equals(b, PCFQuery.ALL_ATTRS) || AttrsSelector.generalize(a, b).length == b.length;
    }

    @Override
    public Object generalize(Object a, Object b) {
        return AttrsSelector.generalize((int[])a, (int[])b);
    }

    public static int[] generalize(int[] a, int[] b) {
        Integer o;
        if (a == null || b == null) {
            return PCFQuery.ALL_ATTRS;
        }
        if (Arrays.equals(a, b)) {
            return a;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < a.length) {
            o = a[i];
            map.put(o, o);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            o = b[i];
            map.put(o, o);
            ++i;
        }
        List<Object> list = Arrays.asList(map.values().toArray());
        Collections.sort(list);
        Iterator<Object> it = list.iterator();
        int[] merged = new int[list.size()];
        int i2 = 0;
        while (i2 < merged.length) {
            merged[i2] = (Integer)it.next();
            ++i2;
        }
        return merged;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getClass().getName()) + " [" + this.id + "=");
        if (this.wildcardValue == null) {
            sb.append("null");
        } else {
            sb.append("{" + this.wildcardValue[0] + "}");
        }
        sb.append(", type=" + this.getRole() + "]");
        return new String(sb);
    }
}

