/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.destinations;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsDamagedDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueue;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopic;
import com.ibm.mq.explorer.jmsadmin.ui.Icons;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.EncodingCustomItem;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.UiJmsObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UiJmsDestination
extends UiJmsObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/destinations/UiJmsDestination.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";

    public UiJmsDestination(Trace t, DmJmsAbstractDestination jmsDestinationData) {
        super(t, jmsDestinationData);
    }

    @Override
    public boolean isAllowProperties() {
        boolean properties = true;
        DmJmsAbstractDestination dmJmsDestination = (DmJmsAbstractDestination)this.getDmObject();
        if (dmJmsDestination instanceof DmJmsDamagedDestination) {
            properties = false;
        }
        return properties;
    }

    @Override
    public boolean isAllowApplyProperties() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "com.ibm.mq.explorer.jmsadmin.JMSDestination";
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.jmsadmin.JMSDestination";
    }

    public void appendToContextMenu(final Shell sh, IMenuManager manager, Object contextObject) {
        super.appendToContextMenu(sh, manager, contextObject);
        String treeNodeId = (String)contextObject;
        final DmJmsAbstractDestination dmDestination = (DmJmsAbstractDestination)this.getDmObject();
        if (treeNodeId.startsWith("com.ibm.mq.explorer.jmsadmin.treenode.Destinations")) {
            Action delete = new Action(){

                public void run() {
                    JmsAdminMenuActions.deleteJmsObject(sh, dmDestination);
                }
            };
            delete.setText(JmsAdminPlugin.getMessage("JmsAdmin.Objects.Delete.Label"));
            UiPlugin.getHelpSystem().setHelp((IAction)delete, "com.ibm.mq.explorer.jmsadmin.infopop.UI_DeleteDestinationMenuItem");
            Action rename = new Action(){

                public void run() {
                    JmsAdminMenuActions.renameJmsObject(sh, dmDestination);
                }
            };
            rename.setText(JmsAdminPlugin.getMessage("JmsAdmin.Objects.Rename.Label"));
            manager.insertBefore("additions", (IContributionItem)new GroupMarker("com.ibm.mq.explorer.jmsadmin.menugroup"));
            manager.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)delete);
            if (!(dmDestination instanceof DmJmsDamagedDestination)) {
                manager.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)rename);
            }
        }
    }

    @Override
    public void updateIcon() {
        Trace t = Trace.getDefault();
        Image icon = null;
        DmJmsAbstractDestination dmJmsDestination = (DmJmsAbstractDestination)this.getDmObject();
        if (dmJmsDestination instanceof DmJmsDamagedDestination) {
            icon = Icons.get(t, "jndiObjectCorrupt.gif");
        } else if (dmJmsDestination instanceof DmJmsQueue) {
            icon = Icons.get(t, "destinationQueue.gif");
        } else if (dmJmsDestination instanceof DmJmsTopic) {
            icon = Icons.get(t, "destinationTopic.gif");
        }
        if (icon != null) {
            super.setImage(icon);
        }
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        UiJmsDestination targetUiObject = null;
        DmJmsAbstractDestination targetDmObject = null;
        MQExtObject targetExtObject = null;
        if (target instanceof MQExtObject) {
            targetExtObject = (MQExtObject)target;
            targetUiObject = (UiJmsDestination)Utilities.getUiObject(targetExtObject);
        } else if (target instanceof UiJmsDestination) {
            targetUiObject = (UiJmsDestination)((Object)target);
        }
        if (targetUiObject != null) {
            targetDmObject = (DmJmsAbstractDestination)Utilities.getDmObject(targetUiObject);
        }
        if (targetDmObject != null) {
            if (name.equals("DestinationType")) {
                if (value.equals("Queue")) {
                    if (targetDmObject instanceof DmJmsQueue) {
                        result = true;
                    }
                } else if (value.equals("Topic") && targetDmObject instanceof DmJmsTopic) {
                    result = true;
                }
            } else {
                result = UiJmsContext.testContextJNDIProviderAttribute(targetDmObject.getParent(), value) ? true : super.testAttribute(target, name, value);
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    @Override
    protected int getQueueManagerAttrId(int attrId) {
        int id = 0;
        switch (attrId) {
            case 13001: 
            case 13004: 
            case 13005: {
                id = 13006;
                break;
            }
            case 13012: 
            case 13044: 
            case 13064: {
                id = 13043;
            }
        }
        return id;
    }

    @Override
    public boolean isCustomItem(Trace t, Attr attr) {
        boolean isCustomItem = false;
        int id = attr.getAttributeID();
        switch (id) {
            case 13023: {
                isCustomItem = true;
            }
        }
        return isCustomItem;
    }

    @Override
    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite page, int style, Attr attr, boolean readonlyMode) {
        EncodingCustomItem result = null;
        int id = attr.getAttributeID();
        switch (id) {
            case 13023: {
                result = new EncodingCustomItem(t, page, style, this, attr, readonlyMode);
            }
        }
        return result;
    }
}

