/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.destinations;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueue;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopic;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.NewJmsObjectProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.JmsDestinationMappingArea;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.NewDestinationWizPage1;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.UiJmsDestination;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsDestinationFactory;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.PropertyMapperFactory;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQTopic;
import java.util.Collection;
import org.eclipse.swt.widgets.Composite;

public class NewDestinationObjectProvider
extends NewJmsObjectProvider {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/destinations/NewDestinationObjectProvider.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String[] PAGE_IDS = new String[]{"com.ibm.mq.explorer.jmsadmin.ui.destinations.newdestinationwizard.page1", "PAGE_STD_SELECT_LIKE_OBJECT", "PAGE_STD_CHANGE_PROPERTIES"};
    private static final int TYPE_QUEUE = 0;
    private static final int TYPE_TOPIC = 1;
    private int currentType;
    private boolean typeIsFixed;
    private UiJmsDestination uiJmsDestination;
    private JmsDestinationMappingArea mappingArea;

    public NewDestinationObjectProvider(Trace t, UiJmsContext parent) {
        super(t, parent);
        this.resetWizard(t);
    }

    @Override
    protected void resetWizard(Trace t) {
        this.setCurrentMessagingProvider(t, Integer.MAX_VALUE);
        if (!this.typeIsFixed) {
            this.currentType = 0;
            this.typeIsFixed = false;
        }
    }

    @Override
    public String getGenericObjectName(Trace t) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.Object.Type");
    }

    @Override
    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.New.Label");
    }

    @Override
    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        return "com.ibm.mq.explorer.jmsadmin.infopop.UI_NewDestinationMenuItem";
    }

    @Override
    public String getObjectId() {
        return "com.ibm.mq.explorer.jmsadmin.JMSDestination";
    }

    @Override
    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return new UiJmsDestinationFactory();
    }

    @Override
    public String[] getPageIds(Trace t, String typeId) {
        String[] pageIds = PAGE_IDS;
        pageIds = this.getPropertyMappingPageIds(t, typeId, pageIds);
        return pageIds;
    }

    @Override
    public WizPage getWizardPage(Trace t, String pageId, NewObjectWiz wizard) {
        IPropertyMapper propertyMapper;
        WizPage wizPage = null;
        boolean mapping = this.isMappingProperties();
        if (mapping && (propertyMapper = this.getPropertyMapper(t)) != null) {
            wizPage = propertyMapper.getWizardPage(t, pageId, wizard, (NewObjectProvider)this, this.propertyMappingObject);
        }
        if (wizPage == null) {
            wizPage = pageId.equals("com.ibm.mq.explorer.jmsadmin.ui.destinations.newdestinationwizard.page1") ? new NewDestinationWizPage1(pageId, wizard, this) : super.getWizardPage(t, pageId, wizard);
        }
        return wizPage;
    }

    @Override
    public UiMQObject[] getCandidateLikeObjects(Trace t, String typeId) {
        DmJmsAbstractDestination dmJmsDestination = (DmJmsAbstractDestination)this.uiJmsDestination.getDmObject();
        UiJmsContext parent = (UiJmsContext)this.getParent();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)Utilities.getExtObject(parent);
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(parent);
        Object[] dmDestinations = dmJmsContext.getLikeObjects(t, dmJmsDestination).toArray();
        UiMQObject[] uiDestinations = new UiMQObject[dmDestinations.length];
        int i = 0;
        while (i < dmDestinations.length) {
            DmJmsAbstractDestination currentDmJmsDestination = (DmJmsAbstractDestination)dmDestinations[i];
            uiDestinations[i] = UiJmsDestinationFactory.create(t, currentDmJmsDestination, jmsContextExtObject);
            ++i;
        }
        return uiDestinations;
    }

    @Override
    public UiMQObject createInterimObject(Trace t, String typeId, String name) {
        UiJmsContext parent = (UiJmsContext)this.getParent();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)Utilities.getExtObject(parent);
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(parent);
        MQQueue mqDestination = null;
        switch (this.currentType) {
            case 0: {
                mqDestination = new MQQueue();
                break;
            }
            case 1: {
                mqDestination = new MQTopic();
            }
        }
        DmJmsAbstractDestination dmJmsDestination = null;
        switch (this.currentType) {
            case 0: {
                dmJmsDestination = new DmJmsQueue(t, name, mqDestination, dmJmsContext);
                break;
            }
            case 1: {
                dmJmsDestination = new DmJmsTopic(t, name, (MQTopic)mqDestination, dmJmsContext);
            }
        }
        this.uiJmsDestination = UiJmsDestinationFactory.create(t, dmJmsDestination, jmsContextExtObject);
        return this.uiJmsDestination;
    }

    int getCurrentType() {
        return this.currentType;
    }

    void setCurrentType(Trace t, int type) {
        this.currentType = type;
        if (this.mappingArea != null) {
            Class typeClass = null;
            switch (type) {
                case 0: {
                    typeClass = DmJmsQueue.class;
                    break;
                }
                case 1: {
                    typeClass = DmJmsTopic.class;
                }
            }
            this.mappingArea.setCurrentType(t, typeClass);
        }
    }

    @Override
    public void setCurrentMessagingProvider(Trace t, int messagingProvider) {
        super.setCurrentMessagingProvider(t, messagingProvider);
        switch (messagingProvider) {
            case 0: {
                break;
            }
            case 1: {
                if (this.currentType != 0) break;
                this.currentType = 1;
            }
        }
    }

    @Override
    public boolean isObjectComplete(Trace t) {
        boolean complete = false;
        if (this.uiJmsDestination != null) {
            IDmObject dmObject = this.uiJmsDestination.getDmObject();
            this.setFixedAttributes(t, dmObject, null);
            if (this.uiJmsDestination.isMandatoryAttributesPresent(t)) {
                complete = true;
            }
        }
        return complete;
    }

    @Override
    public int[] getMessagingProviders() {
        return new int[]{Integer.MAX_VALUE};
    }

    public int[] getTypes(Trace t, int messagingProvider) {
        int[] types = null;
        if (messagingProvider == Integer.MAX_VALUE) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            types = nArray;
        } else {
            String errorMessage = "Invalid message provider '" + messagingProvider + "'";
            t.FFST(66, "NewDestinationObjectProvider.getTypes", 0, 0, errorMessage);
        }
        return types;
    }

    public String getTypeText(Trace t, int type) {
        String textId = null;
        switch (type) {
            case 0: {
                textId = "JmsAdmin.NewDestinationWizard.Page2.QueueDestinationType";
                break;
            }
            case 1: {
                textId = "JmsAdmin.NewDestinationWizard.Page2.TopicDestinationType";
                break;
            }
            default: {
                String errorMessage = "Invalid object type '" + type + "'";
                t.FFST(66, "NewDestinationObjectProvider.getTypeText", 1, 0, errorMessage);
            }
        }
        String text = JmsAdminPlugin.getMessage(textId);
        return text;
    }

    public int getType(Trace t, String typeText) {
        int type = -1;
        if (typeText.equals(this.getTypeText(t, 0))) {
            type = 0;
        } else if (typeText.equals(this.getTypeText(t, 1))) {
            type = 1;
        } else {
            String errorMessage = "Invalid object type '" + type + "'";
            t.FFST(66, "NewDestinationObjectProvider.getType", 2, 0, errorMessage);
        }
        return type;
    }

    public String getTypeHelpText(Trace t, int type) {
        String textId = null;
        switch (type) {
            case 0: {
                textId = "JmsAdmin.NewDestinationWizard.Page2.QueueDestinationTypeHelpText";
                break;
            }
            case 1: {
                textId = "JmsAdmin.NewDestinationWizard.Page2.TopicDestinationTypeHelpText";
                break;
            }
            default: {
                String errorMessage = "Invalid object type '" + type + "'";
                t.FFST(66, "NewDestinationObjectProvider.getTypeHelpText", 3, 0, errorMessage);
            }
        }
        String text = JmsAdminPlugin.getMessage(textId);
        return text;
    }

    public String getWizardTitle(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.NewWizard.Title");
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.NewWizard.Page1Title");
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.NewWizard.Page2Desc");
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.Destination.NewWizard.Creating");
    }

    public String getUseLikeObjectPromptText(Trace t) {
        return JmsAdminPlugin.getMessage("JmsAdmin.NewDestinationWizard.LikeObjectPage.PromptText");
    }

    public void setObjectToMapPropertiesFrom(Trace t, IDmObject object) throws UnableToUseMappingObjectException {
        super.setObjectToMapPropertiesFrom(t, object);
        IPropertyMapper propertyMapper = this.getPropertyMapper(t);
        if (propertyMapper != null) {
            Class classToCreate = propertyMapper.getSupportedToClass();
            if (classToCreate == DmJmsQueue.class) {
                this.currentType = 0;
                this.typeIsFixed = true;
            } else if (classToCreate == DmJmsTopic.class) {
                this.currentType = 1;
                this.typeIsFixed = true;
            }
        }
    }

    protected Class getNewObjectClass(Trace t) {
        Class newObjectClass = null;
        if (this.currentType == 0) {
            newObjectClass = DmJmsQueue.class;
        } else if (this.currentType == 1) {
            newObjectClass = DmJmsTopic.class;
        }
        return newObjectClass;
    }

    public boolean isTypeFixed() {
        return this.typeIsFixed;
    }

    protected IPropertyMapper getPropertyMapper(Trace t) {
        IPropertyMapper propertyMapper = null;
        if (this.propertyMappingObject != null) {
            Class<?> fromClass = this.propertyMappingObject.getClass();
            Class toClass = DmJmsQueue.class;
            PropertyMapperFactory factory = PropertyMapperFactory.getFactory();
            propertyMapper = factory.getPropertyMapper(t, fromClass, toClass);
            if (propertyMapper == null) {
                toClass = DmJmsTopic.class;
                propertyMapper = factory.getPropertyMapper(t, fromClass, toClass);
            }
            if (propertyMapper == null) {
                t.FFST(66, 66, 0, 0, "Failed to load the expected property mapper, from: " + fromClass.toString() + ", to: " + toClass.toString());
            }
        }
        return propertyMapper;
    }

    private Collection getPossiblePropertyMappers(Trace t, int newDestinationType) {
        int previousDestinationType = this.currentType;
        this.currentType = newDestinationType;
        Collection propertyMappers = this.getPossiblePropertyMappers(t);
        this.currentType = previousDestinationType;
        return propertyMappers;
    }

    protected Composite addMappingArea(Trace t, NewObjectWiz wizard, Composite parentComposite) {
        if (!this.isMappingProperties()) {
            boolean topicMappersExist;
            Collection queueMappers = this.getPossiblePropertyMappers(t, 0);
            Collection topicMappers = this.getPossiblePropertyMappers(t, 1);
            boolean queueMappersExist = queueMappers != null && queueMappers.size() > 0;
            boolean bl = topicMappersExist = topicMappers != null && topicMappers.size() > 0;
            if (queueMappersExist || topicMappersExist) {
                this.mappingArea = new JmsDestinationMappingArea(t, parentComposite, wizard);
                this.mappingArea.addPropertyMappers(t, queueMappers);
                this.mappingArea.addPropertyMappers(t, topicMappers);
            }
        }
        return this.mappingArea;
    }
}

