/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.defaults;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.IJmsParameter;
import com.ibm.mq.explorer.jmsadmin.ui.Icons;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.qmgradmin.internal.queuemanager.UiQueueManagerHandle;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.QueueManagerList;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.dialogs.GetObjectNameDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class UiJmsObject
extends UiMQObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/defaults/UiJmsObject.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private Hashtable<Integer, Object> selectedQueueManagers;

    public UiJmsObject(Trace t, DmJmsObject dmJmsObject) {
        super(t, (IDmObject)dmJmsObject);
        this.updateIcon();
        this.selectedQueueManagers = new Hashtable();
    }

    public int getDataModelObjectType(Trace t) {
        return super.getDmObject().getObjectType(t);
    }

    public boolean isSupportDelete() {
        return false;
    }

    public boolean isAllowProperties() {
        return false;
    }

    public abstract String getObjectType();

    public String getNLSResourceFileKey() {
        return null;
    }

    public boolean isChangeProperties(Trace t) {
        return true;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return true;
    }

    public boolean isAllowApplyProperties() {
        return false;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public abstract String getId();

    public String toString() {
        Trace t = Trace.getDefault();
        String value = null;
        IDmObject dmJmsObject = this.getDmObject();
        value = dmJmsObject != null ? dmJmsObject.toString(t) : new String();
        return value;
    }

    public abstract void updateIcon();

    public String getHelpId(UiDisplayGroup uiDisplayGroup) {
        String helpId = "com.ibm.mq.explorer.jmsadmin.infopop." + uiDisplayGroup.getDisplayGroup().getHelpId();
        return helpId;
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        UiMQObject selObject = null;
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(sh);
        selDlg.setPreselectObjectName(currentSelection);
        ViewerFilter viewerFilter = null;
        String retValue = null;
        boolean result = false;
        if (this.isQueueManagerAttr(attrId)) {
            DmQueueManagerHandle dmHandle;
            UiQueueManagerHandle handle;
            String description;
            String title = this.getSelectDialogTitle(t, attrId);
            result = selDlg.openToSelectQueueManagerHandle(t, title, description = this.getSelectQueueManagerDialogDescription(t, attrId), viewerFilter, helpId);
            if (result && (handle = (UiQueueManagerHandle)selDlg.getSelectedObject()) != null && (dmHandle = (DmQueueManagerHandle)handle.getDmObject()) != null) {
                DmQueueManager queuemanager = dmHandle.getQueueManager();
                selObject = UiPlugin.getQueueManagerList().getKnownUiQueueManager(t, queuemanager);
            }
        } else {
            Object value = this.getQueueManagerObjectRelatedToAttr(t, attrId);
            if (value == null || value instanceof String && value.equals("")) {
                if (attrId == 13044) {
                    GetObjectNameDialog nameDialog = new GetObjectNameDialog(sh, 0);
                    nameDialog.setTitle(this.getSelectDialogTitle(t, attrId));
                    String currentValue = "";
                    if (currentSelection != null) {
                        currentValue = currentSelection;
                    }
                    nameDialog.setObjectName(currentValue);
                    nameDialog.setHelpId("com.ibm.mq.explorer.jmsadmin.infopop.UI_JmsSelectQueueDialog");
                    String[] infoStrings = new String[]{JmsAdminPlugin.getMessage("JmsAdmin.Select.Queue.Dialog.Text1"), JmsAdminPlugin.getMessage("JmsAdmin.Select.Queue.Dialog.Text2")};
                    nameDialog.setInformationStrings(infoStrings);
                    nameDialog.setObjectPrompt(this.getDmObject().getAttribute(t, attrId, 0).getAttrType().getPropTitle());
                    nameDialog.setRestrictToMQCharset(true);
                    nameDialog.setImage(Icons.get(t, "destinationQueue.gif"));
                    nameDialog.create(t);
                    result = nameDialog.open(t);
                    if (result) {
                        retValue = nameDialog.getObjectName();
                    }
                } else {
                    String msgID = "AMQ4573";
                    int qmgrId = this.getQueueManagerAttrId(attrId);
                    DmJmsObject dmobj = (DmJmsObject)this.getDmObject();
                    AttrType qmAttrType = dmobj.getAttribute(t, qmgrId, 0).getAttrType();
                    AttrType queueAttrType = dmobj.getAttribute(t, attrId, 0).getAttrType();
                    String insert0 = qmAttrType.getPropTitle();
                    String insert1 = qmAttrType.getDisplayGroup().getTitle();
                    String insert2 = queueAttrType.getPropTitle();
                    MessageBox.showSystemMessageById((Trace)t, (Shell)sh, (String)msgID, (String[])new String[]{insert0, insert1, insert2}, (String)msgID);
                }
            } else {
                UiQueueManager uiQueueManager = this.getSelectedQueueManager(t, value);
                if (uiQueueManager == null) {
                    String msgID = "AMQ4425";
                    int qmgrId = this.getQueueManagerAttrId(attrId);
                    DmJmsObject dmobj = (DmJmsObject)this.getDmObject();
                    AttrType qmAttrType = dmobj.getAttribute(t, qmgrId, 0).getAttrType();
                    String insert0 = qmAttrType.getPropTitle();
                    String insert1 = qmAttrType.getDisplayGroup().getTitle();
                    MessageBox.showSystemMessageById((Trace)t, (Shell)sh, (String)msgID, (String[])new String[]{insert0, insert1}, (String)msgID);
                } else {
                    selObject = this.getQueueFromQueueManager(t, uiQueueManager, attrId, dmObjectFilter, selDlg, helpId);
                }
            }
        }
        if (selObject != null) {
            retValue = selObject.toString();
            this.setObjectAttributeControlValue(t, attrId, selObject);
        }
        return retValue;
    }

    private UiMQObject getQueueFromQueueManager(Trace t, UiQueueManager uiQueueManager, int attrId, DmObjectFilter dmObjectFilter, SelectUiMQObjectDialog selDlg, String helpId) {
        UiMQObject queue = null;
        DmQueueManager dmQm = uiQueueManager.getDmQueueManagerObject();
        boolean isSecondaryOrder = dmQm.isZos();
        int objectType = dmObjectFilter.getType();
        String id = null;
        switch (objectType) {
            case 13: {
                id = "com.ibm.mq.explorer.queue";
                break;
            }
            case 25: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 1005: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 83: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 7: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 36: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 97: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 153: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 122: {
                id = "com.ibm.mq.explorer.channel";
                break;
            }
            case 115: {
                id = "com.ibm.mq.explorer.channel";
            }
        }
        CompareWithProvider compWithProvider = null;
        if (id == null) {
            t.FFST(66, "UiJmsObject.getQueueFromQueueManager", 10, 50999, 0, 0, "Unsupported object type", "", "");
        } else {
            compWithProvider = (CompareWithProvider)ObjectRegistrationManager.getExplorerProvider((Trace)t, (String)id, (String)"com.ibm.mq.explorer.provider.compare.with", (UiMQObject)uiQueueManager);
        }
        if (compWithProvider != null) {
            IUiMQObjectFactory uiMQObjectFactory = compWithProvider.getUiMQObjectFactory(t);
            String objectId = compWithProvider.getObjectId();
            String genericObjectName = compWithProvider.getGenericObjectName(t);
            String attributeOrderId = compWithProvider.getAttributeOrderId();
            String title = this.getSelectDialogTitle(t, attrId);
            String description = this.getSelectObjectDialogDescription(t, attrId, uiQueueManager);
            if (isSecondaryOrder) {
                dmObjectFilter.setDisp(t, 0);
            } else {
                dmObjectFilter.resetDisp();
            }
            selDlg.setExplicitFilter(t, dmObjectFilter);
            selDlg.listenToDataModel(t, (IDmObservable)dmQm, objectType, uiMQObjectFactory, (UiMQObject)uiQueueManager);
            boolean result = selDlg.open(t, title, description, objectId, genericObjectName, attributeOrderId, isSecondaryOrder, null, null, null, null, true, true, helpId);
            if (result) {
                queue = selDlg.getSelectedObject();
            }
        }
        return queue;
    }

    private String getSelectDialogTitle(Trace t, int attrId) {
        DmJmsObject dmobj = (DmJmsObject)this.getDmObject();
        IJmsParameter parameter = dmobj.getParameter(attrId);
        String msgId = parameter.getSelectTitleId();
        String message = JmsAdminPlugin.getMessage(msgId);
        String insert = dmobj.getAttribute(t, attrId, 0).getAttrType().getPropTitle();
        return Message.format((String)message, (String)insert);
    }

    private String getSelectQueueManagerDialogDescription(Trace t, int attrId) {
        DmJmsObject dmobj = (DmJmsObject)this.getDmObject();
        IJmsParameter parameter = dmobj.getParameter(attrId);
        String msgId = parameter.getSelectDescriptionId();
        String message = JmsAdminPlugin.getMessage(msgId);
        String insert = this.getFieldName(t, dmobj, attrId);
        return Message.format((String)message, (String)insert);
    }

    private String getSelectObjectDialogDescription(Trace t, int attrId, UiQueueManager uiQueueManager) {
        int qmgrId = this.getQueueManagerAttrId(attrId);
        DmJmsObject dmobj = (DmJmsObject)this.getDmObject();
        AttrType attrType = dmobj.getAttribute(t, qmgrId, 0).getAttrType();
        IJmsParameter parameter = dmobj.getParameter(attrId);
        String msgId = parameter.getSelectDescriptionId();
        String message = JmsAdminPlugin.getMessage(msgId);
        String insert0 = uiQueueManager.toString();
        String insert1 = this.getFieldName(t, dmobj, qmgrId);
        String insert2 = attrType.getDisplayGroup().getTitle();
        String[] inserts = new String[]{insert0, insert1, insert2};
        return Message.format((String)message, (String[])inserts);
    }

    private String getFieldName(Trace t, DmJmsObject dmobj, int id) {
        return dmobj.getParameter(id).getFieldName(t);
    }

    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        boolean result = false;
        switch (attrId) {
            case 13001: 
            case 13002: 
            case 13003: 
            case 13004: 
            case 13005: 
            case 13006: 
            case 13007: 
            case 13008: 
            case 13012: 
            case 13043: 
            case 13044: 
            case 13064: {
                result = true;
            }
        }
        return result;
    }

    private boolean isQueueManagerAttr(int attrId) {
        boolean result = false;
        switch (attrId) {
            case 13006: 
            case 13007: 
            case 13043: {
                result = true;
            }
        }
        return result;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        int attrId = attr.getAttributeID();
        switch (attrId) {
            case 13006: 
            case 13007: 
            case 13043: {
                String newQueueManager;
                UiQueueManager uiQueueManager;
                String selectedQueueManager;
                Object value = this.selectedQueueManagers.get(attrId);
                if (value == null || !(value instanceof UiQueueManager) || (selectedQueueManager = (uiQueueManager = (UiQueueManager)value).toString()).equals(newQueueManager = (String)newValue)) break;
                this.selectedQueueManagers.put(attrId, newValue);
            }
        }
        return false;
    }

    public void showProperties(Trace t) {
        this.selectedQueueManagers = new Hashtable();
        super.showProperties(t);
    }

    public void showProperties(Trace t, Shell s) {
        this.selectedQueueManagers = new Hashtable();
        super.showProperties(t, s);
    }

    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiJmsObject targetUiObject = null;
        DmJmsObject targetDmObject = null;
        MQExtObject targetExtObject = null;
        if (target instanceof MQExtObject) {
            targetExtObject = (MQExtObject)target;
            targetUiObject = Utilities.getUiObject(targetExtObject);
        } else if (target instanceof UiJmsObject) {
            targetUiObject = (UiJmsObject)((Object)target);
        }
        if (targetUiObject != null) {
            targetDmObject = Utilities.getDmObject(targetUiObject);
        }
        if (targetDmObject != null) {
            if (name.equals("JmsObjectClass")) {
                String className = targetDmObject.getAttributeValue(t, 13108, 0);
                if (value.equals(className)) {
                    result = true;
                }
            } else if (name.equals("JmsObjectMessagingProvider")) {
                int messagingProvider = targetDmObject.getMessagingProvider(t);
                if (value.equals("JmsObjectMessagingProviderMQ")) {
                    if (messagingProvider == 1) {
                        result = true;
                    }
                } else if (value.equals("JmsObjectMessagingProviderRealtime")) {
                    if (messagingProvider == 2) {
                        result = true;
                    }
                } else if (value.equals("JmsObjectMessagingProviderMQandRealtime") && messagingProvider == 3) {
                    result = true;
                }
            } else {
                result = targetDmObject.getParent() != null && UiJmsContext.testContextJNDIProviderAttribute(targetDmObject.getParent(), value) ? true : super.testAttribute(target, name, value);
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    public String getHelpIdForProperties() {
        return "com.ibm.mq.explorer.jmsadmin.infopop.UI_Properties";
    }

    private Object getQueueManagerObjectRelatedToAttr(Trace t, int attrId) {
        int id = this.getQueueManagerAttrId(attrId);
        Object value = this.getObjectAttributeControlValue(t, id);
        return value;
    }

    public UiQueueManager getSelectedQueueManager(Trace t, Object queueManagerObject) {
        UiQueueManager uiQueueManager = null;
        if (queueManagerObject != null) {
            if (queueManagerObject instanceof UiQueueManager) {
                uiQueueManager = (UiQueueManager)queueManagerObject;
            } else {
                String QueueManagerName = (String)queueManagerObject;
                ArrayList<UiQueueManager> result = new ArrayList<UiQueueManager>();
                QueueManagerList list = UiPlugin.getQueueManagerList();
                UiQueueManager[] array = list.getKnownUiQueueManagers(t, false);
                int i = 0;
                while (i < array.length) {
                    UiQueueManager qmgr = array[i];
                    String queueManagerName = qmgr.getDmQueueManagerObject().getTitle();
                    if (queueManagerName.equals(QueueManagerName)) {
                        result.add(qmgr);
                    }
                    ++i;
                }
                if (result.size() == 1) {
                    uiQueueManager = (UiQueueManager)result.get(0);
                }
            }
            if (uiQueueManager != null && !uiQueueManager.isConnected()) {
                uiQueueManager = null;
            }
        }
        return uiQueueManager;
    }

    public void setObjectAttributeControlValue(Trace t, int id, Object value) {
        boolean updateValue = true;
        if (this.isQueueManagerAttr(id)) {
            String oldName;
            Integer attrId = id;
            Object oldValue = this.selectedQueueManagers.get(attrId);
            if (value instanceof String && oldValue instanceof UiQueueManager && (oldName = ((UiQueueManager)oldValue).getDmQueueManagerObject().getTitle()).equals(value)) {
                updateValue = false;
            }
            if (updateValue) {
                this.selectedQueueManagers.put(attrId, value);
            }
        }
    }

    public Object getObjectAttributeControlValue(Trace t, int id) {
        return this.selectedQueueManagers.get(id);
    }

    protected int getQueueManagerAttrId(int attrId) {
        return 0;
    }
}

