/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.defaults;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.NewJmsObjectProvider;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewJmsObjectWizPage1
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/defaults/NewJmsObjectWizPage1.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected static final int HORIZONTAL_SPAN = 4;
    protected NewObjectWiz wizard;
    private NewJmsObjectProvider newObjectProvider;
    private boolean pageContentCreated;
    private Text nameText;
    private Combo messagingProviderCombo;
    private Text messagingProviderHelpText;
    private boolean interimObjectCreated = false;
    protected Control firstControl;
    private boolean firstOpen = true;

    public NewJmsObjectWizPage1(String pageName, NewObjectWiz wiz, NewJmsObjectProvider newObjProvider, String title, String description) {
        super(pageName);
        this.wizard = wiz;
        this.newObjectProvider = newObjProvider;
        this.interimObjectCreated = false;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Name.Label"));
        GridData layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.nameText = new Text(parent, 2048);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.nameText.setLayoutData((Object)layout);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = NewJmsObjectWizPage1.this.nameText.getText();
                NewJmsObjectWizPage1.this.wizard.setNewObjectName(name);
                NewJmsObjectWizPage1.this.checkIfEnableButtons();
            }
        });
        this.firstControl = this.nameText;
        UiUtils.createBlankLine((Composite)parent, (int)4);
        label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Page1.MessagingProviderLabel"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.messagingProviderCombo = new Combo(parent, 2060);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.messagingProviderCombo.setLayoutData((Object)layout);
        int[] messagingProviders = this.newObjectProvider.getMessagingProviders();
        int i = 0;
        while (i < messagingProviders.length) {
            String providerText = this.newObjectProvider.getMessagingProviderText(t, messagingProviders[i]);
            this.messagingProviderCombo.add(providerText, i);
            ++i;
        }
        if (messagingProviders.length <= 1) {
            this.messagingProviderCombo.setEnabled(false);
        }
        this.messagingProviderCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String messageProviderText = NewJmsObjectWizPage1.this.messagingProviderCombo.getText();
                if (!messageProviderText.equals(new String())) {
                    int provider = NewJmsObjectWizPage1.this.newObjectProvider.getMessagingProvider(t, messageProviderText);
                    NewJmsObjectWizPage1.this.newObjectProvider.setCurrentMessagingProvider(t, provider);
                    NewJmsObjectWizPage1.this.updateHelpText(t);
                }
            }
        });
        this.messagingProviderHelpText = new Text(parent, 2114);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.messagingProviderHelpText, (boolean)true);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        layout.widthHint = 200;
        this.messagingProviderHelpText.setLayoutData((Object)layout);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)NewJmsObjectWizPage1.this.messagingProviderHelpText);
            }
        });
        this.pageContentCreated = true;
    }

    private void updateHelpText(Trace t) {
        int provider = this.newObjectProvider.getCurrentMessagingProvider();
        String text = this.newObjectProvider.getMessagingProviderHelpText(t, provider);
        this.messagingProviderHelpText.setText(text);
        UiUtils.resizeControl((Trace)t, (Control)this.messagingProviderHelpText);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        UiMQObject newObject = this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
        boolean result = this.wizard.createObject(t, newObject.getDmObject(), null);
        return result;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        if (this.pageContentCreated) {
            boolean pageComplete = false;
            String name = this.nameText.getText();
            if (name.length() > 0) {
                if (name.contains("\\") || name.contains("/")) {
                    String errorMessage = JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Name.ContainsSlashesError");
                    this.setMessage(errorMessage, 3);
                } else {
                    pageComplete = true;
                    this.setMessage(null);
                }
                if (!this.interimObjectCreated) {
                    this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), name);
                    this.interimObjectCreated = true;
                }
            } else if (!this.firstOpen) {
                String errorMessage = JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Name.NotEnteredError");
                this.setMessage(errorMessage, 3);
            }
            this.setPageComplete(pageComplete);
            this.wizard.setEnableFinish(false);
            this.wizard.updateButtons(t);
            this.firstOpen = false;
        }
    }

    public void nextPressed() {
        Trace t = Trace.getDefault();
        this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            String currentName = this.wizard.getNewObjectName();
            if (currentName != null && currentName.length() > 0) {
                this.nameText.setText(currentName);
            }
            if (this.messagingProviderCombo.getSelectionIndex() < 0) {
                this.messagingProviderCombo.select(0);
                this.updateHelpText(t);
            }
            this.firstControl.setFocus();
        }
    }
}

