/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.defaults;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChildAddedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsEventHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsEventObserver;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenameEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenamingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractDestination;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsUnknown;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsSubContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.UiJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsConnectionFactoryFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsContextFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsDestinationFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsSubContextFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJndiObjectFactory;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableUpdate;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterChangedEvent;
import com.ibm.mq.explorer.ui.internal.filters.IFilterChangedListener;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class JmsContentPage
extends ContentPage
implements DmJmsEventObserver,
IFilterChangedListener {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/defaults/JmsContentPage.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    protected ExplorerTable explorerTable;
    protected Label explorerTableLabel;
    protected ContentTitleBar titleBar;
    private MQExtObject externalObject;

    public JmsContentPage(Trace t, Composite parent) {
        super(parent, 0);
    }

    public void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.titleBar = new ContentTitleBar((Composite)this, 0);
        GridData gridData = new GridData(768);
        this.titleBar.setLayoutData((Object)gridData);
    }

    protected void addExplorerTableLabel(Trace t) {
        this.explorerTableLabel = new Label((Composite)this, 0);
        this.setExplorerTableLabel(t, true);
        GridData layout = new GridData(768);
        this.explorerTableLabel.setLayoutData((Object)layout);
    }

    protected abstract void addExplorerTable(Trace var1);

    private void setExplorerTableLabel(Trace t, boolean connected) {
        if (this.explorerTableLabel != null) {
            String label = JmsAdminPlugin.getMessage("JmsAdmin.JmsContext.ContentPage.ContentsTable");
            if (!connected) {
                label = String.valueOf(label) + ' ' + JmsAdminPlugin.getMessage("JmsAdmin.JmsContext.ContentPage.Unavailable");
            }
            this.explorerTableLabel.setText(label);
        }
    }

    public abstract String getId();

    public void setObject(MQExtObject object) {
        Trace t = Trace.getDefault();
        if (this.externalObject != object) {
            this.externalObject = object;
            JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)this.getObject();
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(jmsContextExtObject);
            String instance = Utilities.getUniqueId(t, dmJmsContext);
            this.explorerTable.setInstance(t, instance, false);
            this.updateContextStatus(t, dmJmsContext.isOpen());
            this.updateTable(t, dmJmsContext);
            dmJmsContext.addObserver(this);
        }
    }

    public MQExtObject getObject() {
        return this.externalObject;
    }

    public void updatePage() {
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)this.getObject();
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(jmsContextExtObject);
        if (dmJmsContext.isOpen()) {
            UiMQObject selectedUiObject = this.explorerTable.getSelectedItem(t);
            if (selectedUiObject != null) {
                String selectedObjectName = selectedUiObject.toString();
                this.explorerTable.setPreselectObjectName(selectedObjectName);
            }
            JmsAdminMenuActions.asyncConnectToContext(t, dmJmsContext, this.getShell(), true, true, false);
        }
    }

    public void repaint() {
        this.explorerTable.repaint();
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    public void instanceDeleted(Object object) {
    }

    protected void beginUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 4), true, true);
    }

    private void endUpdate(Trace t) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 5), true, true);
    }

    private UiJmsObject createUiJmsObject(Trace t, DmJmsObject dmJmsObject, JmsContextExtObject jmsContextExtObject) {
        UiJmsObject uiJmsObject = null;
        if (dmJmsObject instanceof DmJmsUnknown) {
            uiJmsObject = UiJndiObjectFactory.create(t, dmJmsObject, jmsContextExtObject);
        } else if (dmJmsObject instanceof DmJmsInitialContext) {
            uiJmsObject = UiJmsContextFactory.create(t, (DmJmsInitialContext)dmJmsObject);
        } else if (dmJmsObject instanceof DmJmsContext) {
            uiJmsObject = UiJmsSubContextFactory.create(t, (DmJmsContext)dmJmsObject, jmsContextExtObject);
        } else if (dmJmsObject instanceof DmJmsAbstractConnectionFactory) {
            uiJmsObject = UiJmsConnectionFactoryFactory.create(t, (DmJmsAbstractConnectionFactory)dmJmsObject, jmsContextExtObject);
        } else if (dmJmsObject instanceof DmJmsAbstractDestination) {
            uiJmsObject = UiJmsDestinationFactory.create(t, (DmJmsAbstractDestination)dmJmsObject, jmsContextExtObject);
        } else {
            String helpID = "AMQ4411";
            String message = CommonServices.getSystemMessage((String)helpID);
            String className = dmJmsObject.getClass().toString();
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(jmsContextExtObject);
            message = Message.format((String)message, (String)className, (String)dmJmsContext.getTitle(), null);
            t.FFST(66, "JmsContentPage.createUiJmsObject", 0, 0, message);
        }
        return uiJmsObject;
    }

    protected void addItemToTable(Trace t, DmJmsObject dmJmsObject, boolean endUpdate) {
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)this.getObject();
        UiJmsObject uiJmsObject = this.createUiJmsObject(t, dmJmsObject, jmsContextExtObject);
        dmJmsObject.addObserver(this);
        DmJmsAbstractContext dmJmsContext = dmJmsObject.getParent();
        Filter filter = this.explorerTable.getCurrentFilterSelection(t);
        DmObjectFilter dmFilter = filter.getDmObjectFilter(t);
        dmFilter.setMessagingProvider(0);
        if (dmJmsContext == null || dmJmsContext.match(t, dmJmsObject, dmFilter)) {
            this.updateItemInTable(t, uiJmsObject, 1, endUpdate);
        }
    }

    private void updateItemInTable(Trace t, UiJmsObject uiJmsObject, int updateType, boolean endUpdate) {
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, updateType, (Object)uiJmsObject), false, true);
        if (endUpdate) {
            this.endUpdate(t);
        }
    }

    protected void modifyItemInTable(Trace t, DmJmsObject dmJmsObject) {
        UiJmsObject uiJmsObject = this.getItemInTable(t, dmJmsObject);
        if (uiJmsObject != null) {
            this.updateItemInTable(t, uiJmsObject, 2, true);
        } else {
            this.endUpdate(t);
        }
    }

    protected void removeItemFromTable(Trace t, DmJmsObject dmJmsObject, boolean endUpdate) {
        UiJmsObject uiJmsObject = this.getItemInTable(t, dmJmsObject);
        if (uiJmsObject != null) {
            this.removeItemFromTable(t, uiJmsObject, endUpdate);
        }
    }

    private void removeItemFromTable(Trace t, UiJmsObject uiJmsObject, boolean endUpdate) {
        this.updateItemInTable(t, uiJmsObject, 3, endUpdate);
    }

    private UiJmsObject getItemInTable(Trace t, DmJmsObject dmJmsObject) {
        UiJmsObject uiJmsObject = null;
        ArrayList jmsExtObjects = this.explorerTable.getObjects(t);
        Iterator iter = jmsExtObjects.iterator();
        while (iter.hasNext() && uiJmsObject == null) {
            MQExtObject extObject = (MQExtObject)iter.next();
            DmJmsObject currentObject = Utilities.getDmObject(extObject);
            if (!currentObject.equals(dmJmsObject)) continue;
            uiJmsObject = (UiJmsObject)((Object)extObject.getInternalObject());
        }
        return uiJmsObject;
    }

    private void removeAllObjectsInTable(Trace t) {
        ArrayList jmsExtObjects = this.explorerTable.getObjects(t);
        for (MQExtObject extObject : jmsExtObjects) {
            UiJmsObject uiJmsObject = (UiJmsObject)((Object)extObject.getInternalObject());
            this.removeItemFromTable(t, uiJmsObject, false);
        }
        this.endUpdate(t);
    }

    protected void updateTable(Trace t, DmJmsAbstractContext dmJmsContext) {
        Filter filter = this.explorerTable.getCurrentFilterSelection(t);
        DmObjectFilter dmFilter = filter.getDmObjectFilter(t);
        dmFilter.setMessagingProvider(0);
        Collection objects = dmJmsContext.getObjects(t, dmFilter);
        this.beginUpdate(t);
        this.explorerTable.queueUpdate(t, new ExplorerTableUpdate(t, 6), false, true);
        for (DmJmsObject dmJmsObject : objects) {
            this.addItemToTable(t, dmJmsObject, false);
        }
        this.endUpdate(t);
    }

    @Override
    public void update(final Observable o, final Object arg) {
        final Trace t = Trace.getDefault();
        final JmsContentPage observer = this;
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DmJmsObject dmJmsObject = (DmJmsObject)o;
                DmJmsEventHandler.handleEvent(t, observer, dmJmsObject, arg);
            }
        });
    }

    @Override
    public void changedEventReceived(Trace t, DmJmsObject object, DmJmsChangedEvent event) {
        this.modifyItemInTable(t, object);
    }

    @Override
    public void changingEventReceived(Trace t, DmJmsObject object, DmJmsChangingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void childAddedEventReceived(Trace t, DmJmsObject object, DmJmsChildAddedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object && event.isNoError()) {
            DmJmsObject newObject = event.getNewObject();
            this.addItemToTable(t, newObject, true);
        }
    }

    @Override
    public void closedEventReceived(Trace t, DmJmsObject object, DmJmsClosedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            boolean open = dmJmsContext.isOpen();
            this.updateContextStatus(t, open);
            if (!open) {
                this.removeAllObjectsInTable(t);
            }
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    private void updateContextStatus(Trace t, boolean open) {
        this.setExplorerTableLabel(t, open);
        this.explorerTable.setEnabled(open);
    }

    @Override
    public void closingEventReceived(Trace t, DmJmsObject object, DmJmsClosingEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void deletedEventReceived(Trace t, DmJmsObject object, DmJmsDeletedEvent event) {
        if (event.isNoError()) {
            this.removeItemFromTable(t, object, true);
        } else {
            this.endUpdate(t);
        }
    }

    @Override
    public void deletingEventReceived(Trace t, DmJmsObject object, DmJmsDeletingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void openedEventReceived(Trace t, DmJmsObject object, DmJmsOpenedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            this.updateContextStatus(t, dmJmsContext.isOpen());
            this.updateTable(t, (DmJmsAbstractContext)object);
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    @Override
    public void openingEventReceived(Trace t, DmJmsObject object, DmJmsOpeningEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void renameEventReceived(Trace t, DmJmsObject object, DmJmsRenameEvent event) {
        if (event.isNoError()) {
            DmJmsObject newDmObject = event.getNewObject();
            DmJmsObject oldDmObject = Utilities.getDmObject(this.externalObject);
            if (oldDmObject == object) {
                oldDmObject.deleteObserver(this);
                JmsContextExtObject parentExtObject = (JmsContextExtObject)this.getObject().getParent();
                UiJmsSubContext newUiObject = UiJmsSubContextFactory.create(t, (DmJmsContext)newDmObject, parentExtObject);
                MQExtObject newExtObject = Utilities.getExtObject(newUiObject);
                this.setObject(newExtObject);
            } else {
                this.removeItemFromTable(t, object, false);
                this.addItemToTable(t, newDmObject, true);
            }
        } else {
            this.endUpdate(t);
        }
    }

    @Override
    public void renamingEventReceived(Trace t, DmJmsObject object, DmJmsRenamingEvent event) {
        this.beginUpdate(t);
    }

    @Override
    public void reopenedEventReceived(Trace t, DmJmsObject object, DmJmsReopenedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            this.updateContextStatus(t, dmJmsContext.isOpen());
            this.updateTable(t, (DmJmsAbstractContext)object);
        } else {
            this.modifyItemInTable(t, object);
        }
    }

    @Override
    public void reopeningEventReceived(Trace t, DmJmsObject object, DmJmsReopeningEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(this.externalObject);
        if (dmJmsContext == object) {
            this.beginUpdate(t);
        }
    }

    @Override
    public void unknownDataModelEventReceived(Trace t, Object event) {
        JmsAdminPlugin.unknownDataModelEventReceived(t, event);
    }

    public void changed(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)this.getObject();
        if (jmsContextExtObject != null) {
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(jmsContextExtObject);
            this.updateTable(t, dmJmsContext);
        }
    }

    public void selectionChanged(FilterChangedEvent e) {
        Trace t = Trace.getDefault();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)this.getObject();
        if (jmsContextExtObject != null) {
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(jmsContextExtObject);
            this.updateTable(t, dmJmsContext);
        }
    }
}

