/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.Cipher;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SSLCipherSuiteModifyDialog
extends Dialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/custom/items/SSLCipherSuiteModifyDialog.java";
    private Shell parentShell = null;
    private GridLayout mainLayout;
    private GridData introductionGridData;
    private GridData descriptionGridData;
    private Shell shellDlg = null;
    private Table cipherTable = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private Button predef;
    private Button userdef;
    private Label introduction;
    private Label description;
    private Text customCipher;
    private String selectedSuite;
    private Message msgFile = null;
    private boolean isOK = false;
    private UiMQObject uiMQObject;

    public SSLCipherSuiteModifyDialog(Shell parent, int style, UiMQObject uiMQObject, String selectedSuite) {
        super(parent, style);
        this.parentShell = parent;
        this.uiMQObject = uiMQObject;
        this.selectedSuite = selectedSuite;
    }

    public boolean open(Trace t) {
        UiPlugin.showBusyCursor((Trace)t, (Shell)this.parentShell, (boolean)true);
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Status");
        this.shellDlg = new Shell(this.parentShell, 68848);
        UiUtils.setHelp((Control)this.shellDlg, (String)"com.ibm.mq.explorer.ui.infopop.UI_SelectMQObjectDialog");
        this.mainLayout = new GridLayout();
        this.mainLayout.numColumns = 1;
        this.mainLayout.makeColumnsEqualWidth = false;
        this.shellDlg.setLayout((Layout)this.mainLayout);
        final DmJmsObject dmobj = (DmJmsObject)this.uiMQObject.getDmObject();
        String title = dmobj.getParameter(13054).getFieldName(t);
        this.shellDlg.setText(title);
        this.shellDlg.setImage(Icons.get((String)Icons.iconkeyExplorerSmall));
        this.introduction = new Label((Composite)this.shellDlg, 2112);
        this.introduction.setText("\n\n\n\n\n");
        this.introductionGridData = new GridData(1808);
        this.introduction.setLayoutData((Object)this.introductionGridData);
        this.predef = new Button((Composite)this.shellDlg, 16);
        this.predef.setText(JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.usepredefined"));
        GridData gridData = new GridData(768);
        this.predef.setLayoutData((Object)gridData);
        this.cipherTable = new Table((Composite)this.shellDlg, 67588);
        this.cipherTable.setLinesVisible(true);
        this.cipherTable.setHeaderVisible(true);
        gridData = new GridData(1808);
        this.cipherTable.setLayoutData((Object)gridData);
        TableColumn column1 = new TableColumn(this.cipherTable, 0);
        column1.setText(JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.suite.label"));
        TableColumn column2 = new TableColumn(this.cipherTable, 0);
        column2.setText(JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.spec.label"));
        int i = 0;
        while (i < Cipher.list.length) {
            Cipher suite = Cipher.list[i];
            TableItem dataRow = new TableItem(this.cipherTable, 0);
            dataRow.setText(new String[]{suite.getSuiteDisplayName(), suite.getSpecDisplayName()});
            dataRow.setData((Object)suite);
            ++i;
        }
        column1.pack();
        column2.pack();
        this.description = new Label((Composite)this.shellDlg, 2112);
        this.description.setText("\n\n");
        Point calcSize = this.description.computeSize(10, -1, true);
        this.descriptionGridData = new GridData(1808);
        this.descriptionGridData.heightHint = calcSize.y;
        this.description.setLayoutData((Object)this.descriptionGridData);
        this.userdef = new Button((Composite)this.shellDlg, 16);
        this.userdef.setText(JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.usecustom"));
        gridData = new GridData(768);
        this.userdef.setLayoutData((Object)gridData);
        this.customCipher = new Text((Composite)this.shellDlg, 2048);
        this.customCipher.setText(this.selectedSuite);
        gridData = new GridData(768);
        this.customCipher.setLayoutData((Object)gridData);
        this.customCipher.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                Trace t1 = Trace.getDefault();
                SSLCipherSuiteModifyDialog.this.selectedSuite = SSLCipherSuiteModifyDialog.this.customCipher.getText();
                SSLCipherSuiteModifyDialog.this.description.setText(Cipher.getDescription(t1, SSLCipherSuiteModifyDialog.this.selectedSuite, (IDmObject)dmobj));
            }
        });
        this.customCipher.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SSLCipherSuiteModifyDialog.this.selectedSuite = SSLCipherSuiteModifyDialog.this.customCipher.getText();
            }
        });
        this.userdef.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                SSLCipherSuiteModifyDialog.this.setCustomMode(t1);
            }
        });
        this.predef.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                SSLCipherSuiteModifyDialog.this.setPreDefinedMode(t1);
            }
        });
        this.cipherTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                TableItem selected = (TableItem)e.item;
                Cipher suite = (Cipher)selected.getData();
                SSLCipherSuiteModifyDialog.this.selectedSuite = suite.getSuite();
                SSLCipherSuiteModifyDialog.this.description.setText(suite.getDescription(t1, dmobj));
            }
        });
        Composite compositeButtonsOuter = new Composite((Composite)this.shellDlg, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeButtonsOuter.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        compositeButtonsOuter.setLayoutData((Object)gridData);
        Label padding = new Label(compositeButtonsOuter, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
        Composite compositeButtons = new Composite(compositeButtonsOuter, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = true;
        compositeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData();
        compositeButtons.setLayoutData((Object)gridData);
        this.buttonOK = new Button(compositeButtons, 8);
        this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
        gridData = new GridData(768);
        this.buttonOK.setLayoutData((Object)gridData);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SSLCipherSuiteModifyDialog.this.isOK = true;
                SSLCipherSuiteModifyDialog.this.shellDlg.close();
            }
        });
        this.buttonCancel = new Button(compositeButtons, 8);
        this.buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLOSE"));
        GridData gridDataCancel = new GridData(768);
        this.buttonCancel.setLayoutData((Object)gridDataCancel);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SSLCipherSuiteModifyDialog.this.isOK = false;
                SSLCipherSuiteModifyDialog.this.shellDlg.close();
            }
        });
        this.shellDlg.setDefaultButton(this.buttonOK);
        UiPlugin.showBusyCursor((Trace)t, (Shell)this.parentShell, (boolean)false);
        this.shellDlg.layout();
        this.shellDlg.pack();
        this.introduction.setText(JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.intro"));
        int index = Cipher.getCipherIndex(t, this.selectedSuite);
        Cipher cipher = Cipher.getCipher(t, index);
        String descriptionText = Cipher.getDescription(t, cipher, (IDmObject)dmobj);
        this.description.setText(descriptionText);
        if (cipher == null) {
            this.setCustomMode(t);
        } else {
            this.setPreDefinedMode(t);
            this.cipherTable.setSelection(index);
        }
        this.shellDlg.open();
        Display display = this.shellDlg.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    private void setCustomMode(Trace t) {
        this.predef.setSelection(false);
        this.userdef.setSelection(true);
        this.customCipher.setEnabled(true);
        this.cipherTable.setEnabled(false);
        this.customCipher.setFocus();
    }

    private void setPreDefinedMode(Trace t) {
        this.predef.setSelection(true);
        this.userdef.setSelection(false);
        this.customCipher.setEnabled(false);
        this.cipherTable.setEnabled(true);
        this.cipherTable.setFocus();
    }

    public String getText() {
        return this.selectedSuite;
    }
}

