/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.core.internal.params.IJmsParameter;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.Cipher;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.CustomItem;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.SSLCipherSuiteModifyDialog;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SSLCipherSuiteCustomItem
implements CustomItem {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/custom/items/SSLCipherSuiteCustomItem.java";
    private String originalValue;
    private Attr attr = null;
    protected Message msgFile = null;
    private Composite parent;
    private Text mainText;
    private Label description;
    private UiMQObject uiMQObject;
    private static int MAX_WIDTH = 250;

    public SSLCipherSuiteCustomItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr attr, boolean readonly) {
        this.attr = attr;
        this.uiMQObject = uiMQObject;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Properties");
    }

    @Override
    public void init(Trace t) {
        AttrType attrType = this.attr.getAttrType();
        this.originalValue = (String)this.attr.getValue(t);
        this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        Group groupProps = new Group(this.parent, 0);
        groupProps.setText(attrType.getDisplayTitle());
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        groupProps.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupProps.setLayout((Layout)gridLayout);
        Composite suiteComposite = new Composite((Composite)groupProps, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        suiteComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        suiteComposite.setLayout((Layout)gridLayout);
        this.mainText = new Text(suiteComposite, 2048);
        this.mainText.setText(this.originalValue);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.mainText, (boolean)false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.mainText.setLayoutData((Object)gridData);
        Button selectButton = new Button(suiteComposite, 0);
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
        selectButton.setText(msgFile.getMessage(t, "UI.NewObject.WizPage1.ButtonSelect"));
        gridData = new GridData();
        selectButton.setLayoutData((Object)gridData);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                String selectedSuite = SSLCipherSuiteCustomItem.this.mainText.getText();
                Shell shell = UiPlugin.getShell();
                SSLCipherSuiteModifyDialog dialog = new SSLCipherSuiteModifyDialog(shell, 0, SSLCipherSuiteCustomItem.this.uiMQObject, selectedSuite);
                boolean result = dialog.open(t1);
                if (result) {
                    String text = dialog.getText();
                    SSLCipherSuiteCustomItem.this.mainText.setText(text);
                    SSLCipherSuiteCustomItem.this.description.setText(Cipher.getDescription(t1, text, SSLCipherSuiteCustomItem.this.uiMQObject.getDmObject()));
                }
            }
        });
        this.description = new Label((Composite)groupProps, 2112);
        this.description.setText("\n\n");
        Point calcSize = this.description.computeSize(10, -1, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = calcSize.y;
        gridData.widthHint = MAX_WIDTH;
        this.description.setLayoutData((Object)gridData);
        this.description.setText(Cipher.getDescription(t, this.originalValue, this.uiMQObject.getDmObject()));
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        String currentValue = this.mainText.getText();
        if (!this.originalValue.equals(currentValue)) {
            isChanged = true;
            this.attr.setNewValue(t, (Object)currentValue);
        }
        if (isChanged) {
            DmJmsObject dmJmsObject = (DmJmsObject)this.uiMQObject.getDmObject();
            ArrayList list = (ArrayList)job;
            IJmsParameter parameter = dmJmsObject.getParameter(13054);
            list.add(parameter);
        }
        return isChanged;
    }
}

