/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.UiJmsDestination;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EncodingCustomItem
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/custom/items/EncodingCustomItem.java";
    private final int INDEX_INTEGER_NORMAL = 0;
    private final int INDEX_INTEGER_REVERSED = 1;
    private final int INDEX_DECIMAL_NORMAL = 0;
    private final int INDEX_DECIMAL_REVERSED = 1;
    private final int INDEX_FLOAT_NORMAL = 0;
    private final int INDEX_FLOAT_REVERSED = 1;
    private final int INDEX_FLOAT_S390 = 2;
    public static final String NATIVE = "NATIVE";
    public static final char NORMAL = 'N';
    public static final char REVERSED = 'R';
    public static final char S390 = '3';
    public static final char UNKNOWN = '?';
    private UiJmsDestination uiJmsDestination;
    private Attr attr = null;
    private boolean readonly = false;
    protected Message msgFile = null;
    private Button nativeButton;
    private Combo integerCombo;
    private Combo decimalCombo;
    private Combo floatCombo;
    private Text number;
    private Text mnumonic;
    private Composite parent = null;

    public EncodingCustomItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr attr, boolean readonly) {
        super(t, parent, style, uiMQObject, attr, readonly);
        this.uiJmsDestination = (UiJmsDestination)uiMQObject;
        this.attr = attr;
        this.readonly = readonly;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Properties");
    }

    public void init(Trace t) {
        this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        Composite comp = new Composite(this.parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        comp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        comp.setLayout((Layout)gridLayout);
        AttrType attrType = this.attr.getAttrType();
        Integer objectValue = (Integer)this.attr.getValue(t);
        int value = objectValue;
        Group groupProps = new Group(comp, 0);
        groupProps.setText(attrType.getDisplayTitle());
        gridData = new GridData(768);
        groupProps.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        groupProps.setLayout((Layout)gridLayout);
        this.nativeButton = new Button((Composite)groupProps, 32);
        this.nativeButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.native"));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.grabExcessHorizontalSpace = true;
        this.nativeButton.setLayoutData((Object)gridData);
        this.nativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    EncodingCustomItem.this.integerCombo.setEnabled(false);
                    EncodingCustomItem.this.decimalCombo.setEnabled(false);
                    EncodingCustomItem.this.floatCombo.setEnabled(false);
                } else {
                    EncodingCustomItem.this.integerCombo.setEnabled(true);
                    EncodingCustomItem.this.decimalCombo.setEnabled(true);
                    EncodingCustomItem.this.floatCombo.setEnabled(true);
                }
                int newValue = EncodingCustomItem.this.getCurrentValue(t1);
                EncodingCustomItem.this.setMnumonicValues(t1, newValue);
            }
        });
        Label label = new Label((Composite)groupProps, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.integer"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.integerCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.integerCombo.setLayoutData((Object)gridData);
        this.integerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t1);
                EncodingCustomItem.this.setMnumonicValues(t1, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.decimal"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.decimalCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.decimalCombo.setLayoutData((Object)gridData);
        this.decimalCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t1);
                EncodingCustomItem.this.setMnumonicValues(t1, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.float"));
        this.floatCombo = new Combo((Composite)groupProps, 12);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.floatCombo.setLayoutData((Object)gridData);
        this.floatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace t1 = Trace.getDefault();
                int newValue = EncodingCustomItem.this.getCurrentValue(t1);
                EncodingCustomItem.this.setMnumonicValues(t1, newValue);
            }
        });
        label = new Label((Composite)groupProps, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.mnemonic"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.mnumonic = new Text((Composite)groupProps, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.mnumonic, (boolean)true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mnumonic.setLayoutData((Object)gridData);
        label = new Label((Composite)groupProps, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.encoding.value"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.number = new Text((Composite)groupProps, 2048);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.number, (boolean)true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.number.setLayoutData((Object)gridData);
        String normal = JmsAdminPlugin.getMessage("JmsAdmin.encoding.normal");
        String reversed = JmsAdminPlugin.getMessage("JmsAdmin.encoding.reversed");
        String s390 = JmsAdminPlugin.getMessage("JmsAdmin.encoding.s390");
        this.integerCombo.add(normal, 0);
        this.integerCombo.add(reversed, 1);
        this.decimalCombo.add(normal, 0);
        this.decimalCombo.add(reversed, 1);
        this.floatCombo.add(normal, 0);
        this.floatCombo.add(reversed, 1);
        this.floatCombo.add(s390, 2);
        this.setComboValues(t, value);
        this.setMnumonicValues(t, value);
        if (value == 273) {
            this.nativeButton.setSelection(true);
            this.integerCombo.setEnabled(false);
            this.decimalCombo.setEnabled(false);
            this.floatCombo.setEnabled(false);
        } else {
            this.nativeButton.setSelection(false);
            this.integerCombo.setEnabled(true);
            this.decimalCombo.setEnabled(true);
            this.floatCombo.setEnabled(true);
        }
    }

    private void setComboValues(Trace t, int value) {
        switch (value & 0xF) {
            case 1: {
                this.integerCombo.select(0);
                break;
            }
            case 2: {
                this.integerCombo.select(1);
            }
        }
        switch (value & 0xF0) {
            case 16: {
                this.decimalCombo.select(0);
                break;
            }
            case 32: {
                this.decimalCombo.select(1);
            }
        }
        switch (value & 0xF00) {
            case 256: {
                this.floatCombo.select(0);
                break;
            }
            case 512: {
                this.floatCombo.select(1);
                break;
            }
            case 768: {
                this.floatCombo.select(2);
            }
        }
    }

    private int getCurrentValue(Trace t) {
        int result = 0;
        if (this.nativeButton.getSelection()) {
            result = 273;
        } else {
            int index = this.integerCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 1;
                    break;
                }
                case 1: {
                    result |= 2;
                }
            }
            index = this.decimalCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 0x10;
                    break;
                }
                case 1: {
                    result |= 0x20;
                }
            }
            index = this.floatCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    result |= 0x100;
                    break;
                }
                case 1: {
                    result |= 0x200;
                    break;
                }
                case 2: {
                    result |= 0x300;
                }
            }
        }
        return result;
    }

    private void setMnumonicValues(Trace t, int value) {
        StringBuffer buffer = new StringBuffer();
        if (value == 273) {
            buffer.append(NATIVE);
        } else {
            if ((value & 1) != 0) {
                buffer.append('N');
            } else if ((value & 2) != 0) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
            if ((value & 0x10) != 0) {
                buffer.append('N');
            } else if ((value & 0x20) != 0) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
            if ((value & 0x300) == 768) {
                buffer.append('3');
            } else if ((value & 0x100) == 256) {
                buffer.append('N');
            } else if ((value & 0x200) == 512) {
                buffer.append('R');
            } else {
                buffer.append('?');
            }
        }
        this.mnumonic.setText(buffer.toString());
        this.number.setText(Integer.toString(value));
    }

    public void restoreDefaults(Trace t) {
    }

    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        if (!this.readonly) {
            Integer objectNewValue;
            DmJmsObject dmJmsObject;
            this.attr.getAttrType();
            Integer objectValue = (Integer)this.attr.getValue(t);
            int originalValue = objectValue;
            int newValue = this.getCurrentValue(t);
            if (originalValue != newValue && (dmJmsObject = (DmJmsObject)this.uiJmsDestination.getDmObject()).setAttributeValue(t, job, 13023, 0, objectNewValue = Integer.valueOf(newValue))) {
                isChanged = true;
            }
        }
        return isChanged;
    }

    public boolean isEnabled(Trace t) {
        return true;
    }

    public void changesApplied(Trace t) {
    }

    public void attrModified(AttributeModifiedEvent event) {
    }
}

