/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.jmqi.JmqiUtils;
import java.util.ArrayList;
import java.util.Collection;

public class Cipher {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/custom/items/Cipher.java";
    private String spec;
    private String suite;
    public static final Cipher[] list;

    static {
        Collection cipherSpecs = JmqiUtils.getCipherSpecs((boolean)false);
        ArrayList<Cipher> ciphers = new ArrayList<Cipher>(cipherSpecs.size() + 1);
        ciphers.add(new Cipher("", ""));
        for (String specName : cipherSpecs) {
            String suiteName = JmqiUtils.toCipherSuite((String)specName);
            ciphers.add(new Cipher(specName, suiteName));
        }
        list = new Cipher[ciphers.size()];
        ciphers.toArray(list);
    }

    private Cipher(String spec, String suite) {
        this.spec = spec;
        this.suite = suite;
    }

    public String getDescription(Trace t, IDmObject dmObject) {
        String description = null;
        if (this.suite.length() == 0) {
            description = JmsAdminPlugin.getMessage("JmsAdmin.sslcipher.descr.none");
        } else {
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
            String key = "UI.CHL.SSL.Cipher." + this.spec;
            description = msgFile.getMessage(t, key);
        }
        return description;
    }

    public static int getCipherIndex(Trace t, String value) {
        int found = -1;
        Cipher[] cipherList = list;
        int i = 0;
        while (i < cipherList.length) {
            Cipher suite = cipherList[i];
            String suitename = suite.suite;
            if (suitename.equals(value)) {
                found = i;
            }
            ++i;
        }
        return found;
    }

    public static Cipher getCipher(Trace t, int index) {
        Cipher cipher = null;
        if (index >= 0 && index < list.length) {
            cipher = list[index];
        }
        return cipher;
    }

    public static String getDescription(Trace t, Cipher cipher, IDmObject dmObject) {
        String descriptionText = null;
        if (cipher == null) {
            Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_NewObject");
            String key = "UI.CHL.SSL.Cipher.CUSTOM";
            descriptionText = msgFile.getMessage(t, key);
        } else {
            descriptionText = cipher.getDescription(t, dmObject);
        }
        return descriptionText;
    }

    public static String getDescription(Trace t, String value, IDmObject dmObject) {
        int index = Cipher.getCipherIndex(t, value);
        Cipher cipher = Cipher.getCipher(t, index);
        String description = Cipher.getDescription(t, cipher, dmObject);
        return description;
    }

    public static String getSuite(Trace t, String value) {
        int index = Cipher.getCipherIndex(t, value);
        Cipher cipher = Cipher.getCipher(t, index);
        return cipher.getSuiteDisplayName();
    }

    public String getSpec() {
        return this.spec;
    }

    public String getSuite() {
        return this.suite;
    }

    public String getSpecDisplayName() {
        String text = null;
        text = this.spec.length() == 0 ? JmsAdminPlugin.getMessage("JmsAdmin.None") : this.spec;
        return text;
    }

    public String getSuiteDisplayName() {
        String text = null;
        text = this.suite.length() == 0 ? JmsAdminPlugin.getMessage("JmsAdmin.None") : this.suite;
        return text;
    }

    public static String getSuiteDisplayName(Trace t, String value) {
        String result = null;
        int index = Cipher.getCipherIndex(t, value);
        if (index < 0) {
            result = value;
        } else {
            Cipher cipher = Cipher.getCipher(t, index);
            result = cipher.getSuiteDisplayName();
        }
        return result;
    }
}

