/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.UiJmsObject;
import java.util.Hashtable;

public abstract class UiJmsContext
extends UiJmsObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/UiJmsContext.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private String displayName;

    public UiJmsContext(Trace t, DmJmsAbstractContext jmsContextData) {
        super(t, jmsContextData);
        this.displayName = jmsContextData.getTitle();
    }

    @Override
    public abstract String getObjectType();

    @Override
    public abstract String getId();

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof UiJmsContext) {
            result = this.getId().equals(((UiJmsContext)((Object)object)).getId());
        }
        return result;
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        UiJmsContext targetUiObject = null;
        DmJmsAbstractContext targetDmObject = null;
        JmsContextExtObject targetExtObject = null;
        if (target instanceof JmsContextExtObject) {
            targetExtObject = (JmsContextExtObject)((Object)target);
            targetUiObject = (UiJmsContext)Utilities.getUiObject(targetExtObject);
        } else if (target instanceof JmsContextTreeNode) {
            JmsContextTreeNode targetTreeNode = (JmsContextTreeNode)((Object)target);
            targetExtObject = (JmsContextExtObject)((Object)targetTreeNode.getObject());
            targetUiObject = (UiJmsContext)Utilities.getUiObject(targetExtObject);
        } else if (target instanceof UiJmsContext) {
            targetUiObject = (UiJmsContext)((Object)target);
        }
        if (targetUiObject != null) {
            targetDmObject = (DmJmsAbstractContext)Utilities.getDmObject(targetUiObject);
        }
        if (targetDmObject != null) {
            if (name.equals("ContextStatus")) {
                result = UiJmsContext.testContextStatusAttribute(targetDmObject, value);
            } else if (name.equals("ContextJNDIProviderType")) {
                result = UiJmsContext.testContextJNDIProviderAttribute(targetDmObject, value);
            } else if (name.equals("ContextEmpty")) {
                result = UiJmsContext.testContextEmptyAttribute(targetDmObject, value);
            } else {
                super.testAttribute(target, name, value);
            }
        } else {
            super.testAttribute(target, name, value);
        }
        return result;
    }

    private static boolean testContextStatusAttribute(DmJmsAbstractContext targetDmJmsContext, String value) {
        boolean result = false;
        if (value.equals("ContextStatusConnected")) {
            if (targetDmJmsContext.isOpen()) {
                result = true;
            }
        } else if (value.equals("ContextStatusDisconnected") && !targetDmJmsContext.isOpen()) {
            result = true;
        }
        return result;
    }

    public static boolean testContextJNDIProviderAttribute(DmJmsAbstractContext targetDmJmsContext, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        DmJmsInitialContext targetInitialContext = targetDmJmsContext.getDmInitialContext(t);
        Hashtable environment = targetInitialContext.getEnvironment();
        String jndiProviderFactory = (String)environment.get("java.naming.factory.initial");
        if (value.equals("ContextJNDIProviderTypeLDAP")) {
            if (jndiProviderFactory.equals("com.sun.jndi.ldap.LdapCtxFactory")) {
                result = true;
            }
        } else if (value.equals("ContextJNDIProviderTypeFileSystem")) {
            if (jndiProviderFactory.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
                result = true;
            }
        } else if (value.equals("ContextJNDIProviderTypeOther")) {
            if (!jndiProviderFactory.equals("com.sun.jndi.ldap.LdapCtxFactory") && !jndiProviderFactory.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
                result = true;
            }
        } else if (jndiProviderFactory.equals(value)) {
            result = true;
        }
        return result;
    }

    private static boolean testContextEmptyAttribute(DmJmsAbstractContext targetDmJmsContext, String value) {
        Trace t = Trace.getDefault();
        boolean result = Boolean.valueOf(targetDmJmsContext.isEmpty(t)).toString().equals(value);
        return result;
    }
}

