/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminTreeNodeFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextContentProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextLabelProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectJmsContextDialog
extends ExtDialog {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/SelectJmsContextDialog.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 300;
    private String title;
    private String helpId;
    private Composite warningMessage;
    private Label warningMessageLabel;
    private TreeViewer treeViewer;
    UiJmsContext selectedContext;
    private Point preferredSize;

    public SelectJmsContextDialog(Trace t, Shell parent, String title, String helpId) {
        super(parent, 0);
        this.title = title;
        this.helpId = helpId;
        this.create(t);
    }

    public void cancelPressed(Trace t) {
    }

    public void createContent(final Trace t, Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(composite, 2820);
        GridData layoutData = new GridData(1808);
        this.treeViewer.getTree().setLayoutData((Object)layoutData);
        this.treeViewer.setContentProvider((IContentProvider)new JmsContextContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new JmsContextLabelProvider());
        this.treeViewer.setInput((Object)"");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectJmsContextDialog.this.updateSelectedContext(t);
                boolean enableOkButton = SelectJmsContextDialog.this.isEnableOK(t);
                SelectJmsContextDialog.this.enableOK(t, enableOkButton);
            }
        });
        this.warningMessage = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        this.warningMessage.setLayout((Layout)layout);
        layoutData = new GridData(768);
        this.warningMessage.setLayoutData((Object)layoutData);
        Label warningMessageIcon = new Label(this.warningMessage, 0);
        Image warningImage = Dialog.getImage((String)"dialog_messasge_warning_image");
        warningMessageIcon.setImage(warningImage);
        layoutData = new GridData();
        warningMessageIcon.setLayoutData((Object)layoutData);
        this.warningMessageLabel = new Label(this.warningMessage, 0);
        layoutData = new GridData(768);
        this.warningMessageLabel.setLayoutData((Object)layoutData);
        composite.pack();
        this.preferredSize = composite.getSize();
        if (this.preferredSize.x < 400) {
            this.preferredSize.x = 400;
        }
        if (this.preferredSize.y < 300) {
            this.preferredSize.y = 300;
        }
    }

    public void createUserButtons(Trace t, Composite composite) {
    }

    public String getHelpId(Trace t) {
        return this.helpId;
    }

    public Image getImage(Trace t) {
        return null;
    }

    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    public String getTitle(Trace t) {
        return this.title;
    }

    public boolean isEnableOK(Trace t) {
        boolean enable = true;
        if (this.selectedContext != null) {
            DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)this.selectedContext.getDmObject();
            if (dmJmsContext instanceof DmJmsInitialContext && !dmJmsContext.isOpen()) {
                enable = false;
                String message = JmsAdminPlugin.getMessage("JmsAdmin.SelectJmsContextDialog.Warning.Disconnected");
                this.displayWarningMessage(t, message);
            } else {
                this.displayWarningMessage(t, null);
            }
        } else {
            enable = false;
            int numberOfJmsContexts = JmsAdminPlugin.getAllJmsInitialContexts().size();
            if (numberOfJmsContexts == 0) {
                String message = JmsAdminPlugin.getMessage("JmsAdmin.SelectJmsContextDialog.Warning.NoneAvailable");
                this.displayWarningMessage(t, message);
            } else {
                this.displayWarningMessage(t, null);
            }
        }
        return enable;
    }

    private void displayWarningMessage(Trace t, String message) {
        if (message != null) {
            this.warningMessageLabel.setText(message);
            this.warningMessage.setVisible(true);
        } else {
            this.warningMessage.setVisible(false);
        }
    }

    public boolean isPackDialog(Trace t) {
        return false;
    }

    public boolean isUserButtons(Trace t) {
        return false;
    }

    public boolean okPressed(Trace t) {
        return true;
    }

    public void packDialog(Trace t) {
    }

    public UiJmsContext getSelectedContext(Trace t) {
        return this.selectedContext;
    }

    public void selectContext(DmJmsAbstractContext selection) {
        this.treeViewer.getTree().setFocus();
        StructuredSelection ssel = new StructuredSelection((Object)selection);
        this.treeViewer.setSelection((ISelection)ssel, true);
        this.treeViewer.reveal((Object)selection);
    }

    private void updateSelectedContext(Trace t) {
        Object obj;
        ISelection select = this.treeViewer.getSelection();
        if (select != null && (obj = ((IStructuredSelection)select).getFirstElement()) instanceof DmJmsAbstractContext) {
            JmsContextTreeNode selectedJmsTreeNode = JmsAdminTreeNodeFactory.getTreeNode((DmJmsAbstractContext)obj);
            JmsContextExtObject selectedExtObject = (JmsContextExtObject)((Object)selectedJmsTreeNode.getObject());
            this.selectedContext = (UiJmsContext)((Object)selectedExtObject.getInternalObject());
        }
    }
}

