/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.OpeningTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.JmsConnectionFactoriesFolderTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.JmsTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.JmsDestinationsFolderTreeNode;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.swt.graphics.Image;

public abstract class JmsContextTreeNode
extends JmsTreeNode {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/JmsContextTreeNode.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private String displayName;
    private OpeningTreeNode openingTreeNode;
    private JmsConnectionFactoriesFolderTreeNode connectionFactoriesFolder;
    private JmsDestinationsFolderTreeNode destinationsFolder;

    public JmsContextTreeNode(Trace t, TreeNode parent, JmsContextExtObject object) {
        super(t, parent, object);
        this.displayName = object.getDisplayName();
    }

    @Override
    public abstract String toString();

    protected String appendStatusToName(Trace t, String name, DmJmsAbstractContext dmJmsContext) {
        String newName = dmJmsContext.isOpen() ? String.valueOf(name) + ' ' + '[' + JmsAdminPlugin.getMessage("JmsAdmin.JmsContext.Status.Connected") + ']' : String.valueOf(name) + ' ' + '[' + JmsAdminPlugin.getMessage("JmsAdmin.JmsContext.Status.Disconnected") + ']';
        return newName;
    }

    @Override
    public abstract String getId();

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public abstract String getContentPageId();

    @Override
    public Image getIcon() {
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)((Object)this.getObject());
        UiJmsContext uiJmsContext = (UiJmsContext)((Object)jmsContextExtObject.getInternalObject());
        uiJmsContext.updateIcon();
        Image icon = uiJmsContext.getImage();
        return icon;
    }

    @Override
    public int compare(TreeNode child1, TreeNode child2) {
        int result = 0;
        result = child1.getId().startsWith("com.ibm.mq.explorer.jmsadmin.treenode.ConnectionFactories") ? -1 : (child1.getId().startsWith("com.ibm.mq.explorer.jmsadmin.treenode.Destinations") ? (child2.getId().startsWith("com.ibm.mq.explorer.jmsadmin.treenode.ConnectionFactories") ? 1 : -1) : TreeNode.compareByName((TreeNode)child1, (TreeNode)child2));
        return result;
    }

    public void contextOpening(Trace t) {
        this.addOpeningTreeNode(t);
    }

    public void contextOpen(Trace t) {
        this.removeOpeningNode(t);
        this.addCommonTreeNodes(t);
    }

    public void contextClosed(Trace t) {
        this.removeAllChildren(t);
    }

    public void removeAllChildren(Trace t) {
        this.removeCommonTreeNodes(t);
        TreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            this.removeChildFromNode(children[i]);
            ++i;
        }
    }

    private void addOpeningTreeNode(Trace t) {
        if (this.openingTreeNode == null) {
            this.openingTreeNode = new OpeningTreeNode(t, this, (MQExtObject)this.getObject());
            this.addChildToNode(this.openingTreeNode, 0);
        }
    }

    private void removeOpeningNode(Trace t) {
        if (this.openingTreeNode != null) {
            this.removeChildFromNode(this.openingTreeNode);
            this.openingTreeNode = null;
        }
    }

    private void addCommonTreeNodes(Trace t) {
        if (this.connectionFactoriesFolder == null) {
            this.connectionFactoriesFolder = new JmsConnectionFactoriesFolderTreeNode(t, this, (MQExtObject)this.getObject());
            this.addChildToNode(this.connectionFactoriesFolder, 0);
        }
        if (this.destinationsFolder == null) {
            this.destinationsFolder = new JmsDestinationsFolderTreeNode(t, this, (MQExtObject)this.getObject());
            this.addChildToNode(this.destinationsFolder, 0);
        }
    }

    private void removeCommonTreeNodes(Trace t) {
        if (this.connectionFactoriesFolder != null) {
            this.removeChildFromNode(this.connectionFactoriesFolder);
            this.connectionFactoriesFolder = null;
        }
        if (this.destinationsFolder != null) {
            this.removeChildFromNode(this.destinationsFolder);
            this.destinationsFolder = null;
        }
    }

    public void setObject(Object obj) {
        super.setObject(obj);
        if (this.connectionFactoriesFolder != null) {
            this.connectionFactoriesFolder.setObject(obj);
        }
        if (this.destinationsFolder != null) {
            this.destinationsFolder.setObject(obj);
        }
    }
}

