/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.LoginPromptDialog;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Shell;

public class ContextConnector {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/ContextConnector.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String CONNECT_THREAD_NAME = "IBM MQ JNDI Context Connect";
    static Hashtable connectingContexts = new Hashtable();
    DmJmsAbstractContext dmJmsContext;
    Shell shell;
    BusyDialog busyDialog;

    public ContextConnector(Trace t, DmJmsAbstractContext context, Shell sh) {
        this.dmJmsContext = context;
        this.shell = sh;
    }

    public void asyncConnect(final Trace t, final boolean reconnect, final boolean visible, final boolean modalDialogs) {
        UiPlugin.getDisplay().asyncExec((Runnable)new Thread(){

            @Override
            public void run() {
                ContextConnector.this.connect(t, reconnect, visible, modalDialogs);
            }
        });
    }

    public boolean connect(Trace t, boolean reconnect, boolean visible, boolean modalDialogs) {
        boolean canConnect = ContextConnector.addToConnectingList(t, this.dmJmsContext);
        if (canConnect) {
            this.createBusyDialog(t);
            boolean authenticationRequired = this.authenticationRequired(t);
            if (authenticationRequired) {
                this.startAuthenticatedConnect(t, reconnect, true, modalDialogs);
            } else {
                this.startConnect(t, reconnect, visible);
            }
            this.openBusyDialog(t, visible);
        }
        return this.dmJmsContext.isOpen();
    }

    private boolean authenticationRequired(Trace t) {
        boolean authenticationRequired = false;
        if (this.dmJmsContext instanceof DmJmsInitialContext && !this.dmJmsContext.isOpen() && ((DmJmsInitialContext)this.dmJmsContext).needsAuthentication()) {
            authenticationRequired = true;
        }
        return authenticationRequired;
    }

    private void startAuthenticatedConnect(Trace t, boolean reconnect, boolean visible, boolean modalDialogs) {
        DmJmsInitialContext context = (DmJmsInitialContext)this.dmJmsContext;
        String username = context.getUserDN();
        String password = context.getPassword();
        String titleText = JmsAdminPlugin.getMessage("JmsAdmin.LoginDialog.Title.Text");
        String nickname = context.getTitle();
        String providerURL = context.getAttributeValue(t, 13104, 0);
        LoginPromptDialog loginPrompt = new LoginPromptDialog(t, this.shell, titleText, nickname, providerURL, username, password, modalDialogs);
        loginPrompt.open();
        int loginResult = loginPrompt.getReturnCode();
        if (loginResult == 0) {
            username = loginPrompt.getUsername();
            context.setUserDN(t, username);
            password = loginPrompt.getPassword();
            context.setPassword(password);
            this.startConnect(t, reconnect, visible);
        } else {
            this.connectCompleted(t);
        }
    }

    void startConnect(final Trace t, final boolean reconnect, final boolean visible) {
        new Thread(CONNECT_THREAD_NAME){

            @Override
            public void run() {
                try {
                    if (reconnect) {
                        ContextConnector.this.dmJmsContext.reopen(t);
                    } else {
                        ContextConnector.this.dmJmsContext.open(t);
                    }
                    UiPlugin.getDisplay().asyncExec((Runnable)new Thread(){

                        @Override
                        public void run() {
                            ContextConnector.this.connectCompleted(t);
                        }
                    });
                }
                catch (DmCoreException e) {
                    UiPlugin.getDisplay().asyncExec((Runnable)new Thread(){

                        @Override
                        public void run() {
                            ContextConnector.this.connectFailed(t, visible, e);
                        }
                    });
                }
            }
        }.start();
    }

    private void createBusyDialog(Trace t) {
        String connectingText = JmsAdminPlugin.getMessage("JmsAdmin.JmsContext.ConnectingBusyDialog.Text");
        connectingText = Message.format((String)connectingText, (String)this.dmJmsContext.getTitle());
        this.busyDialog = new BusyDialog(this.shell, connectingText);
    }

    private void openBusyDialog(Trace t, boolean visible) {
        if (visible) {
            this.busyDialog.showDialog(t);
        }
    }

    private void closeBusyDialog(Trace t) {
        this.busyDialog.closeDialog(t);
    }

    void connectCompleted(Trace t) {
        this.closeBusyDialog(t);
        ContextConnector.removeFromConnectingList(t, this.dmJmsContext);
    }

    void connectFailed(Trace t, boolean visible, DmCoreException exception) {
        this.connectCompleted(t);
        if (visible) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)this.shell, (DmCoreException)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addToConnectingList(Trace t, DmJmsAbstractContext context) {
        boolean canConnect = false;
        String contextID = Utilities.getUniqueId(t, context);
        Hashtable hashtable = connectingContexts;
        synchronized (hashtable) {
            if (!connectingContexts.containsKey(contextID)) {
                connectingContexts.put(contextID, context);
                canConnect = true;
            }
        }
        return canConnect;
    }

    private static void removeFromConnectingList(Trace t, DmJmsAbstractContext context) {
        String contextID = Utilities.getUniqueId(t, context);
        connectingContexts.remove(contextID);
    }
}

