/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWiz;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWizPage1;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AddJmsContextWizPage3
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/AddJmsContextWizPage3.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int HORIZONTAL_SPAN = 4;
    private boolean pageContentCreated;
    private Text nickNameText;
    private Button connectImmediatelyCheckbox;
    private Button autoreconnectCheckbox;
    boolean nicknameModified;
    private Control firstControl;

    public AddJmsContextWizPage3(String pageName) {
        super(pageName);
        String titleText = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.Title");
        this.setTitle(titleText);
        String description = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.Description");
        this.setDescription(description);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.NickNameLabel"));
        GridData layout = new GridData(768);
        layout.horizontalSpan = 1;
        label.setLayoutData((Object)layout);
        this.nickNameText = new Text(parent, 2048);
        layout = new GridData(768);
        layout.horizontalSpan = 3;
        this.nickNameText.setLayoutData((Object)layout);
        this.nickNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJmsContextWizPage3.this.checkIfEnableButtons();
                AddJmsContextWizPage3.this.nicknameModified = true;
            }
        });
        this.firstControl = this.nickNameText;
        this.connectImmediatelyCheckbox = new Button(parent, 32);
        this.connectImmediatelyCheckbox.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.ConnectImmediatelyButtonText"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.connectImmediatelyCheckbox.setLayoutData((Object)layout);
        this.connectImmediatelyCheckbox.setSelection(true);
        this.autoreconnectCheckbox = new Button(parent, 32);
        this.autoreconnectCheckbox.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.AutoreconnectButtonText"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.autoreconnectCheckbox.setLayoutData((Object)layout);
        this.autoreconnectCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddJmsContextWizPage3.this.updateAutoreconnectHelpText(t);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddJmsContextWizPage3.this.updateAutoreconnectHelpText(t);
            }
        });
        this.autoreconnectCheckbox.setSelection(false);
        this.pageContentCreated = true;
    }

    void updateAutoreconnectHelpText(Trace t) {
        boolean needHelpText;
        AddJmsContextWiz wizard = (AddJmsContextWiz)this.getWizard();
        boolean bl = needHelpText = this.autoreconnectCheckbox.getSelection() && wizard.usingSecurity();
        if (needHelpText) {
            this.setMessage(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page3.AutoreconnectInformation"), 1);
        } else {
            this.setMessage(null);
        }
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        if (this.pageContentCreated) {
            boolean pageComplete = false;
            if (this.nickNameText.getText().length() > 0) {
                pageComplete = true;
            }
            this.setPageComplete(pageComplete);
            AddJmsContextWiz wizard = (AddJmsContextWiz)this.getWizard();
            wizard.setEnableFinish(pageComplete);
            wizard.getContainer().updateButtons();
        }
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Trace t = Trace.getDefault();
        if (visible) {
            this.updateNickname(t);
            this.updateAutoreconnectHelpText(t);
            this.firstControl.setFocus();
        }
    }

    private void updateNickname(Trace t) {
        if (!this.nicknameModified || this.nickNameText.getText().length() == 0) {
            AddJmsContextWiz wizard = (AddJmsContextWiz)this.getWizard();
            AddJmsContextWizPage1 page1 = (AddJmsContextWizPage1)wizard.getPages()[0];
            String nickname = Utilities.decodeUrl(t, page1.getProviderURL(t));
            this.nickNameText.setText(nickname);
            this.nickNameText.setFocus();
            this.nickNameText.setSelection(0, this.nickNameText.getText().length());
            this.nicknameModified = false;
        }
    }

    String getNickname() {
        Trace t = Trace.getDefault();
        this.updateNickname(t);
        String nickName = this.nickNameText.getText();
        return nickName;
    }

    boolean connectImmediatelyRequested() {
        return this.connectImmediatelyCheckbox.getSelection();
    }

    boolean autoreconnectRequested() {
        return this.autoreconnectCheckbox.getSelection();
    }
}

