/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWiz;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AddJmsContextWizPage2
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/AddJmsContextWizPage2.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int HORIZONTAL_SPAN = 4;
    static final int AUTHENTICATION_NONE = 0;
    static final int AUTHENTICATION_SIMPLE = 1;
    static final int AUTHENTICATION_CRAM_MD5 = 2;
    int currentAuthenticationType = 0;
    Combo authenticationTypeCombo;
    private Text authenticationHelpText;
    private Control firstControl;

    public AddJmsContextWizPage2(String pageName) {
        super(pageName);
        String titleText = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.Title");
        this.setTitle(titleText);
        String description = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.Description");
        this.setDescription(description);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.AuthenticationTypeLabel"));
        GridData layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.authenticationTypeCombo = new Combo(parent, 2060);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.authenticationTypeCombo.setLayoutData((Object)layout);
        this.authenticationTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int currentSelection = AddJmsContextWizPage2.this.authenticationTypeCombo.getSelectionIndex();
                if (currentSelection >= 0) {
                    AddJmsContextWizPage2.this.currentAuthenticationType = currentSelection;
                }
                AddJmsContextWizPage2.this.updateHelpText(t, AddJmsContextWizPage2.this.currentAuthenticationType);
            }
        });
        this.firstControl = this.authenticationTypeCombo;
        this.authenticationHelpText = new Text(parent, 2114);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.authenticationHelpText, (boolean)true);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.authenticationHelpText.setLayoutData((Object)layout);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)AddJmsContextWizPage2.this.authenticationHelpText);
            }
        });
        UiUtils.createBlankLine((Composite)parent, (int)4);
    }

    void updateHelpText(Trace t, int authenticationType) {
        String text = new String();
        switch (authenticationType) {
            case 0: {
                text = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.NoAuthenticationHelpText");
                break;
            }
            case 1: {
                text = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.SimpleAuthenticationHelpText");
                break;
            }
            case 2: {
                text = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page2.CRAMMD5AuthenticationHelpText");
            }
        }
        this.authenticationHelpText.setText(text);
        UiUtils.resizeControl((Trace)t, (Control)this.authenticationHelpText);
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        boolean pageComplete = true;
        this.setPageComplete(pageComplete);
        AddJmsContextWiz wizard = (AddJmsContextWiz)this.getWizard();
        wizard.setEnableFinish(pageComplete);
        wizard.getContainer().updateButtons();
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    int getAuthenticationType() {
        return this.currentAuthenticationType;
    }

    String getAuthenticationTypeAsString(Trace t) {
        String authenticationTypeAsString = new String();
        switch (this.currentAuthenticationType) {
            case 0: {
                authenticationTypeAsString = "none";
                break;
            }
            case 1: {
                authenticationTypeAsString = "simple";
                break;
            }
            case 2: {
                authenticationTypeAsString = "CRAM_MD5";
            }
        }
        return authenticationTypeAsString;
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            int tempCurrentAuthenticationType = this.currentAuthenticationType;
            this.authenticationTypeCombo.removeAll();
            AttrTypeFixedLengthStringEnum authenticationAttrType = (AttrTypeFixedLengthStringEnum)DmJmsInitialContext.getAttributeType(t, 13106);
            String noAuthenticationText = authenticationAttrType.getEnumeratedValue(t, "none");
            this.authenticationTypeCombo.add(noAuthenticationText, 0);
            String simpleAuthenticationText = authenticationAttrType.getEnumeratedValue(t, "simple");
            this.authenticationTypeCombo.add(simpleAuthenticationText, 1);
            String md5AuthenticationText = authenticationAttrType.getEnumeratedValue(t, "CRAM_MD5");
            this.authenticationTypeCombo.add(md5AuthenticationText, 2);
            this.currentAuthenticationType = tempCurrentAuthenticationType;
            this.authenticationTypeCombo.select(this.currentAuthenticationType);
            this.updateHelpText(t, this.currentAuthenticationType);
            this.firstControl.setFocus();
        }
    }
}

