/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.jmsadmin.ui.JmsAdminCommon;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWiz;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddJmsContextWizPage1
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/AddJmsContextWizPage1.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int HORIZONTAL_SPAN = 4;
    static final int NAMESPACE_LDAP = 0;
    static final int NAMESPACE_FILE_SYSTEM = 1;
    static final int NAMESPACE_OTHER = 2;
    private boolean pageContentCreated;
    private int currentNamespaceType;
    private StackLayout namespaceSpecificControlsLayout;
    private Composite ldapControls;
    private Composite fileSystemControls;
    private Composite otherControls;
    private Text otherFactoryClassText;
    Button factoryClassLocatedInDirectoryButton;
    List requiredLibraryLocationList;
    private Text ldapProviderUrlText;
    private Text fileSystemProviderUrlText;
    private Text otherProviderUrlText;
    Text hostText;
    Text distinguishedNameText;
    Text bindingsDirectoryText;
    private Control firstControl;

    public AddJmsContextWizPage1(String pageName) {
        super(pageName);
        String titleText = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.Title");
        this.setTitle(titleText);
        String description = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.Description");
        this.setDescription(description);
    }

    public void createPageContent(Trace t, Composite parent) {
        this.addNamespaceTypeControls(t, parent);
        UiUtils.createBlankLine((Composite)parent, (int)4);
        this.addNamespaceSpecificControls(t, parent);
        this.setNamespaceType(t, 0);
        this.pageContentCreated = true;
    }

    private void addNamespaceTypeControls(final Trace t, Composite parent) {
        final Text namespaceTypelabel = new Text(parent, 66);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)namespaceTypelabel, (boolean)true);
        namespaceTypelabel.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.NamespaceTypeDescription"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        layoutData.widthHint = 500;
        namespaceTypelabel.setLayoutData((Object)layoutData);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)namespaceTypelabel);
            }
        });
        UiUtils.createBlankLine((Composite)parent, (int)4);
        Text label = new Text(parent, 74);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.NamespaceType"));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        label.setLayoutData((Object)layoutData);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)label, (boolean)true);
        Composite buttonGroup = new Composite(parent, 0);
        buttonGroup.setLayout((Layout)new GridLayout());
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        buttonGroup.setLayoutData((Object)layoutData);
        final Button ldapButton = new Button(buttonGroup, 16);
        ldapButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.LdapButtonText"));
        ldapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJmsContextWizPage1.this.setNamespaceType(t, 0);
                AddJmsContextWizPage1.this.firstControl = (Control)ldapButton;
            }
        });
        ldapButton.setSelection(true);
        this.firstControl = ldapButton;
        final Button fileSystemButton = new Button(buttonGroup, 16);
        fileSystemButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.FileSystemButtonText"));
        fileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJmsContextWizPage1.this.setNamespaceType(t, 1);
                AddJmsContextWizPage1.this.firstControl = (Control)fileSystemButton;
            }
        });
        final Button otherButton = new Button(buttonGroup, 16);
        otherButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.OtherButtonText"));
        otherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddJmsContextWizPage1.this.setNamespaceType(t, 2);
                AddJmsContextWizPage1.this.firstControl = (Control)otherButton;
            }
        });
    }

    private void addNamespaceSpecificControls(Trace t, Composite parent) {
        Composite namespaceSpecificControls = new Composite(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        namespaceSpecificControls.setLayoutData((Object)layoutData);
        this.namespaceSpecificControlsLayout = new StackLayout();
        namespaceSpecificControls.setLayout((Layout)this.namespaceSpecificControlsLayout);
        this.ldapControls = this.createNamespaceSpecificControls(t, namespaceSpecificControls, 0);
        this.fileSystemControls = this.createNamespaceSpecificControls(t, namespaceSpecificControls, 1);
        this.otherControls = this.createNamespaceSpecificControls(t, namespaceSpecificControls, 2);
    }

    private Composite createNamespaceSpecificControls(Trace t, Composite parent, int namespaceType) {
        Composite controls = new Composite(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        controls.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(4, true);
        controls.setLayout((Layout)layout);
        String serviceProviderTitle = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.ServiceProviderLabel");
        Group serviceProviderGroup = this.createGroup(t, controls, serviceProviderTitle);
        this.addServiceProviderControls(t, (Composite)serviceProviderGroup, namespaceType);
        UiUtils.createBlankLine((Composite)controls, (int)4);
        String locationTitle = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.JmsContextLocationLabel");
        Group locationGroup = this.createGroup(t, controls, locationTitle);
        this.addLocationControls(t, (Composite)locationGroup, namespaceType);
        return controls;
    }

    private Group createGroup(Trace t, Composite parent, String title) {
        Group group = new Group(parent, 32);
        group.setText(title);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        group.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(4, true);
        group.setLayout((Layout)layout);
        return group;
    }

    private void addServiceProviderControls(Trace t, Composite parent, int namespaceType) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.FactoryClassLabel"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        Text factoryClassText = new Text(parent, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        factoryClassText.setLayoutData((Object)layoutData);
        switch (namespaceType) {
            case 0: {
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)factoryClassText, (boolean)true);
                factoryClassText.setText("com.sun.jndi.ldap.LdapCtxFactory");
                break;
            }
            case 1: {
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)factoryClassText, (boolean)true);
                factoryClassText.setText("com.sun.jndi.fscontext.RefFSContextFactory");
                break;
            }
            case 2: {
                this.otherFactoryClassText = factoryClassText;
                this.otherFactoryClassText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddJmsContextWizPage1.this.checkIfEnableButtons();
                    }
                });
                this.addOtherServiceProviderControls(t, parent);
            }
        }
    }

    private void addOtherServiceProviderControls(Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.RequiredLibraryLocationsLabel"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        Composite controlArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlArea.setLayout((Layout)layout);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        controlArea.setLayoutData((Object)layoutData);
        this.requiredLibraryLocationList = new List(controlArea, 2818);
        layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalSpan = 1;
        layoutData.verticalSpan = 3;
        this.requiredLibraryLocationList.setLayoutData((Object)layoutData);
        final Button addRequiredLibraryLocationJarButton = new Button(controlArea, 8);
        addRequiredLibraryLocationJarButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.AddJarRequiredLibraryLocationButtonText"));
        layoutData = new GridData();
        layoutData.horizontalAlignment = 3;
        addRequiredLibraryLocationJarButton.setLayoutData((Object)layoutData);
        addRequiredLibraryLocationJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename;
                FileDialog fileDialog = new FileDialog(addRequiredLibraryLocationJarButton.getShell(), 4096);
                fileDialog.setFilterExtensions(JmsAdminCommon.PROVIDER_LIBRARY_EXTENSIONS);
                fileDialog.setFilterNames(JmsAdminCommon.PROVIDER_LIBRARY_EXTENSION_NAMES);
                String[] selectedRequiredLibraryLocations = AddJmsContextWizPage1.this.requiredLibraryLocationList.getSelection();
                if (selectedRequiredLibraryLocations != null && selectedRequiredLibraryLocations.length > 0) {
                    fileDialog.setFileName(selectedRequiredLibraryLocations[0]);
                }
                if ((filename = fileDialog.open()) != null && AddJmsContextWizPage1.this.requiredLibraryLocationList.indexOf(filename) < 0) {
                    AddJmsContextWizPage1.this.requiredLibraryLocationList.add(filename);
                }
                AddJmsContextWizPage1.this.checkIfEnableButtons();
            }
        });
        final Button addRequiredLibraryLocationDirectoryButton = new Button(controlArea, 8);
        addRequiredLibraryLocationDirectoryButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.AddDirectoryRequiredLibraryLocationButtonText"));
        layoutData = new GridData();
        layoutData.horizontalAlignment = 3;
        addRequiredLibraryLocationDirectoryButton.setLayoutData((Object)layoutData);
        addRequiredLibraryLocationDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fileDialog = new DirectoryDialog(addRequiredLibraryLocationDirectoryButton.getShell(), 4096);
                String filename = fileDialog.open();
                if (filename != null && AddJmsContextWizPage1.this.requiredLibraryLocationList.indexOf(filename) < 0) {
                    AddJmsContextWizPage1.this.requiredLibraryLocationList.add(filename);
                }
                AddJmsContextWizPage1.this.checkIfEnableButtons();
            }
        });
        final Button removeRequiredLibraryLocationButton = new Button(controlArea, 8);
        removeRequiredLibraryLocationButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.RemoveRequiredLibraryLocationButtonText"));
        layoutData = new GridData();
        layoutData.horizontalAlignment = 3;
        removeRequiredLibraryLocationButton.setLayoutData((Object)layoutData);
        removeRequiredLibraryLocationButton.setEnabled(false);
        removeRequiredLibraryLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedItems = AddJmsContextWizPage1.this.requiredLibraryLocationList.getSelectionIndices();
                AddJmsContextWizPage1.this.requiredLibraryLocationList.remove(selectedItems);
                boolean itemSelected = AddJmsContextWizPage1.this.requiredLibraryLocationList.getSelectionCount() > 0;
                removeRequiredLibraryLocationButton.setEnabled(itemSelected);
                AddJmsContextWizPage1.this.checkIfEnableButtons();
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])new Button[]{addRequiredLibraryLocationJarButton, addRequiredLibraryLocationDirectoryButton, removeRequiredLibraryLocationButton});
        this.requiredLibraryLocationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean itemSelected = AddJmsContextWizPage1.this.requiredLibraryLocationList.getSelectionCount() > 0;
                removeRequiredLibraryLocationButton.setEnabled(itemSelected);
            }
        });
    }

    String factoryClassLocationBrowse(Trace t, Shell sh, String currentFilename, boolean locatedInDirectory) {
        String filename = null;
        if (locatedInDirectory) {
            DirectoryDialog fileDialog = new DirectoryDialog(sh, 4096);
            filename = fileDialog.open();
        } else {
            FileDialog fileDialog = new FileDialog(sh, 4096);
            fileDialog.setFilterExtensions(JmsAdminCommon.PROVIDER_LIBRARY_EXTENSIONS);
            fileDialog.setFilterNames(JmsAdminCommon.PROVIDER_LIBRARY_EXTENSION_NAMES);
            fileDialog.setFileName(currentFilename);
            filename = fileDialog.open();
        }
        return filename;
    }

    private void addLocationControls(Trace t, Composite parent, int namespaceType) {
        switch (namespaceType) {
            case 0: {
                this.addLdapLocationControls(t, parent);
                break;
            }
            case 1: {
                this.addFileSystemLocationControls(t, parent);
            }
        }
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.ProviderUrlLabel"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        Text providerUrlText = new Text(parent, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        providerUrlText.setLayoutData((Object)layoutData);
        switch (namespaceType) {
            case 0: {
                this.ldapProviderUrlText = providerUrlText;
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)providerUrlText, (boolean)true);
                break;
            }
            case 1: {
                this.fileSystemProviderUrlText = providerUrlText;
                UiUtils.makeTextControlReadOnly((Trace)t, (Text)providerUrlText, (boolean)true);
                break;
            }
            case 2: {
                this.otherProviderUrlText = providerUrlText;
                providerUrlText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddJmsContextWizPage1.this.checkIfEnableButtons();
                    }
                });
            }
        }
    }

    private void addLdapLocationControls(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.HostLabel"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        this.hostText = new Text(parent, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.hostText.setLayoutData((Object)layoutData);
        label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.DistinguishedNameLabel"));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        this.distinguishedNameText = new Text(parent, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.distinguishedNameText.setLayoutData((Object)layoutData);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJmsContextWizPage1.this.updateProviderURL(t);
                AddJmsContextWizPage1.this.checkIfEnableButtons();
            }
        };
        this.hostText.addModifyListener(listener);
        this.distinguishedNameText.addModifyListener(listener);
        UiUtils.createBlankLine((Composite)parent, (int)1);
        label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.DistinguishedNameExampleLabel"));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        label.setLayoutData((Object)layoutData);
    }

    private void addFileSystemLocationControls(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.BindingsDirectoryLabel"));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        label.setLayoutData((Object)layoutData);
        Composite controlArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlArea.setLayout((Layout)layout);
        layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        controlArea.setLayoutData((Object)layoutData);
        this.bindingsDirectoryText = new Text(controlArea, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        layoutData.grabExcessHorizontalSpace = true;
        this.bindingsDirectoryText.setLayoutData((Object)layoutData);
        this.bindingsDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddJmsContextWizPage1.this.updateProviderURL(t);
                AddJmsContextWizPage1.this.checkIfEnableButtons();
            }
        });
        final Button bindingsDirectoryBrowseButton = new Button(controlArea, 8);
        bindingsDirectoryBrowseButton.setText(JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.BrowseButtonText"));
        bindingsDirectoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename = AddJmsContextWizPage1.this.bindingsDirectoryBrowse(t, bindingsDirectoryBrowseButton.getShell());
                if (filename != null) {
                    AddJmsContextWizPage1.this.bindingsDirectoryText.setText(filename);
                }
            }
        });
    }

    String bindingsDirectoryBrowse(Trace t, Shell sh) {
        DirectoryDialog fileDialog = new DirectoryDialog(sh, 4096);
        String filename = fileDialog.open();
        return filename;
    }

    void updateProviderURL(Trace t) {
        switch (this.currentNamespaceType) {
            case 0: {
                String host = this.hostText.getText();
                String distinguishedName = this.distinguishedNameText.getText();
                String ldapUrl = "ldap://" + host + "/" + distinguishedName;
                this.ldapProviderUrlText.setText(ldapUrl);
                this.isURLValid(ldapUrl);
                break;
            }
            case 1: {
                String providerURL = new String();
                String filename = this.bindingsDirectoryText.getText();
                if (filename.length() > 0) {
                    File bindingsDirectory = new File(filename);
                    providerURL = bindingsDirectory.toURI().toString();
                    providerURL = Utilities.decodeUrl(t, providerURL);
                }
                this.fileSystemProviderUrlText.setText(providerURL);
            }
        }
    }

    private boolean isURLValid(String url) {
        URISyntaxException urlException = null;
        boolean valid = true;
        try {
            new URI(url.replaceAll("\\\\", "/"));
        }
        catch (URISyntaxException e) {
            urlException = e;
        }
        if (urlException != null) {
            String message = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.LdapUrlInvalid");
            int messageType = 3;
            this.setMessage(message, messageType);
            valid = false;
        } else {
            this.setMessage(null);
        }
        return valid;
    }

    void setNamespaceType(Trace t, int type) {
        this.currentNamespaceType = type;
        switch (type) {
            case 0: {
                this.namespaceSpecificControlsLayout.topControl = this.ldapControls;
                this.ldapControls.getParent().layout();
                break;
            }
            case 1: {
                this.namespaceSpecificControlsLayout.topControl = this.fileSystemControls;
                this.fileSystemControls.getParent().layout();
                break;
            }
            case 2: {
                this.namespaceSpecificControlsLayout.topControl = this.otherControls;
                this.otherControls.getParent().layout();
            }
        }
        this.setMessage(null);
        this.checkIfEnableButtons();
    }

    public boolean performFinish() {
        return true;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        if (this.pageContentCreated) {
            boolean pageComplete = false;
            switch (this.currentNamespaceType) {
                case 0: {
                    if (this.hostText.getText().length() <= 0 || this.distinguishedNameText.getText().length() <= 0) break;
                    pageComplete = this.isURLValid(this.ldapProviderUrlText.getText());
                    break;
                }
                case 1: {
                    String bindingsDirectory = this.bindingsDirectoryText.getText();
                    pageComplete = this.isFileValid(t, bindingsDirectory, true, true);
                    break;
                }
                case 2: {
                    boolean providerURLEntered = this.otherProviderUrlText.getText().length() > 0;
                    int numberOfFactoryLocations = this.requiredLibraryLocationList.getItemCount();
                    boolean factoryLocationsValid = numberOfFactoryLocations > 0;
                    int i = 0;
                    while (i < numberOfFactoryLocations && factoryLocationsValid) {
                        String factoryClassLocation = this.requiredLibraryLocationList.getItem(i);
                        factoryLocationsValid = this.isFileValid(t, factoryClassLocation, false, false);
                        ++i;
                    }
                    pageComplete = providerURLEntered && factoryLocationsValid;
                }
            }
            this.setPageComplete(pageComplete);
            AddJmsContextWiz wizard = (AddJmsContextWiz)this.getWizard();
            wizard.setEnableFinish(pageComplete);
            wizard.getContainer().updateButtons();
        }
    }

    private boolean isFileValid(Trace t, String filename, boolean mustBeDirectory, boolean mustBeBindingsLocation) {
        boolean valid = true;
        String message = null;
        int messageType = 0;
        if (filename.length() > 0) {
            File file = new File(filename);
            if (file.exists() && file.canRead()) {
                if (mustBeDirectory && file.isDirectory() || !mustBeDirectory) {
                    File[] files;
                    if (mustBeBindingsLocation && (files = file.listFiles()) != null && files.length > 0) {
                        boolean bindingsFileExists = false;
                        int i = 0;
                        while (i < files.length) {
                            String bindingsFile;
                            String currentFilename = files[i].getName();
                            if (currentFilename.equals(bindingsFile = ".bindings")) {
                                bindingsFileExists = true;
                                if (!files[i].isFile() || !files[i].canRead()) {
                                    message = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.BindingsFileInvalid");
                                    message = Message.format((String)message, (String)bindingsFile);
                                    messageType = 3;
                                    valid = false;
                                }
                            }
                            ++i;
                        }
                        if (!bindingsFileExists) {
                            message = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.DirectoryNotEmpty");
                            messageType = 2;
                        }
                    }
                } else {
                    message = mustBeDirectory ? JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.MustBeDirectory") : JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.MustBeFile");
                    messageType = 3;
                    valid = false;
                }
            } else {
                message = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Page1.FileInvalid");
                messageType = 3;
                valid = false;
            }
        } else {
            valid = false;
        }
        this.setMessage(message, messageType);
        return valid;
    }

    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    int getNamespaceType() {
        return this.currentNamespaceType;
    }

    String getProviderURL(Trace t) {
        String providerURL = null;
        switch (this.currentNamespaceType) {
            case 0: {
                providerURL = this.ldapProviderUrlText.getText();
                break;
            }
            case 1: {
                String filename = this.bindingsDirectoryText.getText();
                File bindingsDirectory = new File(filename);
                providerURL = bindingsDirectory.toURI().toString();
                break;
            }
            case 2: {
                providerURL = this.otherProviderUrlText.getText();
            }
        }
        return providerURL;
    }

    String getFactoryClass(Trace t) {
        String factoryClass = null;
        switch (this.currentNamespaceType) {
            case 0: {
                factoryClass = "com.sun.jndi.ldap.LdapCtxFactory";
                break;
            }
            case 1: {
                factoryClass = "com.sun.jndi.fscontext.RefFSContextFactory";
                break;
            }
            case 2: {
                factoryClass = this.otherFactoryClassText.getText();
            }
        }
        return factoryClass;
    }

    URL[] getRequiredLibraryLocations(Trace t) {
        String[] requiredLibraryLocations = this.requiredLibraryLocationList.getItems();
        URL[] requiredLibraryLocationURLs = new URL[requiredLibraryLocations.length];
        int i = 0;
        while (i < requiredLibraryLocations.length) {
            File requiredLibraryLocationFile = new File(requiredLibraryLocations[i]);
            try {
                requiredLibraryLocationURLs[i] = requiredLibraryLocationFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                t.FFST(66, "AddJmsContextWizPage1.getRequiredLibraryLocations", 0, 50006, "Malformed URL: " + requiredLibraryLocations[i]);
            }
            ++i;
        }
        return requiredLibraryLocationURLs;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.firstControl.setFocus();
        }
    }
}

