/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.contexts;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.jmsadmin.ui.JmsAdminCommon;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWizPage1;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWizPage2;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWizPage3;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWizPage4;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextsFolderTreeNode;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class AddJmsContextWiz
extends Wizard {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/contexts/AddJmsContextWiz.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private AddJmsContextWizPage1 page1;
    private AddJmsContextWizPage2 page2;
    private AddJmsContextWizPage3 page3;
    private AddJmsContextWizPage4 page4;
    private boolean enableFinish = false;
    private boolean performFinish = true;

    public AddJmsContextWiz() {
        String title = JmsAdminPlugin.getMessage("JmsAdmin.AddJmsContextWizard.Window.Title");
        this.setWindowTitle(title);
        this.page1 = new AddJmsContextWizPage1("com.ibm.mq.explorer.jmsadmin.ui.contexts.addwizard.page1");
        this.page2 = new AddJmsContextWizPage2("com.ibm.mq.explorer.jmsadmin.ui.contexts.addwizard.page2");
        this.page3 = new AddJmsContextWizPage3("com.ibm.mq.explorer.jmsadmin.ui.contexts.addwizard.page3");
        this.page4 = new AddJmsContextWizPage4("com.ibm.mq.explorer.jmsadmin.ui.contexts.addwizard.page4");
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean performFinish() {
        JmsContext jmsContext;
        boolean autoreconnect;
        Trace t = Trace.getDefault();
        if (!this.performFinish) {
            return false;
        }
        this.performFinish = false;
        boolean success = true;
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String providerURL = this.page1.getProviderURL(t);
        environment.put("java.naming.provider.url", providerURL);
        String serviceProviderfactory = this.page1.getFactoryClass(t);
        environment.put("java.naming.factory.initial", serviceProviderfactory);
        int namespaceType = this.page1.getNamespaceType();
        String authenticationType = namespaceType == 1 ? "none" : this.page2.getAuthenticationTypeAsString(t);
        environment.put("java.naming.security.authentication", authenticationType);
        String nickName = this.page3.getNickname();
        if (nickName.length() == 0) {
            nickName = providerURL;
        }
        if (autoreconnect = this.page3.autoreconnectRequested()) {
            environment.put("AUTORECONNECT", JmsAdminCommon.TRUE_TOGGLE);
        } else {
            environment.put("AUTORECONNECT", JmsAdminCommon.FALSE_TOGGLE);
        }
        boolean connectImmediately = this.page3.connectImmediatelyRequested();
        String namePrefix = this.page4.getNamePrefix();
        environment.put("NAME_PREFIX", namePrefix);
        boolean useInitialDirContext = this.page4.useInitialDirContext();
        if (useInitialDirContext) {
            environment.put("USE_INITIAL_DIR_CONTEXT", "TRUE");
        } else {
            environment.remove("USE_INITIAL_DIR_CONTEXT");
        }
        URL[] requiredLibraryLocationURLs = null;
        if (namespaceType == 2) {
            requiredLibraryLocationURLs = this.page1.getRequiredLibraryLocations(t);
        }
        if ((jmsContext = JmsAdminPlugin.createJmsInitialContext(t, this.getShell(), nickName, environment, requiredLibraryLocationURLs)) != null) {
            if (connectImmediately && !(success = JmsAdminMenuActions.connectToContext(t, jmsContext.getDmObject(), UiPlugin.getShell(), false, true, true))) {
                JmsAdminPlugin.removeJmsInitialContext(t, this.getShell(), jmsContext);
            }
        } else {
            success = false;
            String helpID = "AMQ4409";
            String message = CommonServices.getSystemMessage((String)helpID);
            message = Message.format((String)message, (String)nickName);
            MessageBox.showMessageFailure((Trace)t, (Shell)this.getShell(), (String)message, (String)helpID);
        }
        if (success) {
            JmsContextsFolderTreeNode node = JmsAdminPlugin.getJmsContextsFolderTreeNode();
            UiPlugin.getMQNavigatorView().expandTreeNode(t, (TreeNode)node);
        }
        this.performFinish = true;
        return success;
    }

    public void addPages() {
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        String pageName = page.getName();
        int namespaceType = this.page1.getNamespaceType();
        if (pageName.equals(this.page1.getName())) {
            if (namespaceType == 1) {
                nextPage = this.getNextPage((IWizardPage)this.page2);
            }
        } else if (pageName.equals(this.page3.getName()) && (namespaceType == 0 || namespaceType == 1)) {
            nextPage = this.getNextPage((IWizardPage)this.page4);
        }
        return nextPage;
    }

    boolean usingSecurity() {
        int authenticationType;
        boolean usingSecurity = false;
        int namespaceType = this.page1.getNamespaceType();
        if (namespaceType != 1 && (authenticationType = this.page2.getAuthenticationType()) != 0) {
            usingSecurity = true;
        }
        return usingSecurity;
    }
}

