/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsDamagedConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.ui.Icons;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.custom.items.SSLCustomPropertyPage;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.UiJmsObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UiJmsConnectionFactory
extends UiJmsObject {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/connectionfactories/UiJmsConnectionFactory.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";

    public UiJmsConnectionFactory(Trace t, DmJmsAbstractConnectionFactory jmsConnectionFactoryData) {
        super(t, jmsConnectionFactoryData);
    }

    @Override
    public boolean isAllowProperties() {
        boolean properties = true;
        DmJmsAbstractConnectionFactory dmJmsConnectionFactory = (DmJmsAbstractConnectionFactory)this.getDmObject();
        if (dmJmsConnectionFactory instanceof DmJmsDamagedConnectionFactory) {
            properties = false;
        }
        return properties;
    }

    @Override
    public boolean isAllowApplyProperties() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "com.ibm.mq.explorer.jmsadmin.ConnectionFactory";
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.jmsadmin.ConnectionFactory";
    }

    public void appendToContextMenu(final Shell sh, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        super.appendToContextMenu(sh, manager, contextObject);
        String treeNodeId = (String)contextObject;
        final UiJmsConnectionFactory thisUiObject = this;
        final DmJmsAbstractConnectionFactory dmConnectionFactory = (DmJmsAbstractConnectionFactory)this.getDmObject();
        if (treeNodeId.startsWith("com.ibm.mq.explorer.jmsadmin.treenode.ConnectionFactories")) {
            Action delete = new Action(){

                public void run() {
                    JmsAdminMenuActions.deleteJmsObject(sh, dmConnectionFactory);
                }
            };
            delete.setText(JmsAdminPlugin.getMessage("JmsAdmin.Objects.Delete.Label"));
            UiUtils.setHelp((IAction)delete, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_DeleteConnectionFactoryMenuItem");
            Action rename = new Action(){

                public void run() {
                    JmsAdminMenuActions.renameJmsObject(sh, dmConnectionFactory);
                }
            };
            rename.setText(JmsAdminPlugin.getMessage("JmsAdmin.Objects.Rename.Label"));
            UiUtils.setHelp((IAction)rename, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_RenameConnectionFactoryMenuItem");
            MenuManager switchMenu = new MenuManager(JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.SwitchTransportMenu.Label"));
            switchMenu.add((IContributionItem)new GroupMarker("com.ibm.mq.explorer.jmsadmin.menugroup"));
            Action switchToBindings = new Action(){

                public void run() {
                    JmsAdminMenuActions.switchTransportType(sh, thisUiObject, 0);
                }
            };
            switchToBindings.setText(JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.TransportType.Bindings"));
            UiUtils.setHelp((IAction)switchToBindings, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_SwitchConnectionFactoryTransportToBindingsMenuItem");
            Action switchToClient = new Action(){

                public void run() {
                    JmsAdminMenuActions.switchTransportType(sh, thisUiObject, 1);
                }
            };
            switchToClient.setText(JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.TransportType.Client"));
            UiUtils.setHelp((IAction)switchToClient, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_SwitchConnectionFactoryTransportToClientMenuItem");
            Action switchToDirect = new Action(){

                public void run() {
                    JmsAdminMenuActions.switchTransportType(sh, thisUiObject, 2);
                }
            };
            switchToDirect.setText(JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.TransportType.Direct"));
            UiUtils.setHelp((IAction)switchToDirect, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_SwitchConnectionFactoryTransportToDirectMenuItem");
            Action switchToDirectHttp = new Action(){

                public void run() {
                    JmsAdminMenuActions.switchTransportType(sh, thisUiObject, 4);
                }
            };
            switchToDirectHttp.setText(JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.TransportType.DirectHttp"));
            UiUtils.setHelp((IAction)switchToDirectHttp, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_SwitchConnectionFactoryTransportToDirectHTTPMenuItem");
            int messagingProvider = dmConnectionFactory.getMessagingProvider(t);
            int transportType = dmConnectionFactory.getTransport(t);
            switch (transportType) {
                case 0: {
                    switchToBindings.setEnabled(false);
                    break;
                }
                case 1: {
                    switchToClient.setEnabled(false);
                    break;
                }
                case 2: {
                    switchToDirect.setEnabled(false);
                    break;
                }
                case 4: {
                    switchToDirectHttp.setEnabled(false);
                }
            }
            manager.insertBefore("additions", (IContributionItem)new GroupMarker("com.ibm.mq.explorer.jmsadmin.menugroup"));
            manager.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)delete);
            if (!(dmConnectionFactory instanceof DmJmsDamagedConnectionFactory)) {
                manager.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)rename);
                manager.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IContributionItem)switchMenu);
                switch (messagingProvider) {
                    case 1: {
                        switchMenu.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)switchToBindings);
                        switchMenu.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)switchToClient);
                        break;
                    }
                    case 2: {
                        switchMenu.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)switchToDirect);
                        switchMenu.appendToGroup("com.ibm.mq.explorer.jmsadmin.menugroup", (IAction)switchToDirectHttp);
                    }
                }
            }
        }
    }

    @Override
    public void updateIcon() {
        Trace t = Trace.getDefault();
        Image icon = null;
        DmJmsAbstractConnectionFactory dmJmsConnectionFactory = (DmJmsAbstractConnectionFactory)this.getDmObject();
        if (dmJmsConnectionFactory instanceof DmJmsDamagedConnectionFactory) {
            icon = Icons.get(t, "jndiObjectCorrupt.gif");
        } else {
            int messagingProvider = dmJmsConnectionFactory.getMessagingProvider(t);
            switch (messagingProvider) {
                case 1: {
                    icon = Icons.get(t, "connectionFactoryMQ.gif");
                    break;
                }
                case 2: {
                    icon = Icons.get(t, "connectionFactoryRealtime.gif");
                }
            }
        }
        if (icon != null) {
            super.setImage(icon);
        }
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiJmsConnectionFactory targetUiObject = null;
        DmJmsAbstractConnectionFactory targetDmObject = null;
        MQExtObject targetExtObject = null;
        if (target instanceof MQExtObject) {
            targetExtObject = (MQExtObject)target;
            targetUiObject = (UiJmsConnectionFactory)Utilities.getUiObject(targetExtObject);
        } else if (target instanceof UiJmsConnectionFactory) {
            targetUiObject = (UiJmsConnectionFactory)((Object)target);
        }
        if (targetUiObject != null) {
            targetDmObject = (DmJmsAbstractConnectionFactory)Utilities.getDmObject(targetUiObject);
        }
        if (targetDmObject != null) {
            if (name.equals("ConnectionFactoryTransportType")) {
                int transportType = targetDmObject.getTransport(t);
                if (value.equals("ConnectionFactoryTransportTypeBindings")) {
                    if (transportType == 0) {
                        result = true;
                    }
                } else if (value.equals("ConnectionFactoryTransportTypeClient")) {
                    if (transportType == 1) {
                        result = true;
                    }
                } else if (value.equals("ConnectionFactoryTransportTypeDirect")) {
                    if (transportType == 2) {
                        result = true;
                    }
                } else if (value.equals("ConnectionFactoryTransportTypeDirectHTTP") && transportType == 4) {
                    result = true;
                }
            } else {
                result = UiJmsContext.testContextJNDIProviderAttribute(targetDmObject.getParent(), value) ? true : super.testAttribute(target, name, value);
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    @Override
    protected int getQueueManagerAttrId(int attrId) {
        int id = 0;
        switch (attrId) {
            case 13002: 
            case 13008: 
            case 13012: 
            case 13064: {
                id = 13043;
                break;
            }
            case 13003: 
            case 13005: {
                id = 13007;
            }
        }
        return id;
    }

    @Override
    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 122: {
                isCustom = true;
            }
        }
        return isCustom;
    }

    @Override
    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        SSLCustomPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 122: {
                customPage = new SSLCustomPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
            }
        }
        return customPage;
    }
}

