/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.NewConnectionFactoryObjectProvider;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewConnectionFactoryWizPage2
extends WizPage {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/connectionfactories/NewConnectionFactoryWizPage2.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final int HORIZONTAL_SPAN = 4;
    private NewObjectWiz wizard;
    NewConnectionFactoryObjectProvider newObjectProvider;
    private boolean pageContentCreated;
    private Text nameText;
    Combo factoryTypeCombo;
    Text factoryTypeHelpText;
    Button xaCheckbox;
    private Control firstControl;

    public NewConnectionFactoryWizPage2(String pageName, NewObjectWiz wiz, NewConnectionFactoryObjectProvider newObjProvider) {
        super(pageName);
        this.wizard = wiz;
        this.newObjectProvider = newObjProvider;
        String titleText = JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.Title");
        this.setTitle(titleText);
        String description = JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.Description");
        this.setDescription(description);
    }

    public void createPageContent(final Trace t, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Name.Label"));
        GridData layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.nameText = new Text(parent, 2048);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.nameText.setLayoutData((Object)layout);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConnectionFactoryWizPage2.this.checkIfEnableButtons();
            }
        });
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.nameText, (boolean)false);
        label = new Label(parent, 0);
        label.setText(JmsAdminPlugin.getMessage("JmsAdmin.NewObjectWizard.Page2.TypeLabel"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        label.setLayoutData((Object)layout);
        this.factoryTypeCombo = new Combo(parent, 2060);
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.factoryTypeCombo.setLayoutData((Object)layout);
        this.factoryTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = NewConnectionFactoryWizPage2.this.factoryTypeCombo.getText();
                if (!text.equals(new String())) {
                    int type = NewConnectionFactoryWizPage2.this.newObjectProvider.getFactoryType(t, text);
                    NewConnectionFactoryWizPage2.this.newObjectProvider.setCurrentFactoryType(type);
                    NewConnectionFactoryWizPage2.this.updateHelpText(t);
                }
            }
        });
        this.firstControl = this.factoryTypeCombo;
        this.xaCheckbox = new Button(parent, 32);
        this.xaCheckbox.setText(JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.XAButtonText"));
        layout = new GridData(768);
        layout.horizontalSpan = 4;
        this.xaCheckbox.setLayoutData((Object)layout);
        this.xaCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConnectionFactoryWizPage2.this.newObjectProvider.setSupportingXA(NewConnectionFactoryWizPage2.this.xaCheckbox.getSelection());
                NewConnectionFactoryWizPage2.this.updateHelpText(t);
            }
        });
        this.xaCheckbox.setSelection(false);
        this.factoryTypeHelpText = new Text(parent, 2114);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.factoryTypeHelpText, (boolean)true);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.factoryTypeHelpText.setLayoutData((Object)gridData);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UiUtils.resizeControl((Trace)t, (Control)NewConnectionFactoryWizPage2.this.factoryTypeHelpText);
            }
        });
        this.pageContentCreated = true;
    }

    void updateHelpText(Trace t) {
        int type = this.newObjectProvider.getCurrentFactoryType();
        String text = this.newObjectProvider.getFactoryTypeHelpText(t, type);
        this.factoryTypeHelpText.setText(text);
        UiUtils.resizeControl((Trace)t, (Control)this.factoryTypeHelpText);
    }

    public boolean performFinish() {
        Trace t = Trace.getDefault();
        UiMQObject newObject = this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
        boolean result = this.wizard.createObject(t, newObject.getDmObject(), null);
        return result;
    }

    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        if (this.pageContentCreated) {
            boolean pageComplete = false;
            if (this.nameText.getText().length() > 0) {
                pageComplete = true;
            }
            this.setPageComplete(pageComplete);
            this.wizard.setEnableFinish(false);
            this.wizard.updateButtons(t);
        }
    }

    public void nextPressed() {
        Trace t = Trace.getDefault();
        this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.wizard.getNewObjectName());
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 4);
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible) {
            this.nameText.setText(this.wizard.getNewObjectName());
            int provider = this.newObjectProvider.getCurrentMessagingProvider();
            int factoryType = this.newObjectProvider.getCurrentFactoryType();
            this.factoryTypeCombo.removeAll();
            int[] factoryTypes = this.newObjectProvider.getFactoryTypes(t, provider);
            int itemToSelect = -1;
            int i = 0;
            while (i < factoryTypes.length) {
                int currentFactoryType = factoryTypes[i];
                String text = this.newObjectProvider.getFactoryTypeText(t, currentFactoryType);
                this.factoryTypeCombo.add(text);
                if (factoryType == currentFactoryType) {
                    itemToSelect = i;
                }
                ++i;
            }
            if (itemToSelect >= 0) {
                this.factoryTypeCombo.select(itemToSelect);
            }
            this.updateHelpText(t);
            if (!this.newObjectProvider.canUseXA(provider)) {
                this.xaCheckbox.setEnabled(false);
                this.xaCheckbox.setSelection(false);
            } else {
                this.xaCheckbox.setEnabled(true);
                boolean currentXAValue = this.newObjectProvider.isSupportingXA();
                this.xaCheckbox.setSelection(currentXAValue);
            }
            this.firstControl.setFocus();
        }
    }
}

