/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsQueueConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsTopicConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXAConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXAQueueConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsXATopicConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.NewConnectionFactoryWizPage1;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.NewConnectionFactoryWizPage2;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.NewConnectionFactoryWizPage3;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.UiJmsConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.NewJmsObjectProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsConnectionFactoryFactory;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXAConnectionFactory;
import com.ibm.mq.jms.MQXAQueueConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnectionFactory;
import javax.jms.JMSException;
import org.eclipse.swt.widgets.Shell;

public class NewConnectionFactoryObjectProvider
extends NewJmsObjectProvider {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/connectionfactories/NewConnectionFactoryObjectProvider.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String[] PAGE_IDS = new String[]{"com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page1", "com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page2", "com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page3", "PAGE_STD_SELECT_LIKE_OBJECT", "PAGE_STD_CHANGE_PROPERTIES"};
    private static final int FACTORY_TYPE_CONNECTION_FACTORY = 0;
    private static final int FACTORY_TYPE_QUEUE_CONNECTION_FACTORY = 1;
    private static final int FACTORY_TYPE_TOPIC_CONNECTION_FACTORY = 2;
    private static final int TRANSPORT_TYPE_BINDINGS = 0;
    private static final int TRANSPORT_TYPE_MQ_CLIENT = 1;
    private static final int TRANSPORT_TYPE_DIRECT = 2;
    private static final int TRANSPORT_TYPE_DIRECT_HTTP = 4;
    private NewObjectWiz wizard;
    private int currentFactoryType;
    private boolean supportingXA;
    private int currentTransportType;
    private UiJmsConnectionFactory uiJmsConnectionFactory;
    private MQXAConnectionFactory mqxaConnectionFactory = null;
    private MQXAQueueConnectionFactory mqxaQueueConnectionFactory = null;
    private MQXATopicConnectionFactory mqxaTopicConnectionFactory = null;
    private MQConnectionFactory mqConnectionFactory = null;
    private MQQueueConnectionFactory mqQueueConnectionFactory = null;
    private MQTopicConnectionFactory mqTopicConnectionFactory = null;

    public NewConnectionFactoryObjectProvider(Trace t, UiJmsContext parent) {
        super(t, parent);
        this.resetWizard(t);
    }

    @Override
    protected void resetWizard(Trace t) {
        this.setCurrentMessagingProvider(t, 0);
        this.currentFactoryType = 0;
        this.currentTransportType = 0;
        this.supportingXA = false;
        this.mqxaConnectionFactory = null;
        this.mqxaQueueConnectionFactory = null;
        this.mqxaTopicConnectionFactory = null;
        this.mqConnectionFactory = null;
        this.mqQueueConnectionFactory = null;
        this.mqTopicConnectionFactory = null;
    }

    @Override
    public String getGenericObjectName(Trace t) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.Object.Type");
    }

    @Override
    public String getMenuTextForNewObjectType(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.New.Label");
    }

    @Override
    public String getHelpIdForNewObjectType(Trace t, String typeId) {
        return "com.ibm.mq.explorer.jmsadmin.infopop.UI_NewConnectionFactoryMenuItem";
    }

    @Override
    public String getObjectId() {
        return "com.ibm.mq.explorer.jmsadmin.ConnectionFactory";
    }

    @Override
    public IUiMQObjectFactory getUiMQObjectFactory(Trace t) {
        return new UiJmsConnectionFactoryFactory();
    }

    @Override
    public String[] getPageIds(Trace t, String typeId) {
        return PAGE_IDS;
    }

    @Override
    public WizPage getWizardPage(Trace t, String pageId, NewObjectWiz wiz) {
        this.wizard = wiz;
        WizPage wizardPage = null;
        wizardPage = pageId.equals("com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page1") ? new NewConnectionFactoryWizPage1(pageId, this.wizard, this) : (pageId.equals("com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page2") ? new NewConnectionFactoryWizPage2(pageId, this.wizard, this) : (pageId.equals("com.ibm.mq.explorer.jmsadmin.ui.destinations.newconnectionfactorywizard.page3") ? new NewConnectionFactoryWizPage3(pageId, this.wizard, this) : super.getWizardPage(t, pageId, this.wizard)));
        return wizardPage;
    }

    @Override
    public UiMQObject[] getCandidateLikeObjects(Trace t, String typeId) {
        DmJmsAbstractConnectionFactory dmJmsConnectionFactory = (DmJmsAbstractConnectionFactory)this.uiJmsConnectionFactory.getDmObject();
        UiJmsContext parent = (UiJmsContext)this.getParent();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)Utilities.getExtObject(parent);
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(parent);
        Object[] dmConnectionFactories = dmJmsContext.getLikeObjects(t, dmJmsConnectionFactory).toArray();
        UiMQObject[] uiConnectionFactories = new UiMQObject[dmConnectionFactories.length];
        int i = 0;
        while (i < dmConnectionFactories.length) {
            DmJmsAbstractConnectionFactory currentDmJmsConnectionFactory = (DmJmsAbstractConnectionFactory)dmConnectionFactories[i];
            uiConnectionFactories[i] = UiJmsConnectionFactoryFactory.create(t, currentDmJmsConnectionFactory, jmsContextExtObject);
            ++i;
        }
        return uiConnectionFactories;
    }

    @Override
    public UiMQObject createInterimObject(Trace t, String typeId, String name) {
        UiJmsContext parent = (UiJmsContext)this.getParent();
        JmsContextExtObject jmsContextExtObject = (JmsContextExtObject)Utilities.getExtObject(parent);
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)Utilities.getDmObject(parent);
        MQXAConnectionFactory mqConnFactory = null;
        DmJmsAbstractConnectionFactory dmJmsConnectionFactory = null;
        if (this.supportingXA) {
            switch (this.currentFactoryType) {
                case 0: {
                    if (this.mqxaConnectionFactory == null) {
                        this.mqxaConnectionFactory = new MQXAConnectionFactory();
                    }
                    mqConnFactory = this.mqxaConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsXAConnectionFactory(t, name, mqConnFactory, dmJmsContext);
                    break;
                }
                case 1: {
                    if (this.mqxaQueueConnectionFactory == null) {
                        this.mqxaQueueConnectionFactory = new MQXAQueueConnectionFactory();
                    }
                    mqConnFactory = this.mqxaQueueConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsXAQueueConnectionFactory(t, name, (MQXAQueueConnectionFactory)mqConnFactory, dmJmsContext);
                    break;
                }
                case 2: {
                    if (this.mqxaTopicConnectionFactory == null) {
                        this.mqxaTopicConnectionFactory = new MQXATopicConnectionFactory();
                    }
                    mqConnFactory = this.mqxaTopicConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsXATopicConnectionFactory(t, name, (MQXATopicConnectionFactory)mqConnFactory, dmJmsContext);
                }
            }
        } else {
            switch (this.currentFactoryType) {
                case 0: {
                    if (this.mqConnectionFactory == null) {
                        this.mqConnectionFactory = new MQConnectionFactory();
                    }
                    mqConnFactory = this.mqConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsConnectionFactory(t, name, (MQConnectionFactory)mqConnFactory, dmJmsContext);
                    break;
                }
                case 1: {
                    if (this.mqQueueConnectionFactory == null) {
                        this.mqQueueConnectionFactory = new MQQueueConnectionFactory();
                    }
                    mqConnFactory = this.mqQueueConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsQueueConnectionFactory(t, name, (MQQueueConnectionFactory)mqConnFactory, dmJmsContext);
                    break;
                }
                case 2: {
                    if (this.mqTopicConnectionFactory == null) {
                        this.mqTopicConnectionFactory = new MQTopicConnectionFactory();
                    }
                    mqConnFactory = this.mqTopicConnectionFactory;
                    this.setTransportType(t, (MQConnectionFactory)mqConnFactory);
                    dmJmsConnectionFactory = new DmJmsTopicConnectionFactory(t, name, (MQTopicConnectionFactory)mqConnFactory, dmJmsContext);
                }
            }
        }
        this.uiJmsConnectionFactory = UiJmsConnectionFactoryFactory.create(t, dmJmsConnectionFactory, jmsContextExtObject);
        return this.uiJmsConnectionFactory;
    }

    private void setTransportType(Trace t, MQConnectionFactory connectionFactory) {
        try {
            connectionFactory.setTransportType(this.currentTransportType);
        }
        catch (JMSException jMSException) {
            String helpID = "AMQ4585";
            String failingMethodName = "setTransportType";
            String message = CommonServices.getSystemMessage((String)helpID);
            message = Message.format((String)message, (String)failingMethodName);
            t.FFST(66, "NewConnectionFactoryObjectProvider.setTransportType", 0, 0, message);
            Shell sh = this.wizard != null ? this.wizard.getShell() : UiPlugin.getShell();
            MessageBox.showMessageFailure((Trace)t, (Shell)sh, (String)message, (String)helpID);
        }
    }

    int getCurrentFactoryType() {
        return this.currentFactoryType;
    }

    void setCurrentFactoryType(int type) {
        this.currentFactoryType = type;
    }

    boolean isSupportingXA() {
        return this.supportingXA;
    }

    void setSupportingXA(boolean value) {
        this.supportingXA = value;
    }

    int getCurrentTransportType() {
        return this.currentTransportType;
    }

    void setCurrentTransportType(int type) {
        this.currentTransportType = type;
    }

    @Override
    public void setCurrentMessagingProvider(Trace t, int messagingProvider) {
        super.setCurrentMessagingProvider(t, messagingProvider);
        switch (messagingProvider) {
            case 0: {
                if (this.currentTransportType == 0 || this.currentTransportType == 1) break;
                this.currentTransportType = 0;
                break;
            }
            case 1: {
                this.supportingXA = false;
                if (this.currentTransportType != 2 && this.currentTransportType != 4) {
                    this.currentTransportType = 2;
                }
                if (this.currentFactoryType != 1) break;
                this.currentFactoryType = 0;
            }
        }
    }

    @Override
    public boolean isObjectComplete(Trace t) {
        boolean complete = false;
        if (this.uiJmsConnectionFactory != null && this.uiJmsConnectionFactory.isMandatoryAttributesPresent(t)) {
            complete = true;
        }
        return complete;
    }

    @Override
    public int[] getMessagingProviders() {
        return new int[1];
    }

    public int[] getFactoryTypes(Trace t, int messagingProvider) {
        int[] types = null;
        if (messagingProvider == 0) {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            types = nArray;
        } else if (messagingProvider == 1) {
            int[] nArray = new int[2];
            nArray[1] = 2;
            types = nArray;
        } else {
            String errorMessage = "Invalid message provider '" + messagingProvider + "'";
            t.FFST(66, "NewConnectionFactoryObjectProvider.getFactoryTypes", 1, 0, errorMessage);
        }
        return types;
    }

    public String getFactoryTypeText(Trace t, int factoryType) {
        String textId = null;
        switch (factoryType) {
            case 0: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page2.ConnectionFactoryType";
                break;
            }
            case 1: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page2.QueueConnectionFactoryType";
                break;
            }
            case 2: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page2.TopicConnectionFactoryType";
                break;
            }
            default: {
                String errorMessage = "Invalid factory type '" + factoryType + "'";
                t.FFST(66, "NewConnectionFactoryObjectProvider.getFactoryTypeText", 2, 0, errorMessage);
            }
        }
        String text = JmsAdminPlugin.getMessage(textId);
        return text;
    }

    public int getFactoryType(Trace t, String factoryTypeText) {
        int type = -1;
        if (factoryTypeText.equals(this.getFactoryTypeText(t, 0))) {
            type = 0;
        } else if (factoryTypeText.equals(this.getFactoryTypeText(t, 1))) {
            type = 1;
        } else if (factoryTypeText.equals(this.getFactoryTypeText(t, 2))) {
            type = 2;
        } else {
            String errorMessage = "Invalid factory type '" + factoryTypeText + "'";
            t.FFST(66, "NewConnectionFactoryObjectProvider.getFactoryType", 3, 0, errorMessage);
        }
        return type;
    }

    public String getFactoryTypeHelpText(Trace t, int factoryType) {
        Class factoryClass = null;
        String text = null;
        switch (factoryType) {
            case 0: {
                factoryClass = this.supportingXA ? MQXAConnectionFactory.class : MQConnectionFactory.class;
                text = JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.ConnectionFactoryTypeHelpText");
                break;
            }
            case 1: {
                factoryClass = this.supportingXA ? MQXAQueueConnectionFactory.class : MQQueueConnectionFactory.class;
                text = JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.QueueConnectionFactoryTypeHelpText");
                break;
            }
            case 2: {
                factoryClass = this.supportingXA ? MQXATopicConnectionFactory.class : MQTopicConnectionFactory.class;
                text = JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.Page2.TopicConnectionFactoryTypeHelpText");
                break;
            }
            default: {
                String errorMessage = "Invalid factory type '" + factoryType + "'";
                t.FFST(66, "NewConnectionFactoryObjectProvider.getFactoryTypeHelpText", 4, 0, errorMessage);
            }
        }
        if (factoryClass != null && text != null) {
            String className = factoryClass.getName();
            text = Message.format((String)text, (String)className);
        }
        return text;
    }

    public int[] getTransportTypes(Trace t, int messagingProvider) {
        int[] types = null;
        if (messagingProvider == 0) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            types = nArray;
        } else if (messagingProvider == 1) {
            types = new int[]{2, 4};
        } else {
            String errorMessage = "Invalid message provider '" + messagingProvider + "'";
            t.FFST(66, "NewConnectionFactoryObjectProvider.getTransportTypes", 5, 0, errorMessage);
        }
        return types;
    }

    public String getTransportTypeText(Trace t, int transportType) {
        String textId = null;
        switch (transportType) {
            case 0: {
                textId = "JmsAdmin.ConnectionFactory.TransportType.Bindings";
                break;
            }
            case 1: {
                textId = "JmsAdmin.ConnectionFactory.TransportType.Client";
                break;
            }
            case 2: {
                textId = "JmsAdmin.ConnectionFactory.TransportType.Direct";
                break;
            }
            case 4: {
                textId = "JmsAdmin.ConnectionFactory.TransportType.DirectHttp";
                break;
            }
            default: {
                String errorMessage = "Invalid transport type '" + transportType + "'";
                t.FFST(66, "NewConnectionFactoryObjectProvider.getTransportTypeText", 6, 0, errorMessage);
            }
        }
        String text = JmsAdminPlugin.getMessage(textId);
        return text;
    }

    public int getTransportType(Trace t, String transportTypeText) {
        int type = -1;
        if (transportTypeText.equals(this.getTransportTypeText(t, 0))) {
            type = 0;
        } else if (transportTypeText.equals(this.getTransportTypeText(t, 1))) {
            type = 1;
        } else if (transportTypeText.equals(this.getTransportTypeText(t, 2))) {
            type = 2;
        } else if (transportTypeText.equals(this.getTransportTypeText(t, 4))) {
            type = 4;
        } else {
            String errorMessage = "Invalid transport type '" + transportTypeText + "'";
            t.FFST(66, "NewConnectionFactoryObjectProvider.getTransportType", 7, 0, errorMessage);
        }
        return type;
    }

    public String getTransportTypeHelpText(Trace t, int transportType) {
        String textId = null;
        switch (transportType) {
            case 0: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page3.BindingsTransportTypeHelpText";
                break;
            }
            case 1: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page3.MQClientTransportTypeHelpText";
                break;
            }
            case 2: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page3.DirectTransportTypeHelpText";
                break;
            }
            case 4: {
                textId = "JmsAdmin.NewConnectionFactoryWizard.Page3.DirectHttpTransportTypeHelpText";
                break;
            }
            default: {
                String errorMessage = "Invalid transport type '" + transportType + "'";
                t.FFST(66, "NewConnectionFactoryObjectProvider.getTransportTypeHelpText", 8, 0, errorMessage);
            }
        }
        String text = JmsAdminPlugin.getMessage(textId);
        return text;
    }

    public boolean canUseXA(int messagingProvider) {
        return messagingProvider == 0;
    }

    public String getWizardTitle(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.NewWizard.Title");
    }

    public String getWizardPage1Title(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.NewWizard.Page1Title");
    }

    public String getWizardPage2Description(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.NewWizard.Page2Desc");
    }

    public String getWizardCreatingTaskText(Trace t, String typeId) {
        return JmsAdminPlugin.getMessage("JmsAdmin.ConnectionFactory.NewWizard.Creating");
    }

    public String getUseLikeObjectPromptText(Trace t) {
        return JmsAdminPlugin.getMessage("JmsAdmin.NewConnectionFactoryWizard.LikeObjectPage.PromptText");
    }
}

