/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.UiJmsObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class Utilities {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/base/Utilities.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String encodingType = "UTF-8";

    public static DmJmsObject getDmObject(UiJmsObject uiObject) {
        return (DmJmsObject)uiObject.getDmObject();
    }

    public static DmJmsObject getDmObject(MQExtObject extObject) {
        UiJmsObject uiObject = Utilities.getUiObject(extObject);
        DmJmsObject dmObject = null;
        if (uiObject != null) {
            dmObject = Utilities.getDmObject(uiObject);
        }
        return dmObject;
    }

    public static MQExtObject getExtObject(UiJmsObject uiObject) {
        return uiObject.getExternalObject();
    }

    public static UiJmsObject getUiObject(MQExtObject extObject) {
        return (UiJmsObject)((Object)extObject.getInternalObject());
    }

    public static String getUniqueId(Trace t, DmJmsAbstractContext context) {
        DmJmsInitialContext dmJmsInitialContext = context.getDmInitialContext(t);
        String initialContextNickname = dmJmsInitialContext.getAttributeValue(t, 13100, 0);
        String id = String.valueOf(initialContextNickname) + '.' + context.getFullName(t);
        return id;
    }

    public static String decodeUrl(Trace t, String inputURL) {
        String decodedURL;
        block2: {
            decodedURL = inputURL;
            try {
                decodedURL = URLDecoder.decode(decodedURL, encodingType);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "Utilities.decodeUrl", 900, "UnsupportedEncodingException decoding the URL:" + inputURL);
                t.data(66, "Utilities.decodeUrl", 900, e.getMessage());
            }
        }
        return decodedURL;
    }

    public static String encodeUrl(Trace t, String inputString) {
        String encodedURL;
        block2: {
            encodedURL = inputString;
            try {
                encodedURL = URLEncoder.encode(encodedURL, encodingType);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTracing) break block2;
                t.data(66, "Utilities.encodeUrl", 900, "UnsupportedEncodingException encoding the string:" + inputString);
                t.data(66, "Utilities.encodeUrl", 900, e.getMessage());
            }
        }
        return encodedURL;
    }
}

