/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginPromptDialog
extends Dialog {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/base/LoginPromptDialog.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    private String title;
    private String nickname;
    private String url;
    private String username;
    private String password;
    private Text usernameText;
    private Text passwordText;

    public LoginPromptDialog(Trace t, Shell sh, String titleText, String name, String providerURL, String initialUsername, String initialPassword, boolean modal) {
        super(sh);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (!modal) {
            this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        }
        this.setBlockOnOpen(true);
        this.title = titleText != null ? titleText : new String();
        this.nickname = name != null ? name : new String();
        this.url = providerURL != null ? providerURL : new String();
        this.username = initialUsername != null ? initialUsername : new String();
        this.password = initialPassword != null ? initialPassword : new String();
    }

    protected Control createDialogArea(Composite parent) {
        final Trace t = Trace.getDefault();
        Composite dialog = (Composite)super.createDialogArea(parent);
        UiUtils.setHelp((Control)dialog, (String)"com.ibm.mq.explorer.jmsadmin.infopop.UI_LoginPromptDialog");
        Text promptingLabel = new Text(dialog, 66);
        UiUtils.makeTextControlReadOnly((Trace)t, (Text)promptingLabel, (boolean)true);
        String promptingText = JmsAdminPlugin.getMessage("JmsAdmin.LoginDialog.Prompt.Label");
        promptingText = Message.format((String)promptingText, (String)this.nickname, (String)this.url);
        promptingLabel.setText(promptingText);
        GridData layout = new GridData(1808);
        layout.widthHint = 300;
        promptingLabel.setLayoutData((Object)layout);
        Label usernameLabel = new Label(dialog, 0);
        usernameLabel.setText(JmsAdminPlugin.getMessage("JmsAdmin.LoginDialog.Username.Label"));
        this.usernameText = new Text(dialog, 2048);
        GridData gridData = new GridData(768);
        this.usernameText.setLayoutData((Object)gridData);
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginPromptDialog.this.setOkButtonEnabled(t);
            }
        });
        Label passwordLabel = new Label(dialog, 0);
        passwordLabel.setText(JmsAdminPlugin.getMessage("JmsAdmin.LoginDialog.Password.Label"));
        this.passwordText = new Text(dialog, 0x400800);
        gridData = new GridData(768);
        this.passwordText.setLayoutData((Object)gridData);
        this.usernameText.setText(this.username);
        this.passwordText.setText(this.password);
        if (this.username.length() > 0) {
            this.passwordText.setFocus();
            this.passwordText.selectAll();
        } else {
            this.usernameText.setFocus();
        }
        return dialog;
    }

    private void setOkButtonEnabled(Trace t) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            String username = this.usernameText.getText();
            boolean enable = username.length() > 0;
            okButton.setEnabled(enable);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Trace t = Trace.getDefault();
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.setOkButtonEnabled(t);
        }
        return button;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.username = this.usernameText.getText();
            this.password = this.passwordText.getText();
        } else {
            this.password = null;
        }
        super.buttonPressed(buttonId);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

