/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChangingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsChildAddedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsClosingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsDeletingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsEventHandler;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsEventObserver;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsOpeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenameEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsRenamingEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopenedEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.events.DmJmsReopeningEvent;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsInitialContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsSubContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.Utilities;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextsFolderTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsInitialContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsSubContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsContextsFolder;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsSubContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsContextsFolderFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsSubContextFactory;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;

public class JmsAdminTreeNodeFactory
implements ITreeNodeFactory,
DmJmsEventObserver {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/base/JmsAdminTreeNodeFactory.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    static Hashtable treeNodes = new Hashtable();
    private static Vector subcontextsToNotOpen = new Vector();

    public void addChildrenToTreeNode(TreeNode parent) {
        Trace t = Trace.getDefault();
        boolean pluginEnabled = JmsAdminPlugin.isEnabled();
        if (pluginEnabled) {
            String parentId = parent.getId();
            if (parentId.equals("com.ibm.mq.explorer.treenode.wmq")) {
                JmsAdminTreeNodeFactory.addJmsContextsFolder(t, parent);
            } else if (parentId.equals("com.ibm.mq.explorer.jmsadmin.treenode.JMSContexts")) {
                this.addInitialContexts(t, parent);
            } else if (!parentId.startsWith("com.ibm.mq.explorer.jmsadmin.treenode.context.InitialContext") && parentId.startsWith("com.ibm.mq.explorer.jmsadmin.treenode.context.SubContext")) {
                this.handleSubContextSelection(t, parent);
            }
        }
    }

    static void addJmsContextsFolder(Trace t, TreeNode parent) {
        JmsContextsFolderTreeNode jmsContextsFolder = JmsAdminPlugin.getJmsContextsFolderTreeNode();
        if (jmsContextsFolder == null) {
            UiJmsContextsFolder uiJmsContextsFolder = UiJmsContextsFolderFactory.create(t, (MQExtObject)parent.getObject());
            MQExtObject jmsContextFolderExtObject = uiJmsContextsFolder.getExternalObject();
            jmsContextsFolder = new JmsContextsFolderTreeNode(t, parent, jmsContextFolderExtObject);
            JmsAdminPlugin.setJmsContextsFolderTreeNode(jmsContextsFolder);
            parent.addChildToNode((TreeNode)jmsContextsFolder, 0);
        }
    }

    private void addInitialContexts(Trace t, TreeNode parent) {
        Hashtable jmsContexts = JmsAdminPlugin.getAllJmsInitialContexts();
        Enumeration jmsContextsEnum = jmsContexts.elements();
        while (jmsContextsEnum.hasMoreElements()) {
            JmsContext jmsContext = (JmsContext)jmsContextsEnum.nextElement();
            if (jmsContext.getTreeNode() != null) continue;
            JmsInitialContextTreeNode treeNode = new JmsInitialContextTreeNode(t, parent, (JmsInitialContextExtObject)jmsContext.getExtObject());
            jmsContext.setTreeNode(treeNode);
            UiJmsContext uiJmsContext = jmsContext.getUiObject();
            uiJmsContext.setTreeNode(treeNode);
            parent.addChildToNode((TreeNode)treeNode, 0);
            DmJmsInitialContext dmJmsContext = jmsContext.getDmObject();
            treeNodes.put(dmJmsContext, treeNode);
            dmJmsContext.addObserver(this);
            if (!dmJmsContext.isOpen()) continue;
            this.jmsContextAlreadyOpen(t, dmJmsContext, treeNode);
        }
    }

    private void handleSubContextSelection(Trace t, TreeNode parent) {
        JmsSubContextExtObject jmsSubContextExtObject = (JmsSubContextExtObject)((Object)parent.getObject());
        DmJmsContext dmJmsSubContext = (DmJmsContext)Utilities.getDmObject(jmsSubContextExtObject);
        if (dmJmsSubContext.isOpen()) {
            this.jmsContextAlreadyOpen(t, dmJmsSubContext, (JmsContextTreeNode)parent);
        } else {
            int index = subcontextsToNotOpen.indexOf(dmJmsSubContext);
            if (index < 0) {
                ((JmsContextTreeNode)parent).contextOpening(t);
                JmsAdminMenuActions.asyncConnectToContext(t, dmJmsSubContext, UiPlugin.getShell(), false, false, false);
            } else {
                subcontextsToNotOpen.remove(dmJmsSubContext);
            }
        }
    }

    private void jmsContextAlreadyOpen(Trace t, DmJmsAbstractContext dmJmsContext, JmsContextTreeNode treeNode) {
        treeNode.contextOpen(t);
        this.addNewSubcontexts(t, treeNode, dmJmsContext);
    }

    public static JmsContextTreeNode getTreeNode(DmJmsAbstractContext dmJmsContext) {
        return (JmsContextTreeNode)((Object)treeNodes.get(dmJmsContext));
    }

    private JmsSubContextTreeNode addNewSubcontext(Trace t, JmsContextTreeNode parentTreeNode, DmJmsContext dmJmsSubContext) {
        JmsSubContextTreeNode subContextTreeNode = this.getSubcontextTreeNode(t, dmJmsSubContext);
        if (subContextTreeNode != null) {
            this.updateSubContext(t, subContextTreeNode, dmJmsSubContext);
        } else {
            JmsContextExtObject jmsParentContextExtObject = (JmsContextExtObject)((Object)parentTreeNode.getObject());
            UiJmsSubContext uiJmsSubContext = UiJmsSubContextFactory.create(t, dmJmsSubContext, jmsParentContextExtObject);
            JmsSubContextExtObject jmsSubContextExtObject = (JmsSubContextExtObject)uiJmsSubContext.getExternalObject();
            subContextTreeNode = new JmsSubContextTreeNode(t, (TreeNode)parentTreeNode, jmsSubContextExtObject);
            uiJmsSubContext.setTreeNode(subContextTreeNode);
            parentTreeNode.addChildToNode(subContextTreeNode, 0);
            treeNodes.put(dmJmsSubContext, subContextTreeNode);
            dmJmsSubContext.addObserver(this);
        }
        return subContextTreeNode;
    }

    private void updateSubContext(Trace t, JmsSubContextTreeNode treeNode, DmJmsContext newDmObject) {
        MQExtObject oldExtObject = (MQExtObject)treeNode.getObject();
        JmsContextExtObject oldParentExtObject = (JmsContextExtObject)oldExtObject.getParent();
        UiJmsSubContext newUiObject = UiJmsSubContextFactory.create(t, newDmObject, oldParentExtObject);
        newUiObject.setTreeNode(treeNode);
        JmsSubContextExtObject newExtObject = (JmsSubContextExtObject)newUiObject.getExternalObject();
        treeNode.setObject((Object)newExtObject);
        DmJmsContext oldDmObject = (DmJmsContext)Utilities.getDmObject(oldExtObject);
        treeNodes.remove(oldDmObject);
        treeNodes.put(newDmObject, treeNode);
        oldDmObject.deleteObserver(this);
        newDmObject.addObserver(this);
        if (oldDmObject.isOpen() && !newDmObject.isOpen()) {
            JmsAdminMenuActions.asyncConnectToContext(t, newDmObject, UiPlugin.getShell(), false, false, false);
        }
    }

    private JmsSubContextTreeNode getSubcontextTreeNode(Trace t, DmJmsContext dmJmsContext) {
        JmsSubContextTreeNode treeNode = null;
        Enumeration currentContexts = treeNodes.keys();
        DmJmsInitialContext initialContext = dmJmsContext.getDmInitialContext(t);
        while (currentContexts.hasMoreElements() && treeNode == null) {
            DmJmsInitialContext currentInitialContext;
            DmJmsAbstractContext currentDmContext = (DmJmsAbstractContext)currentContexts.nextElement();
            if (!(currentDmContext instanceof DmJmsContext) || !currentDmContext.equals(dmJmsContext) || (currentInitialContext = currentDmContext.getDmInitialContext(t)) != initialContext) continue;
            treeNode = (JmsSubContextTreeNode)((Object)treeNodes.get(currentDmContext));
        }
        return treeNode;
    }

    private void addNewSubcontexts(Trace t, JmsContextTreeNode parentTreeNode, DmJmsAbstractContext dmJmsContext) {
        Collection subContexts = dmJmsContext.getContexts(t);
        for (DmJmsContext dmJmsSubContext : subContexts) {
            this.addNewSubcontext(t, parentTreeNode, dmJmsSubContext);
        }
    }

    private void removeSubcontexts(Trace t, DmJmsAbstractContext parentDmJmsContext, boolean deletedOnly) {
        Enumeration knownSubcontexts = treeNodes.keys();
        while (knownSubcontexts.hasMoreElements()) {
            Collection actualSubcontexts;
            DmJmsAbstractContext currentSubcontext = (DmJmsAbstractContext)knownSubcontexts.nextElement();
            DmJmsAbstractContext currentParent = currentSubcontext.getParent();
            if (currentParent == null || !currentParent.equals(parentDmJmsContext)) continue;
            boolean delete = true;
            if (deletedOnly && (actualSubcontexts = parentDmJmsContext.getContexts(t)).contains(currentSubcontext)) {
                delete = false;
            }
            if (!delete) continue;
            this.removeSubcontexts(t, currentSubcontext, false);
            JmsContextTreeNode currentTreeNode = JmsAdminTreeNodeFactory.getTreeNode(currentSubcontext);
            TreeNode parentTreeNode = currentTreeNode.getParent();
            parentTreeNode.removeChildFromNode((TreeNode)currentTreeNode);
            treeNodes.remove(currentSubcontext);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        final Trace t = Trace.getDefault();
        final JmsAdminTreeNodeFactory observer = this;
        UiPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DmJmsObject dmJmsObject = (DmJmsObject)o;
                DmJmsEventHandler.handleEvent(t, observer, dmJmsObject, arg);
            }
        });
    }

    @Override
    public void changedEventReceived(Trace t, DmJmsObject object, DmJmsChangedEvent event) {
    }

    @Override
    public void changingEventReceived(Trace t, DmJmsObject object, DmJmsChangingEvent event) {
    }

    @Override
    public void childAddedEventReceived(Trace t, DmJmsObject object, DmJmsChildAddedEvent event) {
        DmJmsObject dmJmsObject = event.getNewObject();
        if (dmJmsObject instanceof DmJmsContext) {
            JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode((DmJmsAbstractContext)object);
            JmsSubContextTreeNode jmsSubContextTreeNode = this.addNewSubcontext(t, treeNode, (DmJmsContext)dmJmsObject);
            jmsSubContextTreeNode.getParent().refresh();
        }
    }

    @Override
    public void closedEventReceived(Trace t, DmJmsObject object, DmJmsClosedEvent event) {
        DmJmsAbstractContext dmJmsContext;
        if (object instanceof DmJmsInitialContext && !(dmJmsContext = (DmJmsAbstractContext)object).isOpen()) {
            JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode(dmJmsContext);
            treeNode.contextClosed(t);
            this.removeSubcontexts(t, dmJmsContext, false);
            treeNode.refresh();
        }
    }

    @Override
    public void closingEventReceived(Trace t, DmJmsObject object, DmJmsClosingEvent event) {
    }

    @Override
    public void deletedEventReceived(Trace t, DmJmsObject object, DmJmsDeletedEvent event) {
        if (event.isNoError()) {
            object.deleteObserver(this);
            JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode((DmJmsAbstractContext)object);
            treeNode.removeFromNavigatorView();
            treeNodes.remove(object);
            treeNode.getParent().refresh();
        }
    }

    @Override
    public void deletingEventReceived(Trace t, DmJmsObject object, DmJmsDeletingEvent event) {
    }

    @Override
    public void openedEventReceived(Trace t, DmJmsObject object, DmJmsOpenedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)object;
        JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode(dmJmsContext);
        if (dmJmsContext.isOpen()) {
            treeNode.contextOpen(t);
            this.addNewSubcontexts(t, treeNode, dmJmsContext);
        } else {
            treeNode.contextClosed(t);
        }
        if (!event.isNoError()) {
            subcontextsToNotOpen.add(dmJmsContext);
        }
        treeNode.getParent().refresh();
    }

    @Override
    public void openingEventReceived(Trace t, DmJmsObject object, DmJmsOpeningEvent event) {
        JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode((DmJmsAbstractContext)object);
        treeNode.contextOpening(t);
    }

    @Override
    public void renameEventReceived(Trace t, DmJmsObject object, DmJmsRenameEvent event) {
        if (event.isNoError()) {
            DmJmsContext newDmObject = (DmJmsContext)event.getNewObject();
            JmsSubContextTreeNode treeNode = (JmsSubContextTreeNode)JmsAdminTreeNodeFactory.getTreeNode((DmJmsAbstractContext)object);
            this.updateSubContext(t, treeNode, newDmObject);
            treeNode.getParent().refresh();
        }
    }

    @Override
    public void renamingEventReceived(Trace t, DmJmsObject object, DmJmsRenamingEvent event) {
    }

    @Override
    public void reopenedEventReceived(Trace t, DmJmsObject object, DmJmsReopenedEvent event) {
        DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)object;
        JmsContextTreeNode treeNode = JmsAdminTreeNodeFactory.getTreeNode(dmJmsContext);
        this.removeSubcontexts(t, (DmJmsAbstractContext)object, true);
        this.addNewSubcontexts(t, treeNode, dmJmsContext);
        if (!event.isNoError()) {
            subcontextsToNotOpen.add(dmJmsContext);
        }
        treeNode.getParent().refresh();
    }

    @Override
    public void reopeningEventReceived(Trace t, DmJmsObject object, DmJmsReopeningEvent event) {
    }

    @Override
    public void unknownDataModelEventReceived(Trace t, Object event) {
        JmsAdminPlugin.unknownDataModelEventReceived(t, event);
    }
}

