/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.base.JmsAdminDataModel;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.JmsAdminCommon;
import com.ibm.mq.explorer.jmsadmin.ui.extensions.JmsInitialContextExtObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminMenuActions;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminTreeNodeFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.ObjectHandlerFactoryManager;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.JmsConnectionFactoryFilterProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextFilterProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextsFolderContentPage;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContextsFolderTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsInitialContextTreeNode;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.UiJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.ui.internal.defaults.JmsUnknownFilterProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.destinations.JmsDestinationFilterProvider;
import com.ibm.mq.explorer.jmsadmin.ui.internal.objects.UiJmsContextFactory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.j2se.J2SEComponent;
import com.ibm.msg.client.wmq.factories.WMQComponent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JmsAdminPlugin
extends AbstractUIPlugin {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/base/JmsAdminPlugin.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static final String pluginId = "com.ibm.mq.explorer.jmsadmin";
    private static JmsAdminPlugin plugin;
    private static ResourceBundle resourceBundle;
    private static boolean pluginEnabled;
    private static boolean explorerInitialised;
    private static JmsAdminDataModel dataModel;
    private static JmsContextsFolderTreeNode jmsContextsFolderTreeNode;
    private static JmsContextsFolderContentPage jmsContextsFolderContentPage;
    private static Message messages;
    private static Hashtable jmsInitialContexts;
    private static boolean loadedContextsFromDatamodel;
    private static JmsDestinationFilterProvider jmsDestinationFilterProvider;
    private static JmsConnectionFactoryFilterProvider jmsConnectionFactoryFilterProvider;
    private static JmsUnknownFilterProvider jmsUnknownFilterProvider;
    private static JmsContextFilterProvider jmsContextFilterProvider;

    static {
        jmsInitialContexts = new Hashtable();
        loadedContextsFromDatamodel = false;
        jmsDestinationFilterProvider = new JmsDestinationFilterProvider();
        jmsConnectionFactoryFilterProvider = new JmsConnectionFactoryFilterProvider();
        jmsUnknownFilterProvider = new JmsUnknownFilterProvider();
        jmsContextFilterProvider = new JmsContextFilterProvider();
    }

    public JmsAdminPlugin() {
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.mq.explorer.jmsadmin.JmsAdminPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ComponentManager compManager = ComponentManager.getInstance();
        J2SEComponent comp1 = new J2SEComponent();
        compManager.registerComponent((Component)comp1);
        WMQComponent comp2 = new WMQComponent();
        compManager.registerComponent((Component)comp2);
    }

    static boolean isEnabled() {
        return pluginEnabled;
    }

    static void enable() {
        Trace t = Trace.getDefault();
        pluginEnabled = true;
        if (explorerInitialised) {
            JmsAdminPlugin.initialise(t);
        }
    }

    static void initialise(Trace t) {
        explorerInitialised = true;
        if (pluginEnabled) {
            ObjectHandlerFactoryManager manager = new ObjectHandlerFactoryManager(t);
            manager.loadInternalObjectHandlerFactories(t);
            ArrayList objectHandlerFactories = manager.getList();
            messages = new Message(t, "com.ibm.mq.explorer.jmsadmin.ui.internal.base.JMSAdminStrings", JmsAdminPlugin.class.getClassLoader());
            String stateLocation = JmsAdminPlugin.getDefault().getStateLocation().toString();
            ClassLoader classLoader = JmsAdminPlugin.class.getClassLoader();
            dataModel = new JmsAdminDataModel(t, stateLocation, classLoader, objectHandlerFactories);
            if (Trace.isTracing) {
                t.data(66, "JmsAdminPlugin.initialise", "JMS Admin data store: " + stateLocation);
            }
            if (jmsContextsFolderTreeNode == null) {
                TreeNode mqRootTreeNode = UiPlugin.getUiMachineObject().getTreeNode();
                JmsAdminTreeNodeFactory.addJmsContextsFolder(t, mqRootTreeNode);
                mqRootTreeNode.refresh();
            }
            JmsAdminPlugin.loadJmsInitialContextsFromDataModel(t);
        }
    }

    static void disable(Trace t) {
        if (dataModel != null) {
            dataModel.close(t);
        }
        pluginEnabled = false;
        explorerInitialised = true;
    }

    public static JmsAdminPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JmsAdminPlugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static void setResourceBundle(ResourceBundle bundle) {
        resourceBundle = bundle;
    }

    private static void loadJmsInitialContextsFromDataModel(Trace t) {
        JmsAdminPlugin.loadJmsInitialContextsFromDataModel(t, false);
    }

    public static void loadJmsInitialContextsFromDataModel(Trace t, boolean merge) {
        if (!loadedContextsFromDatamodel || merge) {
            if (!merge) {
                jmsInitialContexts = new Hashtable();
            }
            ArrayList dmJmsContexts = dataModel.getInitialContexts();
            int i = 0;
            while (i < dmJmsContexts.size()) {
                DmJmsInitialContext dmJmsContext = (DmJmsInitialContext)dmJmsContexts.get(i);
                if (!jmsInitialContexts.containsKey(dmJmsContext.getTitle())) {
                    JmsAdminPlugin.createJmsInitalContext(t, dmJmsContext);
                    Hashtable environment = dmJmsContext.getEnvironment();
                    String autoreconnect = (String)environment.get("AUTORECONNECT");
                    if (autoreconnect != null && autoreconnect.equals(JmsAdminCommon.TRUE_TOGGLE)) {
                        JmsAdminMenuActions.asyncConnectToContext(t, dmJmsContext, UiPlugin.getShell(), false, false, false);
                    }
                }
                ++i;
            }
            loadedContextsFromDatamodel = true;
        }
    }

    public static JmsAdminDataModel getDatamodel() {
        return dataModel;
    }

    public static String getMessage(String key) {
        return messages.getMessage(key);
    }

    public static JmsContextsFolderTreeNode getJmsContextsFolderTreeNode() {
        return jmsContextsFolderTreeNode;
    }

    public static void setJmsContextsFolderTreeNode(JmsContextsFolderTreeNode treeNode) {
        jmsContextsFolderTreeNode = treeNode;
    }

    public static void setJmsContextsFolderContentPage(JmsContextsFolderContentPage contentPage) {
        jmsContextsFolderContentPage = contentPage;
    }

    public static JmsContext createJmsInitialContext(Trace t, Shell sh, String name, Hashtable environment, URL[] requiredLibraryLocations) {
        JmsContext jmsContext = null;
        if (JmsAdminPlugin.getJmsInitialContext(name) == null) {
            try {
                DmJmsInitialContext dmJmsContext = null;
                dmJmsContext = requiredLibraryLocations == null ? new DmJmsInitialContext(t, environment, name) : new DmJmsInitialContext(t, environment, name, requiredLibraryLocations);
                JmsAdminPlugin.getDatamodel().addInitialContext(t, dmJmsContext);
                jmsContext = JmsAdminPlugin.createJmsInitalContext(t, dmJmsContext);
            }
            catch (DmCoreException e) {
                MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
            }
        }
        return jmsContext;
    }

    private static JmsContext createJmsInitalContext(Trace t, DmJmsInitialContext dmJmsContext) {
        JmsContext jmsContext = null;
        UiJmsInitialContext jmsContextUiMQObject = UiJmsContextFactory.create(t, dmJmsContext);
        JmsInitialContextExtObject jmsContextExtObject = (JmsInitialContextExtObject)jmsContextUiMQObject.getExternalObject();
        String jmsContextId = dmJmsContext.getTitle();
        jmsContext = new JmsContext(t, jmsContextId, dmJmsContext, jmsContextUiMQObject, jmsContextExtObject);
        jmsInitialContexts.put(jmsContextId, jmsContext);
        JmsAdminPlugin.refreshJmsInitialContexts();
        if (jmsContextsFolderTreeNode != null && jmsContext.getTreeNode() != null) {
            UiPlugin.getMQNavigatorView().getTreeViewer().reveal((Object)jmsContext.getTreeNode());
        }
        if (jmsContextsFolderContentPage != null) {
            jmsContextsFolderContentPage.addJmsContext(t, dmJmsContext);
        }
        return jmsContext;
    }

    private static void refreshJmsInitialContexts() {
        if (jmsContextsFolderTreeNode != null) {
            jmsContextsFolderTreeNode.getParent().refresh();
        }
    }

    public static void removeJmsInitialContext(Trace t, Shell sh, JmsContext jmsContext) {
        DmJmsInitialContext dmJmsContext = jmsContext.getDmObject();
        try {
            if (dmJmsContext.isOpen()) {
                dmJmsContext.close(t);
            }
            JmsAdminPlugin.getDatamodel().removeInitialContext(t, dmJmsContext);
            JmsInitialContextTreeNode treeNode = jmsContext.getTreeNode();
            if (treeNode != null) {
                JmsAdminPlugin.getJmsContextsFolderTreeNode().removeChildFromNode(treeNode);
            }
            jmsInitialContexts.remove(jmsContext.getId());
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
        JmsAdminPlugin.refreshJmsInitialContexts();
        if (jmsContextsFolderContentPage != null) {
            jmsContextsFolderContentPage.removeJmsContext(t, dmJmsContext);
        }
    }

    public static JmsContext getJmsInitialContext(String Id) {
        return (JmsContext)jmsInitialContexts.get(Id);
    }

    public static Hashtable getAllJmsInitialContexts() {
        return jmsInitialContexts;
    }

    public static String getPluginId() {
        return pluginId;
    }

    public static JmsDestinationFilterProvider getJmsDestinationFilterProvider() {
        return jmsDestinationFilterProvider;
    }

    public static JmsConnectionFactoryFilterProvider getJmsConnectionFactoryFilterProvider() {
        return jmsConnectionFactoryFilterProvider;
    }

    public static JmsUnknownFilterProvider getJmsUnknownFilterProvider() {
        return jmsUnknownFilterProvider;
    }

    public static JmsContextFilterProvider getJmsContextFilterProvider() {
        return jmsContextFilterProvider;
    }

    public static void unknownDataModelEventReceived(Trace t, Object event) {
        String helpID = "AMQ4437";
        String message = CommonServices.getSystemMessage((String)helpID);
        String className = null;
        if (event != null) {
            className = event.getClass().toString();
        }
        message = Message.format((String)message, className);
        t.FFST(66, "JmsAdminPlugin.unknownDataModelEventReceived", 0, 0, message);
    }
}

