/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.jmsadmin.ui.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsAbstractContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsInitialContext;
import com.ibm.mq.explorer.jmsadmin.core.internal.objects.DmJmsObject;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminPlugin;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminTreeNodeFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.JmsAdminWizDlg;
import com.ibm.mq.explorer.jmsadmin.ui.internal.base.MandatoryFieldInputValidator;
import com.ibm.mq.explorer.jmsadmin.ui.internal.connectionfactories.UiJmsConnectionFactory;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.AddJmsContextWiz;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.ContextConnector;
import com.ibm.mq.explorer.jmsadmin.ui.internal.contexts.JmsContext;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class JmsAdminMenuActions {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.jmsadmin/src/com/ibm/mq/explorer/jmsadmin/ui/internal/base/JmsAdminMenuActions.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";

    public static void addInitialContext(Shell sh) {
        AddJmsContextWiz addJmsContextWiz = new AddJmsContextWiz();
        JmsAdminWizDlg wizardDialog = new JmsAdminWizDlg(sh, (IWizard)addJmsContextWiz);
        wizardDialog.create();
        wizardDialog.open();
    }

    public static boolean connectToContext(Trace t, DmJmsAbstractContext dmJmsContext, Shell sh, boolean reconnect, boolean visible, boolean modalDialogs) {
        ContextConnector connector = new ContextConnector(t, dmJmsContext, sh);
        boolean result = connector.connect(t, reconnect, visible, modalDialogs);
        return result;
    }

    public static void asyncConnectToContext(Trace t, DmJmsAbstractContext dmJmsContext, Shell sh, boolean reconnect, boolean visible, boolean modalDialogs) {
        ContextConnector connector = new ContextConnector(t, dmJmsContext, sh);
        connector.asyncConnect(t, reconnect, visible, modalDialogs);
    }

    public static void disconnectFromContext(Trace t, DmJmsAbstractContext dmJmsContext, Shell sh) {
        try {
            dmJmsContext.close(t);
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
    }

    public static void removeInitialContext(JmsContext jmsContext, Shell sh) {
        Trace t = Trace.getDefault();
        String helpID = "AMQ4446";
        String message = CommonServices.getSystemMessage((String)helpID);
        DmJmsInitialContext dmJmsContext = jmsContext.getDmObject();
        int remove = MessageBox.showYesNoMessage((Trace)t, (Shell)sh, (String)(message = Message.format((String)message, (String)dmJmsContext.getTitle(), (String)dmJmsContext.getFullName(t))), (int)1, (String)helpID);
        if (remove == 0) {
            JmsAdminPlugin.removeJmsInitialContext(t, sh, jmsContext);
        }
    }

    public static void autoreconnectToggle(JmsContext jmsContext) {
        Trace t = Trace.getDefault();
        DmJmsInitialContext dmJmsInitialContext = jmsContext.getDmObject();
        if (dmJmsInitialContext != null) {
            boolean autoreconnectValue = dmJmsInitialContext.getAutoReconnect(t);
            dmJmsInitialContext.setAutoReconnect(t, !autoreconnectValue);
        }
    }

    public static void createNewSubContext(Shell sh, DmJmsAbstractContext dmJmsContext) {
        Trace t = Trace.getDefault();
        try {
            String title = JmsAdminPlugin.getMessage("JmsAdmin.JmsSubContext.NewNamePrompt.Title");
            String text = JmsAdminPlugin.getMessage("JmsAdmin.JmsSubContext.NewNamePrompt.Label");
            text = Message.format((String)text, (String)dmJmsContext.getFullName(t));
            MandatoryFieldInputValidator validator = new MandatoryFieldInputValidator();
            InputDialog newSubcontextDialog = new InputDialog(sh, title, text, null, (IInputValidator)validator);
            UiPlugin.getHelpSystem().setHelp((Control)sh, "com.ibm.mq.explorer.jmsadmin.infopop.UI_NewSubcontextDialog");
            if (newSubcontextDialog.open() == 0) {
                String name = newSubcontextDialog.getValue();
                dmJmsContext.createSubcontext(t, name);
            }
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
    }

    public static void deleteJmsObject(Shell sh, DmJmsObject dmJmsObject) {
        Trace t = Trace.getDefault();
        try {
            String helpID = "AMQ4447";
            String message = CommonServices.getSystemMessage((String)helpID);
            message = Message.format((String)message, (String)dmJmsObject.getTitle(), (String)dmJmsObject.getFullName(t));
            int remove = MessageBox.showDeleteCancelMessage((Trace)t, (Shell)sh, (String)message, (int)1, (String)helpID);
            if (remove == 0) {
                dmJmsObject.remove(t);
            }
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
    }

    public static void renameJmsObject(Shell sh, DmJmsObject dmJmsObject) {
        Trace t = Trace.getDefault();
        try {
            String oldName = dmJmsObject.getTitle();
            String fullName = dmJmsObject.getFullName(t);
            String title = JmsAdminPlugin.getMessage("JmsAdmin.JmsObject.RenamePrompt.Title");
            String text = JmsAdminPlugin.getMessage("JmsAdmin.JmsObject.RenamePrompt.Label");
            text = Message.format((String)text, (String)oldName, (String)fullName);
            MandatoryFieldInputValidator validator = new MandatoryFieldInputValidator();
            InputDialog renameDialog = new InputDialog(sh, title, text, oldName, (IInputValidator)validator);
            UiPlugin.getHelpSystem().setHelp((Control)sh, "com.ibm.mq.explorer.jmsadmin.infopop.UI_RenameObjectDialog");
            if (renameDialog.open() == 0) {
                String newName = renameDialog.getValue();
                dmJmsObject.rename(t, newName);
                if (dmJmsObject instanceof DmJmsAbstractContext) {
                    DmJmsAbstractContext dmJmsContext = (DmJmsAbstractContext)dmJmsObject;
                    JmsAdminTreeNodeFactory.getTreeNode(dmJmsContext).resetTreeNodeId();
                }
            }
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
    }

    public static void switchTransportType(Shell sh, UiJmsConnectionFactory uiJmsConnectionFactory, int transportType) {
        Trace t = Trace.getDefault();
        try {
            DmJmsAbstractConnectionFactory dmJmsConnectionFactory = (DmJmsAbstractConnectionFactory)uiJmsConnectionFactory.getDmObject();
            dmJmsConnectionFactory.setTransport(t, transportType);
            if (!uiJmsConnectionFactory.isMandatoryAttributesPresent(t)) {
                uiJmsConnectionFactory.showProperties(t, sh);
            }
        }
        catch (DmCoreException e) {
            MessageBox.showExceptionMessage((Trace)t, (Shell)sh, (DmCoreException)e);
        }
    }
}

